import React from 'react';
import { Link } from 'react-router-dom';
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { ArrowRight, Users, Building, ShoppingCart, Rocket, Zap, Check, Star, TrendingUp, Shield, Clock, Target } from "lucide-react";
import Navigation from "@/components/Navigation";
import Footer from "@/components/Footer";

const SolutionsPage = () => {
  const solutions = [
    {
      id: 'small-business',
      title: 'Small Business',
      description: 'Perfect for growing businesses that need professional email automation',
      icon: Users,
      color: 'from-blue-500 to-blue-600',
      features: [
        'Easy-to-use email templates',
        'Basic analytics and reporting',
        'Customer support',
        'Up to 10,000 emails/month',
        'Integration with popular tools'
      ],
      price: 'Starting at $29/month',
      badge: 'Most Popular',
      stats: {
        customers: '5,000+',
        emails: '1M+',
        satisfaction: '98%'
      }
    },
    {
      id: 'enterprise',
      title: 'Enterprise',
      description: 'Advanced features for large organizations with complex email needs',
      icon: Building,
      color: 'from-purple-500 to-purple-600',
      features: [
        'Advanced automation workflows',
        'Custom integrations',
        'Dedicated account manager',
        'Unlimited emails',
        'Advanced security features',
        'Custom reporting'
      ],
      price: 'Custom pricing',
      badge: 'Enterprise',
      stats: {
        customers: '500+',
        emails: '100M+',
        satisfaction: '99%'
      }
    },
    {
      id: 'agencies',
      title: 'Agencies',
      description: 'Built for marketing agencies managing multiple client campaigns',
      icon: Target,
      color: 'from-green-500 to-green-600',
      features: [
        'Multi-client management',
        'White-label solutions',
        'Advanced campaign tools',
        'Client reporting',
        'Team collaboration',
        'API access'
      ],
      price: 'Starting at $99/month',
      badge: 'Agency Focused',
      stats: {
        customers: '1,000+',
        emails: '50M+',
        satisfaction: '97%'
      }
    },
    {
      id: 'ecommerce',
      title: 'E-commerce',
      description: 'Specialized email automation for online stores and retail',
      icon: ShoppingCart,
      color: 'from-orange-500 to-orange-600',
      features: [
        'Abandoned cart recovery',
        'Product recommendations',
        'Order confirmation emails',
        'Customer segmentation',
        'Revenue tracking',
        'Shopify integration'
      ],
      price: 'Starting at $49/month',
      badge: 'E-commerce',
      stats: {
        customers: '2,000+',
        emails: '25M+',
        satisfaction: '96%'
      }
    },
    {
      id: 'startups',
      title: 'Startups',
      description: 'Scalable solution for fast-growing startups and tech companies',
      icon: Rocket,
      color: 'from-pink-500 to-pink-600',
      features: [
        'Rapid onboarding',
        'Scalable infrastructure',
        'Developer-friendly API',
        'Growth analytics',
        'A/B testing tools',
        'Startup-friendly pricing'
      ],
      price: 'Starting at $19/month',
      badge: 'Startup Ready',
      stats: {
        customers: '3,000+',
        emails: '15M+',
        satisfaction: '98%'
      }
    }
  ];

  const testimonials = [
    {
      name: "Sarah Johnson",
      role: "Marketing Director",
      company: "TechStart Inc.",
      solution: "Small Business",
      content: "FlashCore transformed our email marketing. We've seen a 300% increase in engagement and 150% more conversions.",
      rating: 5
    },
    {
      name: "Michael Chen",
      role: "CEO",
      company: "Global Retail Corp",
      solution: "Enterprise",
      content: "The enterprise features and dedicated support have been game-changing for our international operations.",
      rating: 5
    },
    {
      name: "Emily Rodriguez",
      role: "Agency Owner",
      company: "Digital Marketing Pro",
      solution: "Agencies",
      content: "Managing multiple clients has never been easier. The white-label features are exactly what we needed.",
      rating: 5
    }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Navigation />

      {/* Header */}
      <section className="container mx-auto px-4 py-12 md:py-20 text-center">
        <div className="max-w-4xl mx-auto">
          <Badge variant="secondary" className="mb-4">
            <Target className="w-3 h-3 mr-1" />
            Business Solutions
          </Badge>
          <h1 className="text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent">
            Solutions for Every Business
          </h1>
          <p className="text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto">
            From startups to enterprise, we have the perfect email automation solution to help your business grow and succeed.
          </p>
        </div>
      </section>

      {/* Solutions Grid */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
          {solutions.map((solution) => (
            <Card key={solution.id} className="hover:shadow-lg transition-shadow group">
              <CardHeader>
                <div className="flex items-center justify-between mb-4">
                  <div className={`w-12 h-12 bg-gradient-to-r ${solution.color} rounded-lg flex items-center justify-center`}>
                    <solution.icon className="w-6 h-6 text-white" />
                  </div>
                  <Badge className="bg-flashcore-purple text-white text-xs">
                    {solution.badge}
                  </Badge>
                </div>
                <CardTitle className="text-xl md:text-2xl">{solution.title}</CardTitle>
                <CardDescription className="text-base">
                  {solution.description}
                </CardDescription>
              </CardHeader>
              <CardContent className="space-y-6">
                <div className="space-y-3">
                  <h4 className="font-semibold text-sm">Key Features:</h4>
                  <ul className="space-y-2">
                    {solution.features.map((feature, index) => (
                      <li key={index} className="flex items-center text-sm text-muted-foreground">
                        <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                        {feature}
                      </li>
                    ))}
                  </ul>
                </div>
                
                <div className="space-y-3">
                  <div className="text-lg font-bold text-flashcore-purple">
                    {solution.price}
                  </div>
                  <div className="grid grid-cols-3 gap-4 text-center">
                    <div>
                      <div className="text-lg font-bold">{solution.stats.customers}</div>
                      <div className="text-xs text-muted-foreground">Customers</div>
                    </div>
                    <div>
                      <div className="text-lg font-bold">{solution.stats.emails}</div>
                      <div className="text-xs text-muted-foreground">Emails Sent</div>
                    </div>
                    <div>
                      <div className="text-lg font-bold">{solution.stats.satisfaction}</div>
                      <div className="text-xs text-muted-foreground">Satisfaction</div>
                    </div>
                  </div>
                </div>
                
                <div className="flex space-x-2">
                  <Link to={`/solutions/${solution.id}`} className="flex-1">
                    <Button variant="outline" size="sm" className="w-full">
                      Learn More
                    </Button>
                  </Link>
                  <Link to="/register" className="flex-1">
                    <Button size="sm" className="w-full bg-gradient-to-r from-flashcore-purple to-flashcore-green">
                      Get Started
                    </Button>
                  </Link>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>
      </section>

      {/* Comparison Table */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Compare Solutions</h2>
            <p className="text-muted-foreground">
              Find the perfect plan for your business needs.
            </p>
          </div>
          
          <div className="overflow-x-auto">
            <table className="w-full bg-background rounded-lg shadow-lg">
              <thead>
                <tr className="border-b">
                  <th className="p-4 text-left font-semibold">Features</th>
                  <th className="p-4 text-center font-semibold">Small Business</th>
                  <th className="p-4 text-center font-semibold">Enterprise</th>
                  <th className="p-4 text-center font-semibold">Agencies</th>
                  <th className="p-4 text-center font-semibold">E-commerce</th>
                  <th className="p-4 text-center font-semibold">Startups</th>
                </tr>
              </thead>
              <tbody>
                <tr className="border-b">
                  <td className="p-4 font-medium">Monthly Emails</td>
                  <td className="p-4 text-center">10,000</td>
                  <td className="p-4 text-center">Unlimited</td>
                  <td className="p-4 text-center">100,000</td>
                  <td className="p-4 text-center">50,000</td>
                  <td className="p-4 text-center">25,000</td>
                </tr>
                <tr className="border-b">
                  <td className="p-4 font-medium">Templates</td>
                  <td className="p-4 text-center">50+</td>
                  <td className="p-4 text-center">Unlimited</td>
                  <td className="p-4 text-center">200+</td>
                  <td className="p-4 text-center">100+</td>
                  <td className="p-4 text-center">75+</td>
                </tr>
                <tr className="border-b">
                  <td className="p-4 font-medium">Integrations</td>
                  <td className="p-4 text-center">10</td>
                  <td className="p-4 text-center">Unlimited</td>
                  <td className="p-4 text-center">25</td>
                  <td className="p-4 text-center">15</td>
                  <td className="p-4 text-center">20</td>
                </tr>
                <tr className="border-b">
                  <td className="p-4 font-medium">Support</td>
                  <td className="p-4 text-center">Email</td>
                  <td className="p-4 text-center">24/7 Phone</td>
                  <td className="p-4 text-center">Priority</td>
                  <td className="p-4 text-center">Email + Chat</td>
                  <td className="p-4 text-center">Email</td>
                </tr>
                <tr>
                  <td className="p-4 font-medium">Starting Price</td>
                  <td className="p-4 text-center font-bold text-flashcore-purple">$29/mo</td>
                  <td className="p-4 text-center font-bold text-flashcore-purple">Custom</td>
                  <td className="p-4 text-center font-bold text-flashcore-purple">$99/mo</td>
                  <td className="p-4 text-center font-bold text-flashcore-purple">$49/mo</td>
                  <td className="p-4 text-center font-bold text-flashcore-purple">$19/mo</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </section>

      {/* Testimonials */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">What Our Customers Say</h2>
            <p className="text-muted-foreground">
              See how businesses are transforming their email marketing with FlashCore.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8">
            {testimonials.map((testimonial, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow">
                <CardContent className="p-6">
                  <div className="flex items-center mb-4">
                    {[...Array(testimonial.rating)].map((_, i) => (
                      <Star key={i} className="w-4 h-4 text-yellow-400 fill-current" />
                    ))}
                  </div>
                  <p className="text-sm md:text-base text-muted-foreground mb-4">
                    "{testimonial.content}"
                  </p>
                  <div className="flex items-center justify-between">
                    <div>
                      <div className="font-semibold">{testimonial.name}</div>
                      <div className="text-sm text-muted-foreground">
                        {testimonial.role} at {testimonial.company}
                      </div>
                    </div>
                    <Badge variant="outline" className="text-xs">
                      {testimonial.solution}
                    </Badge>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Benefits Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Why Choose FlashCore?</h2>
            <p className="text-muted-foreground">
              Powerful features that help businesses of all sizes succeed.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Zap className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">Easy to Use</h3>
              <p className="text-sm text-muted-foreground">
                Intuitive interface that makes email marketing simple and effective.
              </p>
            </div>
            
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <TrendingUp className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">Proven Results</h3>
              <p className="text-sm text-muted-foreground">
                Increase engagement and conversions with data-driven insights.
              </p>
            </div>
            
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Shield className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">Enterprise Security</h3>
              <p className="text-sm text-muted-foreground">
                Bank-level security to protect your data and customer information.
              </p>
            </div>
            
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Clock className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">24/7 Support</h3>
              <p className="text-sm text-muted-foreground">
                Round-the-clock support to help you succeed at any time.
              </p>
            </div>
            
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Target className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">Advanced Targeting</h3>
              <p className="text-sm text-muted-foreground">
                Reach the right audience with sophisticated segmentation tools.
              </p>
            </div>
            
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Users className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">Team Collaboration</h3>
              <p className="text-sm text-muted-foreground">
                Work together seamlessly with team management features.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Ready to Get Started?</h2>
          <p className="text-lg md:text-xl mb-6 md:mb-8 opacity-90">
            Choose the perfect solution for your business and start growing today.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/register">
              <Button size="lg" variant="secondary" className="bg-white text-flashcore-purple hover:bg-gray-100">
                Start Free Trial
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/contact">
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-flashcore-purple">
                Talk to Sales
              </Button>
            </Link>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default SolutionsPage; 