import React from 'react';
import { Link } from 'react-router-dom';
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { ArrowRight, Zap, Shield, Mail, BarChart3, Users, CreditCard, Receipt, FileText, Check, Star, Play, Clock, TrendingUp, Globe, Lock } from "lucide-react";
import Navigation from "@/components/Navigation";
import Footer from "@/components/Footer";

const LandingPage = () => {
  return (
    <div className="min-h-screen bg-background">
      <Navigation />

      {/* Hero Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 text-center">
        <div className="max-w-4xl mx-auto">
          <Badge variant="secondary" className="mb-4">
            <Zap className="w-3 h-3 mr-1" />
            Professional Email Automation
          </Badge>
          <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple via-flashcore-green to-flashcore-orange bg-clip-text text-transparent">
            FlashCore Pulse Dashboard
          </h1>
          <p className="text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto">
            Streamline your business communications with AI-powered email automation, 
            professional templates, and comprehensive analytics.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center mb-12">
            <Link to="/register">
              <Button size="lg" className="bg-gradient-to-r from-flashcore-purple to-flashcore-green">
                Start Free Trial
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/flash">
              <Button size="lg" variant="outline">
                <Play className="w-4 h-4 mr-2" />
                View Demo
              </Button>
            </Link>
          </div>
          
          {/* Stats */}
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 md:gap-8 mt-12 md:mt-16">
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">10K+</div>
              <div className="text-xs md:text-sm text-muted-foreground">Active Users</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-green mb-2">1M+</div>
              <div className="text-xs md:text-sm text-muted-foreground">Emails Sent</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-orange mb-2">99.9%</div>
              <div className="text-xs md:text-sm text-muted-foreground">Uptime</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-blue-500 mb-2">24/7</div>
              <div className="text-xs md:text-sm text-muted-foreground">Support</div>
            </div>
          </div>
        </div>
      </section>

      {/* How It Works */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="text-center mb-12 md:mb-16">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">How It Works</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Get started with FlashCore in just three simple steps
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          <div className="text-center">
            <div className="w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center mx-auto mb-4 md:mb-6">
              <span className="text-xl md:text-2xl font-bold text-white">1</span>
            </div>
            <h3 className="text-lg md:text-xl font-semibold mb-3 md:mb-4">Connect Your Account</h3>
            <p className="text-sm md:text-base text-muted-foreground">
              Sign up and connect your email accounts. We support all major email providers.
            </p>
          </div>
          
          <div className="text-center">
            <div className="w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r from-flashcore-green to-flashcore-purple rounded-full flex items-center justify-center mx-auto mb-4 md:mb-6">
              <span className="text-xl md:text-2xl font-bold text-white">2</span>
            </div>
            <h3 className="text-lg md:text-xl font-semibold mb-3 md:mb-4">Choose Templates</h3>
            <p className="text-sm md:text-base text-muted-foreground">
              Select from our library of professional templates or create your own custom designs.
            </p>
          </div>
          
          <div className="text-center">
            <div className="w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r from-flashcore-orange to-flashcore-purple rounded-full flex items-center justify-center mx-auto mb-4 md:mb-6">
              <span className="text-xl md:text-2xl font-bold text-white">3</span>
            </div>
            <h3 className="text-lg md:text-xl font-semibold mb-3 md:mb-4">Automate & Scale</h3>
            <p className="text-sm md:text-base text-muted-foreground">
              Set up automated workflows and watch your business communications scale effortlessly.
            </p>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="text-center mb-12 md:mb-16">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Powerful Features</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Everything you need to automate your business communications and grow your revenue.
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
          <Card className="hover:shadow-lg transition-shadow">
            <CardHeader>
              <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4">
                <Mail className="w-5 h-5 md:w-6 md:h-6 text-white" />
              </div>
              <CardTitle className="text-lg md:text-xl">Email Automation</CardTitle>
              <CardDescription>
                Automate your email workflows with professional templates and smart scheduling.
              </CardDescription>
            </CardHeader>
          </Card>

          <Card className="hover:shadow-lg transition-shadow">
            <CardHeader>
              <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-flashcore-green to-flashcore-purple rounded-lg flex items-center justify-center mb-4">
                <CreditCard className="w-5 h-5 md:w-6 md:h-6 text-white" />
              </div>
              <CardTitle className="text-lg md:text-xl">Billing & Invoices</CardTitle>
              <CardDescription>
                Generate professional billing emails and invoices with automated follow-ups.
              </CardDescription>
            </CardHeader>
          </Card>

          <Card className="hover:shadow-lg transition-shadow">
            <CardHeader>
              <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-blue-500 to-purple-500 rounded-lg flex items-center justify-center mb-4">
                <Receipt className="w-5 h-5 md:w-6 md:h-6 text-white" />
              </div>
              <CardTitle className="text-lg md:text-xl">Receipt Generation</CardTitle>
              <CardDescription>
                Create and send professional receipts with customizable templates.
              </CardDescription>
            </CardHeader>
          </Card>

          <Card className="hover:shadow-lg transition-shadow">
            <CardHeader>
              <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-purple-500 to-pink-500 rounded-lg flex items-center justify-center mb-4">
                <FileText className="w-5 h-5 md:w-6 md:h-6 text-white" />
              </div>
              <CardTitle className="text-lg md:text-xl">Transaction Management</CardTitle>
              <CardDescription>
                Handle transaction confirmations and statements with ease.
              </CardDescription>
            </CardHeader>
          </Card>

          <Card className="hover:shadow-lg transition-shadow">
            <CardHeader>
              <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-orange-500 to-red-500 rounded-lg flex items-center justify-center mb-4">
                <BarChart3 className="w-5 h-5 md:w-6 md:h-6 text-white" />
              </div>
              <CardTitle className="text-lg md:text-xl">Analytics & Insights</CardTitle>
              <CardDescription>
                Track email performance and get detailed analytics on your campaigns.
              </CardDescription>
            </CardHeader>
          </Card>

          <Card className="hover:shadow-lg transition-shadow">
            <CardHeader>
              <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-green-500 to-blue-500 rounded-lg flex items-center justify-center mb-4">
                <Shield className="w-5 h-5 md:w-6 md:h-6 text-white" />
              </div>
              <CardTitle className="text-lg md:text-xl">Enterprise Security</CardTitle>
              <CardDescription>
                Bank-level security with encryption and compliance standards.
              </CardDescription>
            </CardHeader>
          </Card>
        </div>
      </section>

      {/* Pricing Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="text-center mb-12 md:mb-16">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Simple, Transparent Pricing</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Choose the plan that fits your business needs. All plans include our core features.
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8 max-w-5xl mx-auto">
          {/* Basic Plan */}
          <Card className="relative">
            <CardHeader className="text-center">
              <CardTitle className="text-xl md:text-2xl">Basic</CardTitle>
              <div className="text-3xl md:text-4xl font-bold text-flashcore-purple">$9.99<span className="text-base md:text-lg text-muted-foreground">/month</span></div>
              <CardDescription>Perfect for small businesses</CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
              <div className="space-y-2">
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">1,000 emails per month</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Basic templates</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Email analytics</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">24/7 support</span>
                </div>
              </div>
              <Link to="/register">
                <Button className="w-full bg-gradient-to-r from-flashcore-purple to-flashcore-green">
                  Get Started
                </Button>
              </Link>
            </CardContent>
          </Card>

          {/* Pro Plan */}
          <Card className="relative border-2 border-flashcore-purple">
            <div className="absolute -top-3 left-1/2 transform -translate-x-1/2">
              <Badge className="bg-flashcore-purple text-white">Most Popular</Badge>
            </div>
            <CardHeader className="text-center">
              <CardTitle className="text-xl md:text-2xl">Pro</CardTitle>
              <div className="text-3xl md:text-4xl font-bold text-flashcore-green">$29.99<span className="text-base md:text-lg text-muted-foreground">/month</span></div>
              <CardDescription>For growing businesses</CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
              <div className="space-y-2">
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">10,000 emails per month</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Advanced templates</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Advanced analytics</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Priority support</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Custom branding</span>
                </div>
              </div>
              <Link to="/register">
                <Button className="w-full bg-gradient-to-r from-flashcore-green to-flashcore-purple">
                  Get Started
                </Button>
              </Link>
            </CardContent>
          </Card>

          {/* Enterprise Plan */}
          <Card className="relative">
            <CardHeader className="text-center">
              <CardTitle className="text-xl md:text-2xl">Enterprise</CardTitle>
              <div className="text-3xl md:text-4xl font-bold text-flashcore-orange">$99.99<span className="text-base md:text-lg text-muted-foreground">/month</span></div>
              <CardDescription>For large organizations</CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
              <div className="space-y-2">
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Unlimited emails</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Custom templates</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Advanced reporting</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">Dedicated support</span>
                </div>
                <div className="flex items-center">
                  <Check className="w-4 h-4 text-green-500 mr-2" />
                  <span className="text-sm md:text-base">API access</span>
                </div>
              </div>
              <Link to="/register">
                <Button className="w-full bg-gradient-to-r from-flashcore-orange to-flashcore-purple">
                  Get Started
                </Button>
              </Link>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Testimonials */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="text-center mb-12 md:mb-16">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">What Our Customers Say</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Join thousands of satisfied customers who trust FlashCore for their business communications.
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8">
          <Card className="p-4 md:p-6">
            <div className="flex items-center mb-4">
              {[...Array(5)].map((_, i) => (
                <Star key={i} className="w-4 h-4 text-yellow-400 fill-current" />
              ))}
            </div>
            <p className="text-sm md:text-base text-muted-foreground mb-4">
              "FlashCore has transformed how we handle customer communications. The automation features save us hours every week."
            </p>
            <div className="flex items-center">
              <div className="w-8 h-8 md:w-10 md:h-10 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center mr-3">
                <span className="text-white font-semibold text-sm md:text-base">S</span>
              </div>
              <div>
                <div className="font-semibold text-sm md:text-base">Sarah Johnson</div>
                <div className="text-xs md:text-sm text-muted-foreground">Marketing Director, TechCorp</div>
              </div>
            </div>
          </Card>

          <Card className="p-4 md:p-6">
            <div className="flex items-center mb-4">
              {[...Array(5)].map((_, i) => (
                <Star key={i} className="w-4 h-4 text-yellow-400 fill-current" />
              ))}
            </div>
            <p className="text-sm md:text-base text-muted-foreground mb-4">
              "The billing automation feature alone has increased our revenue by 30%. Highly recommended!"
            </p>
            <div className="flex items-center">
              <div className="w-8 h-8 md:w-10 md:h-10 bg-gradient-to-r from-flashcore-green to-flashcore-purple rounded-full flex items-center justify-center mr-3">
                <span className="text-white font-semibold text-sm md:text-base">M</span>
              </div>
              <div>
                <div className="font-semibold text-sm md:text-base">Mike Chen</div>
                <div className="text-xs md:text-sm text-muted-foreground">CEO, StartupXYZ</div>
              </div>
            </div>
          </Card>

          <Card className="p-4 md:p-6">
            <div className="flex items-center mb-4">
              {[...Array(5)].map((_, i) => (
                <Star key={i} className="w-4 h-4 text-yellow-400 fill-current" />
              ))}
            </div>
            <p className="text-sm md:text-base text-muted-foreground mb-4">
              "Professional templates and reliable delivery. FlashCore has become an essential part of our business."
            </p>
            <div className="flex items-center">
              <div className="w-8 h-8 md:w-10 md:h-10 bg-gradient-to-r from-flashcore-orange to-flashcore-purple rounded-full flex items-center justify-center mr-3">
                <span className="text-white font-semibold text-sm md:text-base">E</span>
              </div>
              <div>
                <div className="font-semibold text-sm md:text-base">Emily Rodriguez</div>
                <div className="text-xs md:text-sm text-muted-foreground">Operations Manager, RetailPlus</div>
              </div>
            </div>
          </Card>
        </div>
      </section>

      {/* CTA Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Ready to Transform Your Business?</h2>
          <p className="text-lg md:text-xl mb-6 md:mb-8 opacity-90">
            Join thousands of businesses using FlashCore to automate their communications.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/register">
              <Button size="lg" variant="secondary" className="bg-white text-flashcore-purple hover:bg-gray-100">
                Get Started Free
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/login">
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-flashcore-purple">
                Sign In
              </Button>
            </Link>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default LandingPage; 