import React from 'react';
import { Link } from 'react-router-dom';
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { 
  ArrowRight, 
  Building, 
  Check, 
  Star, 
  TrendingUp, 
  Shield, 
  Clock, 
  Target, 
  Mail, 
  BarChart3, 
  Zap, 
  Headphones,
  Globe,
  Users,
  Lock,
  Database,
  MessageSquare,
  Calendar,
  Award,
  Cpu,
  Network,
  FileText,
  Settings
} from "lucide-react";
import Navigation from "@/components/Navigation";
import Footer from "@/components/Footer";

const EnterprisePage = () => {
  const features = [
    {
      icon: Cpu,
      title: "Advanced Automation",
      description: "Complex multi-step workflows with conditional logic and dynamic content personalization."
    },
    {
      icon: Database,
      title: "Custom Integrations",
      description: "API access and custom integrations with your existing enterprise systems and databases."
    },
    {
      icon: Headphones,
      title: "Dedicated Account Manager",
      description: "Personal account manager with direct phone and email support for enterprise clients."
    },
    {
      icon: Globe,
      title: "Unlimited Emails",
      description: "No sending limits with enterprise-grade infrastructure and global delivery optimization."
    },
    {
      icon: Shield,
      title: "Advanced Security",
      description: "SOC 2 compliance, end-to-end encryption, and enterprise-grade security protocols."
    },
    {
      icon: BarChart3,
      title: "Custom Reporting",
      description: "Advanced analytics, custom dashboards, and detailed ROI tracking for enterprise teams."
    }
  ];

  const enterpriseBenefits = [
    {
      icon: TrendingUp,
      title: "Scale Without Limits",
      description: "Handle millions of emails with enterprise-grade infrastructure and global CDN."
    },
    {
      icon: Users,
      title: "Team Collaboration",
      description: "Advanced user management, role-based permissions, and team workflow approvals."
    },
    {
      icon: Lock,
      title: "Compliance & Security",
      description: "GDPR, HIPAA, and SOC 2 compliant with enterprise-grade security measures."
    },
    {
      icon: Network,
      title: "Global Infrastructure",
      description: "Multi-region deployment with 99.9% uptime SLA and disaster recovery."
    }
  ];

  const testimonials = [
    {
      name: "Michael Chen",
      role: "VP of Marketing",
      company: "Global Retail Corp",
      content: "FlashCore's enterprise features have transformed our global email operations. The dedicated support and custom integrations have been game-changing for our international teams.",
      rating: 5
    },
    {
      name: "Jennifer Williams",
      role: "Director of Digital Marketing",
      company: "Fortune 500 Tech",
      content: "The advanced automation and custom reporting capabilities have given us unprecedented insights into our customer journey. ROI has increased by 400%.",
      rating: 5
    },
    {
      name: "Robert Martinez",
      role: "CTO",
      company: "Healthcare Solutions Inc",
      content: "Security and compliance were our top priorities. FlashCore's enterprise security features and SOC 2 compliance made the decision easy for our healthcare organization.",
      rating: 5
    }
  ];

  const enterpriseFeatures = [
    "Unlimited email sending",
    "Advanced automation workflows",
    "Custom API integrations",
    "Dedicated account manager",
    "24/7 priority support",
    "Custom reporting & analytics",
    "Advanced user management",
    "Role-based permissions",
    "Team workflow approvals",
    "Global infrastructure",
    "99.9% uptime SLA",
    "SOC 2 compliance",
    "GDPR & HIPAA ready",
    "Custom data retention",
    "Advanced security protocols",
    "Disaster recovery",
    "Custom onboarding",
    "Training & certification"
  ];

  const stats = [
    { label: "Enterprise Customers", value: "500+" },
    { label: "Emails Sent Monthly", value: "100M+" },
    { label: "Customer Satisfaction", value: "99%" },
    { label: "Average ROI Increase", value: "400%" }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Navigation />

      {/* Hero Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-4xl mx-auto text-center">
          <Badge variant="secondary" className="mb-4">
            <Building className="w-3 h-3 mr-1" />
            Enterprise Solution
          </Badge>
          <h1 className="text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent">
            Enterprise Email Marketing at Scale
          </h1>
          <p className="text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto">
            Power your enterprise email marketing with advanced automation, unlimited scalability, 
            and enterprise-grade security. Built for organizations that demand excellence.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/contact">
              <Button size="lg" className="bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white">
                Contact Sales
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/contact">
              <Button size="lg" variant="outline">
                Schedule Demo
              </Button>
            </Link>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 md:gap-8">
            {stats.map((stat, index) => (
              <div key={index} className="text-center">
                <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">
                  {stat.value}
                </div>
                <div className="text-sm text-muted-foreground">
                  {stat.label}
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Enterprise-Grade Features</h2>
            <p className="text-muted-foreground">
              Advanced capabilities designed for large organizations with complex needs.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
            {features.map((feature, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow">
                <CardContent className="p-6">
                  <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4">
                    <feature.icon className="w-6 h-6 text-white" />
                  </div>
                  <h3 className="text-lg font-semibold mb-2">{feature.title}</h3>
                  <p className="text-sm text-muted-foreground">
                    {feature.description}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Benefits Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Why Enterprises Choose FlashCore</h2>
            <p className="text-muted-foreground">
              Built for organizations that need reliability, security, and scale.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-8">
            {enterpriseBenefits.map((benefit, index) => (
              <div key={index} className="flex items-start space-x-4">
                <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center flex-shrink-0">
                  <benefit.icon className="w-6 h-6 text-white" />
                </div>
                <div>
                  <h3 className="text-lg font-semibold mb-2">{benefit.title}</h3>
                  <p className="text-sm text-muted-foreground">
                    {benefit.description}
                  </p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Enterprise Features Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Complete Enterprise Solution</h2>
            <p className="text-muted-foreground">
              Everything you need to power your enterprise email marketing operations.
            </p>
          </div>
          
          <Card className="max-w-4xl mx-auto">
            <CardHeader className="text-center">
              <CardTitle className="text-2xl">Enterprise Plan</CardTitle>
              <CardDescription>
                Advanced features for large organizations with complex email marketing needs
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-6">
              <div className="text-center">
                <div className="text-4xl font-bold text-flashcore-purple mb-2">
                  Custom Pricing
                </div>
                <div className="text-sm text-muted-foreground">
                  Tailored to your organization's specific needs and volume
                </div>
              </div>
              
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div className="space-y-3">
                  <h4 className="font-semibold">Core Features:</h4>
                  <ul className="space-y-2">
                    {enterpriseFeatures.slice(0, 9).map((feature, index) => (
                      <li key={index} className="flex items-center text-sm">
                        <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                        {feature}
                      </li>
                    ))}
                  </ul>
                </div>
                <div className="space-y-3">
                  <h4 className="font-semibold">Advanced Features:</h4>
                  <ul className="space-y-2">
                    {enterpriseFeatures.slice(9).map((feature, index) => (
                      <li key={index} className="flex items-center text-sm">
                        <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                        {feature}
                      </li>
                    ))}
                  </ul>
                </div>
              </div>
              
              <div className="flex flex-col sm:flex-row gap-4">
                <Link to="/contact" className="flex-1">
                  <Button className="w-full bg-gradient-to-r from-flashcore-purple to-flashcore-green">
                    Contact Sales
                    <ArrowRight className="w-4 h-4 ml-2" />
                  </Button>
                </Link>
                <Link to="/contact" className="flex-1">
                  <Button variant="outline" className="w-full">
                    Schedule Demo
                  </Button>
                </Link>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Security & Compliance Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Enterprise Security & Compliance</h2>
            <p className="text-muted-foreground">
              Bank-level security and compliance for your most sensitive data.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8">
            <Card>
              <CardContent className="p-6 text-center">
                <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                  <Shield className="w-6 h-6 text-white" />
                </div>
                <h3 className="text-lg font-semibold mb-2">SOC 2 Compliant</h3>
                <p className="text-sm text-muted-foreground">
                  Annual SOC 2 Type II audits ensure your data is protected with enterprise-grade security.
                </p>
              </CardContent>
            </Card>
            
            <Card>
              <CardContent className="p-6 text-center">
                <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                  <Lock className="w-6 h-6 text-white" />
                </div>
                <h3 className="text-lg font-semibold mb-2">End-to-End Encryption</h3>
                <p className="text-sm text-muted-foreground">
                  All data is encrypted in transit and at rest using industry-standard encryption protocols.
                </p>
              </CardContent>
            </Card>
            
            <Card>
              <CardContent className="p-6 text-center">
                <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                  <FileText className="w-6 h-6 text-white" />
                </div>
                <h3 className="text-lg font-semibold mb-2">GDPR & HIPAA Ready</h3>
                <p className="text-sm text-muted-foreground">
                  Built-in compliance features for data protection regulations and healthcare requirements.
                </p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Testimonials Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">What Enterprise Leaders Say</h2>
            <p className="text-muted-foreground">
              Trusted by Fortune 500 companies and global enterprises worldwide.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8">
            {testimonials.map((testimonial, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow">
                <CardContent className="p-6">
                  <div className="flex items-center mb-4">
                    {[...Array(testimonial.rating)].map((_, i) => (
                      <Star key={i} className="w-4 h-4 text-yellow-400 fill-current" />
                    ))}
                  </div>
                  <p className="text-sm md:text-base text-muted-foreground mb-4">
                    "{testimonial.content}"
                  </p>
                  <div className="flex items-center justify-between">
                    <div>
                      <div className="font-semibold">{testimonial.name}</div>
                      <div className="text-sm text-muted-foreground">
                        {testimonial.role} at {testimonial.company}
                      </div>
                    </div>
                    <Badge variant="outline" className="text-xs">
                      Enterprise
                    </Badge>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Support Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Enterprise Support</h2>
            <p className="text-muted-foreground">
              Dedicated support designed for enterprise organizations.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8">
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Headphones className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">24/7 Phone Support</h3>
              <p className="text-sm text-muted-foreground">
                Round-the-clock phone support with dedicated enterprise team.
              </p>
            </div>
            
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Users className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">Dedicated Manager</h3>
              <p className="text-sm text-muted-foreground">
                Personal account manager for strategic guidance and support.
              </p>
            </div>
            
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Calendar className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">Custom Onboarding</h3>
              <p className="text-sm text-muted-foreground">
                Tailored onboarding process with training and certification.
              </p>
            </div>
            
            <div className="text-center">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                <Settings className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-lg font-semibold mb-2">Custom Solutions</h3>
              <p className="text-sm text-muted-foreground">
                Custom integrations and solutions for unique requirements.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Ready to Scale Your Enterprise?</h2>
          <p className="text-lg md:text-xl mb-6 md:mb-8 opacity-90">
            Join hundreds of enterprises that trust FlashCore for their email marketing at scale.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/contact">
              <Button size="lg" variant="secondary" className="bg-white text-flashcore-purple hover:bg-gray-100">
                Contact Sales
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/contact">
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-flashcore-purple">
                Schedule Demo
              </Button>
            </Link>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default EnterprisePage; 