import React from 'react';
import { Link } from 'react-router-dom';
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { 
  ArrowRight, 
  ShoppingCart, 
  Check, 
  Star, 
  TrendingUp, 
  Shield, 
  Users, 
  BarChart3
} from "lucide-react";
import Navigation from "@/components/Navigation";
import Footer from "@/components/Footer";

const EcommercePage = () => {
  const features = [
    {
      icon: ShoppingCart,
      title: "Abandoned Cart Recovery",
      description: "Automatically recover lost sales with personalized abandoned cart emails."
    },
    {
      icon: Users,
      title: "Product Recommendations",
      description: "Smart product recommendations based on browsing and purchase behavior."
    },
    {
      icon: Shield,
      title: "Order Confirmation Emails",
      description: "Professional order confirmations with tracking information."
    },
    {
      icon: BarChart3,
      title: "Customer Segmentation",
      description: "Segment customers by purchase history and preferences."
    },
    {
      icon: TrendingUp,
      title: "Revenue Tracking",
      description: "Track email-driven revenue and conversion rates."
    },
    {
      icon: ShoppingCart,
      title: "Shopify Integration",
      description: "Seamless integration with Shopify and other platforms."
    }
  ];

  const testimonials = [
    {
      name: "Lisa Chen",
      role: "E-commerce Manager",
      company: "Fashion Forward",
      content: "FlashCore's abandoned cart recovery has increased our revenue by 30%.",
      rating: 5
    },
    {
      name: "Marcus Johnson",
      role: "Founder",
      company: "Tech Gadgets Store",
      content: "The product recommendation engine is incredible. Our average order value increased by 40%.",
      rating: 5
    },
    {
      name: "Amanda Rodriguez",
      role: "Marketing Director",
      company: "Home & Garden Co",
      content: "Customer segmentation has transformed our email marketing with higher engagement.",
      rating: 5
    }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Navigation />

      {/* Hero Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-4xl mx-auto text-center">
          <Badge variant="secondary" className="mb-4">
            <ShoppingCart className="w-3 h-3 mr-1" />
            E-commerce Solution
          </Badge>
          <h1 className="text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent">
            Email Marketing Built for E-commerce
          </h1>
          <p className="text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto">
            Drive sales, recover abandoned carts, and build customer loyalty with 
            specialized email automation designed specifically for online stores.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/register">
              <Button size="lg" className="bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white">
                Start Free Trial
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/contact">
              <Button size="lg" variant="outline">
                Schedule Demo
              </Button>
            </Link>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 md:gap-8">
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">2,000+</div>
              <div className="text-sm text-muted-foreground">E-commerce Customers</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">25M+</div>
              <div className="text-sm text-muted-foreground">Emails Sent Monthly</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">96%</div>
              <div className="text-sm text-muted-foreground">Customer Satisfaction</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">25%</div>
              <div className="text-sm text-muted-foreground">Average Revenue Increase</div>
            </div>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">E-commerce Specific Features</h2>
            <p className="text-muted-foreground">
              Everything you need to drive sales and grow your online store.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
            {features.map((feature, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow">
                <CardContent className="p-6">
                  <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4">
                    <feature.icon className="w-6 h-6 text-white" />
                  </div>
                  <h3 className="text-lg font-semibold mb-2">{feature.title}</h3>
                  <p className="text-sm text-muted-foreground">
                    {feature.description}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Pricing Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Complete E-commerce Solution</h2>
            <p className="text-muted-foreground">
              Everything you need to drive sales and grow your online store.
            </p>
          </div>
          
          <Card className="max-w-4xl mx-auto">
            <CardHeader className="text-center">
              <CardTitle className="text-2xl">E-commerce Plan</CardTitle>
              <CardDescription>
                Specialized email marketing for online stores and retail businesses
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-6">
              <div className="text-center">
                <div className="text-4xl font-bold text-flashcore-purple mb-2">
                  $49/month
                </div>
                <div className="text-sm text-muted-foreground">
                  or $490/year (Save 17%)
                </div>
              </div>
              
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div className="space-y-3">
                  <h4 className="font-semibold">Core Features:</h4>
                  <ul className="space-y-2">
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Abandoned cart recovery
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Product recommendations
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Order confirmation emails
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Customer segmentation
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Revenue tracking
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Shopify integration
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      WooCommerce integration
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Custom product feeds
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Dynamic content
                    </li>
                  </ul>
                </div>
                <div className="space-y-3">
                  <h4 className="font-semibold">Advanced Features:</h4>
                  <ul className="space-y-2">
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      A/B testing
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Customer lifecycle emails
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Post-purchase follow-ups
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Inventory alerts
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Flash sale campaigns
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Customer reviews
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Loyalty program emails
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Seasonal campaigns
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Mobile-optimized emails
                    </li>
                  </ul>
                </div>
              </div>
              
              <div className="flex flex-col sm:flex-row gap-4">
                <Link to="/register" className="flex-1">
                  <Button className="w-full bg-gradient-to-r from-flashcore-purple to-flashcore-green">
                    Start Free Trial
                    <ArrowRight className="w-4 h-4 ml-2" />
                  </Button>
                </Link>
                <Link to="/contact" className="flex-1">
                  <Button variant="outline" className="w-full">
                    Talk to Sales
                  </Button>
                </Link>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Testimonials Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">What E-commerce Owners Say</h2>
            <p className="text-muted-foreground">
              Trusted by online stores worldwide to increase sales and customer retention.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8">
            {testimonials.map((testimonial, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow">
                <CardContent className="p-6">
                  <div className="flex items-center mb-4">
                    {[...Array(testimonial.rating)].map((_, i) => (
                      <Star key={i} className="w-4 h-4 text-yellow-400 fill-current" />
                    ))}
                  </div>
                  <p className="text-sm md:text-base text-muted-foreground mb-4">
                    "{testimonial.content}"
                  </p>
                  <div className="flex items-center justify-between">
                    <div>
                      <div className="font-semibold">{testimonial.name}</div>
                      <div className="text-sm text-muted-foreground">
                        {testimonial.role} at {testimonial.company}
                      </div>
                    </div>
                    <Badge variant="outline" className="text-xs">
                      E-commerce
                    </Badge>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Ready to Boost Your E-commerce Sales?</h2>
          <p className="text-lg md:text-xl mb-6 md:mb-8 opacity-90">
            Join thousands of online stores that trust FlashCore to drive sales and grow their business.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/register">
              <Button size="lg" variant="secondary" className="bg-white text-flashcore-purple hover:bg-gray-100">
                Start Free Trial
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/contact">
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-flashcore-purple">
                Schedule Demo
              </Button>
            </Link>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default EcommercePage; 