import React from 'react';
import { Link } from 'react-router-dom';
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { 
  ArrowRight, 
  Target, 
  Check, 
  Star, 
  TrendingUp, 
  Shield, 
  Users, 
  Mail, 
  BarChart3, 
  Zap, 
  Headphones,
  Palette,
  Briefcase,
  PieChart
} from "lucide-react";
import Navigation from "@/components/Navigation";
import Footer from "@/components/Footer";

const AgenciesPage = () => {
  const features = [
    {
      icon: Users,
      title: "Multi-Client Management",
      description: "Manage multiple clients from a single dashboard with separate workspaces and branding."
    },
    {
      icon: Palette,
      title: "White-Label Solutions",
      description: "Customize the platform with your agency's branding and logo for a seamless client experience."
    },
    {
      icon: BarChart3,
      title: "Client Reporting",
      description: "Generate professional reports for clients with custom dashboards and automated insights."
    },
    {
      icon: Zap,
      title: "Advanced Campaign Tools",
      description: "Powerful automation workflows and A/B testing tools to maximize campaign performance."
    },
    {
      icon: Briefcase,
      title: "Team Collaboration",
      description: "Role-based access control and team workflow approvals for efficient project management."
    },
    {
      icon: Shield,
      title: "API Access",
      description: "Full API access for custom integrations and automated client onboarding processes."
    }
  ];

  const testimonials = [
    {
      name: "Emily Rodriguez",
      role: "Agency Owner",
      company: "Digital Marketing Pro",
      content: "Managing multiple clients has never been easier. The white-label features are exactly what we needed to scale our agency.",
      rating: 5
    },
    {
      name: "Alex Thompson",
      role: "Creative Director",
      company: "Brand Boost Agency",
      content: "The client reporting features have transformed how we communicate results. Our clients are impressed with the detailed insights.",
      rating: 5
    },
    {
      name: "Sarah Kim",
      role: "Marketing Manager",
      company: "Growth Partners",
      content: "The multi-client management and team collaboration tools have streamlined our workflow significantly.",
      rating: 5
    }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Navigation />

      {/* Hero Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-4xl mx-auto text-center">
          <Badge variant="secondary" className="mb-4">
            <Target className="w-3 h-3 mr-1" />
            Agency Solution
          </Badge>
          <h1 className="text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent">
            Built for Marketing Agencies
          </h1>
          <p className="text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto">
            Scale your agency with powerful multi-client management, white-label solutions, 
            and professional reporting tools. Deliver exceptional results for your clients.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/register">
              <Button size="lg" className="bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white">
                Start Free Trial
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/contact">
              <Button size="lg" variant="outline">
                Schedule Demo
              </Button>
            </Link>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 md:gap-8">
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">1,000+</div>
              <div className="text-sm text-muted-foreground">Agency Customers</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">50M+</div>
              <div className="text-sm text-muted-foreground">Emails Sent Monthly</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">97%</div>
              <div className="text-sm text-muted-foreground">Customer Satisfaction</div>
            </div>
            <div className="text-center">
              <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">200%</div>
              <div className="text-sm text-muted-foreground">Average Revenue Increase</div>
            </div>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Agency-Focused Features</h2>
            <p className="text-muted-foreground">
              Everything you need to manage multiple clients and scale your agency.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
            {features.map((feature, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow">
                <CardContent className="p-6">
                  <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4">
                    <feature.icon className="w-6 h-6 text-white" />
                  </div>
                  <h3 className="text-lg font-semibold mb-2">{feature.title}</h3>
                  <p className="text-sm text-muted-foreground">
                    {feature.description}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Benefits Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Why Agencies Choose FlashCore</h2>
            <p className="text-muted-foreground">
              Built specifically for marketing agencies to grow and succeed.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-8">
            <div className="flex items-start space-x-4">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center flex-shrink-0">
                <TrendingUp className="w-6 h-6 text-white" />
              </div>
              <div>
                <h3 className="text-lg font-semibold mb-2">Scale Your Agency</h3>
                <p className="text-sm text-muted-foreground">
                  Handle unlimited clients and campaigns with enterprise-grade infrastructure.
                </p>
              </div>
            </div>
            
            <div className="flex items-start space-x-4">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center flex-shrink-0">
                <Users className="w-6 h-6 text-white" />
              </div>
              <div>
                <h3 className="text-lg font-semibold mb-2">Client Satisfaction</h3>
                <p className="text-sm text-muted-foreground">
                  Professional white-label experience that builds trust and strengthens client relationships.
                </p>
              </div>
            </div>
            
            <div className="flex items-start space-x-4">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center flex-shrink-0">
                <Shield className="w-6 h-6 text-white" />
              </div>
              <div>
                <h3 className="text-lg font-semibold mb-2">Data Security</h3>
                <p className="text-sm text-muted-foreground">
                  Bank-level security with client data isolation and compliance features.
                </p>
              </div>
            </div>
            
            <div className="flex items-start space-x-4">
              <div className="w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center flex-shrink-0">
                <PieChart className="w-6 h-6 text-white" />
              </div>
              <div>
                <h3 className="text-lg font-semibold mb-2">Revenue Growth</h3>
                <p className="text-sm text-muted-foreground">
                  Increase your service offerings and charge premium rates for email marketing services.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Agency Features Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">Complete Agency Solution</h2>
            <p className="text-muted-foreground">
              Everything you need to manage multiple clients and grow your agency.
            </p>
          </div>
          
          <Card className="max-w-4xl mx-auto">
            <CardHeader className="text-center">
              <CardTitle className="text-2xl">Agency Plan</CardTitle>
              <CardDescription>
                Professional tools for marketing agencies managing multiple clients
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-6">
              <div className="text-center">
                <div className="text-4xl font-bold text-flashcore-purple mb-2">
                  $99/month
                </div>
                <div className="text-sm text-muted-foreground">
                  or $990/year (Save 17%)
                </div>
              </div>
              
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div className="space-y-3">
                  <h4 className="font-semibold">Core Features:</h4>
                  <ul className="space-y-2">
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Multi-client management
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      White-label branding
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Client reporting dashboards
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Advanced automation workflows
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      A/B testing tools
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Team collaboration features
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Role-based permissions
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      API access & integrations
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Client data isolation
                    </li>
                  </ul>
                </div>
                <div className="space-y-3">
                  <h4 className="font-semibold">Advanced Features:</h4>
                  <ul className="space-y-2">
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Custom onboarding flows
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Revenue tracking
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Client communication tools
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Campaign templates
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Performance analytics
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Client portal access
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Automated reporting
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Bulk operations
                    </li>
                    <li className="flex items-center text-sm">
                      <Check className="w-4 h-4 text-green-500 mr-2 flex-shrink-0" />
                      Client billing integration
                    </li>
                  </ul>
                </div>
              </div>
              
              <div className="flex flex-col sm:flex-row gap-4">
                <Link to="/register" className="flex-1">
                  <Button className="w-full bg-gradient-to-r from-flashcore-purple to-flashcore-green">
                    Start Free Trial
                    <ArrowRight className="w-4 h-4 ml-2" />
                  </Button>
                </Link>
                <Link to="/contact" className="flex-1">
                  <Button variant="outline" className="w-full">
                    Talk to Sales
                  </Button>
                </Link>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Testimonials Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-2xl md:text-3xl font-bold mb-4">What Agency Owners Say</h2>
            <p className="text-muted-foreground">
              Trusted by marketing agencies worldwide to scale their operations.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8">
            {testimonials.map((testimonial, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow">
                <CardContent className="p-6">
                  <div className="flex items-center mb-4">
                    {[...Array(testimonial.rating)].map((_, i) => (
                      <Star key={i} className="w-4 h-4 text-yellow-400 fill-current" />
                    ))}
                  </div>
                  <p className="text-sm md:text-base text-muted-foreground mb-4">
                    "{testimonial.content}"
                  </p>
                  <div className="flex items-center justify-between">
                    <div>
                      <div className="font-semibold">{testimonial.name}</div>
                      <div className="text-sm text-muted-foreground">
                        {testimonial.role} at {testimonial.company}
                      </div>
                    </div>
                    <Badge variant="outline" className="text-xs">
                      Agency
                    </Badge>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Ready to Scale Your Agency?</h2>
          <p className="text-lg md:text-xl mb-6 md:mb-8 opacity-90">
            Join thousands of agencies that trust FlashCore to manage their client email marketing.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/register">
              <Button size="lg" variant="secondary" className="bg-white text-flashcore-purple hover:bg-gray-100">
                Start Free Trial
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/contact">
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-flashcore-purple">
                Schedule Demo
              </Button>
            </Link>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default AgenciesPage; 