import React from "react";
import LicenseActivation from "@/components/LicenseActivation";
import Layout from "@/components/Layout";
import { Zap } from "lucide-react";

const ActivationPage = () => {
  return (
    <Layout>
      <div className="space-y-6">
        {/* Header with Logo */}
        <div className="flex items-center gap-3">
          <div className="w-8 h-8 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center">
            <Zap className="w-5 h-5 text-white" />
          </div>
          <div>
            <h1 className="text-3xl font-bold">License Activation</h1>
            <p className="text-muted-foreground">
              Activate your FlashCore license to unlock all features
            </p>
          </div>
        </div>

        <LicenseActivation />
      </div>
    </Layout>
  );
};

export default ActivationPage;
