import React from 'react';
import { Link } from 'react-router-dom';
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { ArrowRight, Users, Target, Award, Globe, Zap, Shield, TrendingUp, Heart, Lightbulb, Rocket, Star } from "lucide-react";
import Navigation from "@/components/Navigation";
import Footer from "@/components/Footer";

const AboutPage = () => {
  const team = [
    {
      name: "Sarah Johnson",
      role: "CEO & Founder",
      bio: "Former VP of Product at TechCorp with 15+ years in SaaS",
      avatar: "S",
      color: "from-flashcore-purple to-flashcore-green"
    },
    {
      name: "Mike Chen",
      role: "CTO",
      bio: "Ex-Google engineer with expertise in scalable systems",
      avatar: "M",
      color: "from-flashcore-green to-flashcore-purple"
    },
    {
      name: "Emily Rodriguez",
      role: "Head of Product",
      bio: "Product leader with experience at Stripe and Shopify",
      avatar: "E",
      color: "from-flashcore-orange to-flashcore-purple"
    },
    {
      name: "David Kim",
      role: "Head of Engineering",
      bio: "Full-stack expert with 10+ years building web applications",
      avatar: "D",
      color: "from-blue-500 to-purple-500"
    }
  ];

  const values = [
    {
      icon: Heart,
      title: "Customer First",
      description: "Every decision we make starts with our customers' needs and success."
    },
    {
      icon: Lightbulb,
      title: "Innovation",
      description: "We constantly push boundaries to deliver cutting-edge solutions."
    },
    {
      icon: Shield,
      title: "Security",
      description: "Enterprise-grade security is built into everything we do."
    },
    {
      icon: Users,
      title: "Collaboration",
      description: "We believe the best solutions come from working together."
    }
  ];

  const milestones = [
    {
      year: "2020",
      title: "Founded",
      description: "FlashCore was born from a vision to simplify business communications."
    },
    {
      year: "2021",
      title: "First 1,000 Users",
      description: "Reached our first major milestone with 1,000 active users."
    },
    {
      year: "2022",
      title: "Series A Funding",
      description: "Raised $10M to scale our platform and team."
    },
    {
      year: "2023",
      title: "10,000+ Users",
      description: "Helped over 10,000 businesses automate their communications."
    },
    {
      year: "2024",
      title: "Global Expansion",
      description: "Expanded to serve customers in 50+ countries worldwide."
    }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Navigation />

      {/* Header */}
      <section className="container mx-auto px-4 py-12 md:py-20 text-center">
        <div className="max-w-4xl mx-auto">
          <Badge variant="secondary" className="mb-4">
            <Users className="w-3 h-3 mr-1" />
            Our Story
          </Badge>
          <h1 className="text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent">
            About FlashCore
          </h1>
          <p className="text-lg md:text-xl text-muted-foreground mb-8 max-w-3xl mx-auto">
            We're on a mission to revolutionize how businesses communicate. 
            FlashCore was built by a team passionate about automation, efficiency, and helping companies grow.
          </p>
        </div>
      </section>

      {/* Mission Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 md:gap-12 items-center">
          <div>
            <h2 className="text-2xl md:text-3xl font-bold mb-4 md:mb-6">Our Mission</h2>
            <p className="text-base md:text-lg text-muted-foreground mb-4 md:mb-6">
              To empower businesses of all sizes with professional, automated communication tools that drive growth and efficiency.
            </p>
            <p className="text-muted-foreground mb-6 md:mb-8">
              We believe that every business deserves access to enterprise-grade email automation and communication tools. 
              That's why we've built FlashCore to be powerful yet simple, scalable yet affordable.
            </p>
            <div className="grid grid-cols-2 gap-4 md:gap-6">
              <div className="text-center">
                <div className="text-2xl md:text-3xl font-bold text-flashcore-purple mb-2">10K+</div>
                <div className="text-xs md:text-sm text-muted-foreground">Happy Customers</div>
              </div>
              <div className="text-center">
                <div className="text-2xl md:text-3xl font-bold text-flashcore-green mb-2">1M+</div>
                <div className="text-xs md:text-sm text-muted-foreground">Emails Sent</div>
              </div>
            </div>
          </div>
          <div className="relative">
            <div className="bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 text-white">
              <h3 className="text-xl md:text-2xl font-bold mb-4">Why FlashCore?</h3>
              <ul className="space-y-3">
                <li className="flex items-center">
                  <Zap className="w-4 h-4 md:w-5 md:h-5 mr-3" />
                  <span className="text-sm md:text-base">Built for modern businesses</span>
                </li>
                <li className="flex items-center">
                  <Shield className="w-4 h-4 md:w-5 md:h-5 mr-3" />
                  <span className="text-sm md:text-base">Enterprise-grade security</span>
                </li>
                <li className="flex items-center">
                  <TrendingUp className="w-4 h-4 md:w-5 md:h-5 mr-3" />
                  <span className="text-sm md:text-base">Proven to increase revenue</span>
                </li>
                <li className="flex items-center">
                  <Globe className="w-4 h-4 md:w-5 md:h-5 mr-3" />
                  <span className="text-sm md:text-base">Global reach and support</span>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </section>

      {/* Values Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="text-center mb-12 md:mb-16">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Our Values</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            These core values guide everything we do and every decision we make.
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8">
          {values.map((value, index) => (
            <Card key={index} className="text-center hover:shadow-lg transition-shadow">
              <CardHeader>
                <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4">
                  <value.icon className="w-5 h-5 md:w-6 md:h-6 text-white" />
                </div>
                <CardTitle className="text-base md:text-lg">{value.title}</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription className="text-sm md:text-base">{value.description}</CardDescription>
              </CardContent>
            </Card>
          ))}
        </div>
      </section>

      {/* Team Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="text-center mb-12 md:mb-16">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Meet Our Team</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            The passionate people behind FlashCore who are dedicated to your success.
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8">
          {team.map((member, index) => (
            <Card key={index} className="text-center hover:shadow-lg transition-shadow">
              <CardHeader>
                <div className={`w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r ${member.color} rounded-full flex items-center justify-center mx-auto mb-4`}>
                  <span className="text-white font-bold text-lg md:text-xl">{member.avatar}</span>
                </div>
                <CardTitle className="text-base md:text-lg">{member.name}</CardTitle>
                <CardDescription className="font-semibold text-flashcore-purple text-sm md:text-base">{member.role}</CardDescription>
              </CardHeader>
              <CardContent>
                <CardDescription className="text-sm md:text-base">{member.bio}</CardDescription>
              </CardContent>
            </Card>
          ))}
        </div>
      </section>

      {/* Timeline Section */}
      <section className="container mx-auto px-4 py-12 md:py-20 bg-muted/20">
        <div className="text-center mb-12 md:mb-16">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Our Journey</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            From startup to industry leader - here's how we got here.
          </p>
        </div>
        
        <div className="max-w-4xl mx-auto">
          <div className="space-y-6 md:space-y-8">
            {milestones.map((milestone, index) => (
              <div key={index} className="flex items-start space-x-4 md:space-x-6">
                <div className="w-12 h-12 md:w-16 md:h-16 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center flex-shrink-0">
                  <span className="text-white font-bold text-sm md:text-base">{milestone.year}</span>
                </div>
                <div className="flex-1">
                  <h3 className="text-lg md:text-xl font-semibold mb-2">{milestone.title}</h3>
                  <p className="text-sm md:text-base text-muted-foreground">{milestone.description}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Awards Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="text-center mb-12 md:mb-16">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Recognition & Awards</h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Our commitment to excellence has been recognized by industry leaders.
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8">
          <Card className="text-center p-4 md:p-6">
            <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-yellow-400 to-orange-500 rounded-lg flex items-center justify-center mx-auto mb-4">
              <Award className="w-5 h-5 md:w-6 md:h-6 text-white" />
            </div>
            <h3 className="text-base md:text-lg font-semibold mb-2">Best Email Platform 2024</h3>
            <p className="text-xs md:text-sm text-muted-foreground">TechCrunch Startup Awards</p>
          </Card>
          
          <Card className="text-center p-4 md:p-6">
            <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-blue-500 to-purple-500 rounded-lg flex items-center justify-center mx-auto mb-4">
              <Star className="w-5 h-5 md:w-6 md:h-6 text-white" />
            </div>
            <h3 className="text-base md:text-lg font-semibold mb-2">Customer Choice Award</h3>
            <p className="text-xs md:text-sm text-muted-foreground">G2 Crowd 2024</p>
          </Card>
          
          <Card className="text-center p-4 md:p-6">
            <div className="w-10 h-10 md:w-12 md:h-12 bg-gradient-to-r from-green-500 to-blue-500 rounded-lg flex items-center justify-center mx-auto mb-4">
              <Target className="w-5 h-5 md:w-6 md:h-6 text-white" />
            </div>
            <h3 className="text-base md:text-lg font-semibold mb-2">Fastest Growing SaaS</h3>
            <p className="text-xs md:text-sm text-muted-foreground">Inc. 5000 2024</p>
          </Card>
        </div>
      </section>

      {/* CTA Section */}
      <section className="container mx-auto px-4 py-12 md:py-20">
        <div className="bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Join Our Mission</h2>
          <p className="text-lg md:text-xl mb-6 md:mb-8 opacity-90">
            Be part of the revolution in business communications. Start your journey with FlashCore today.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link to="/register">
              <Button size="lg" variant="secondary" className="bg-white text-flashcore-purple hover:bg-gray-100">
                Start Free Trial
                <ArrowRight className="w-4 h-4 ml-2" />
              </Button>
            </Link>
            <Link to="/contact">
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-flashcore-purple">
                Get In Touch
              </Button>
            </Link>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default AboutPage; 