import { useState, useEffect } from "react";
import { apiService } from "@/services/api";

export const useSubscriptionStatusPhp = () => {
  const [isActivated, setIsActivated] = useState(false);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const checkSubscriptionStatus = async () => {
      try {
        const response = await apiService.getSubscriptionStatus();
        
        if (response.error) {
          console.error('Error checking subscription:', response.error);
          setIsActivated(false);
        } else if (response.data) {
          const isActive = response.data.subscribed;
          setIsActivated(isActive);
        } else {
          setIsActivated(false);
        }
      } catch (error) {
        console.error('Error checking subscription status:', error);
        setIsActivated(false);
      } finally {
        setLoading(false);
      }
    };

    checkSubscriptionStatus();
  }, []);

  return { isActivated, loading };
};