import { useQuery } from "@tanstack/react-query";
import { apiService } from "@/services/api";

export const useRealDashboardDataPhp = () => {
  return useQuery({
    queryKey: ["realDashboardDataPhp"],
    queryFn: async () => {
      const response = await apiService.getDashboardData();
      
      if (response.error) {
        throw new Error(response.error);
      }
      
      return response.data;
    },
    staleTime: 1000 * 60 * 5, // 5 minutes
  });
};