import React, { useEffect, useState } from "react";
import Modal from "./Modal";
import { CheckCircle } from "lucide-react";

interface SuccessModalProps {
  isOpen?: boolean;
  onClose?: () => void;
  message?: string;
  duration?: number;
}

const SuccessModal: React.FC<SuccessModalProps> = ({ 
  isOpen: externalIsOpen,
  onClose,
  message = "Login successful!", 
  duration = 8000
}) => {
  const [internalIsOpen, setInternalIsOpen] = useState(true);
  
  const isOpen = externalIsOpen !== undefined ? externalIsOpen : internalIsOpen;
  
  const handleClose = () => {
    setInternalIsOpen(false);
    onClose?.();
  };
  
  useEffect(() => {
    if (isOpen) {
      const timer = setTimeout(() => {
        handleClose();
      }, duration);
      
      return () => clearTimeout(timer);
    }
  }, [isOpen, duration]);
  
  if (!isOpen) return null;
  
  return (
    <Modal isOpen={isOpen} onClose={handleClose}>
      <div className="flex flex-col items-center py-4">
        <CheckCircle size={64} className="text-flashcore-green mb-4" />
        <h2 className="text-xl font-semibold mb-2">{message}</h2>
        <p className="text-sm text-muted-foreground">
          Welcome back to your FLASHCORE dashboard
        </p>
      </div>
    </Modal>
  );
};

export default SuccessModal;