import React, { Suspense, lazy } from 'react';
import { BrowserRouter, Routes, Route } from 'react-router-dom';
import { QueryClient, QueryClientProvider } from '@tanstack/react-query';
import ProtectedRoute from './components/ProtectedRoute';
import AdminProtectedRoute from './components/AdminProtectedRoute';
import { Toaster } from "@/components/ui/toaster"
import { ThemeProvider } from "@/contexts/ThemeContext";
import ErrorBoundary from './components/ErrorBoundary';
import { TooltipProvider } from "@/components/ui/tooltip";
import TestLayout from './components/TestLayout';
import { AuthProvider } from './contexts/AuthContext';

// Lazy load all pages for better performance
const Dashboard = lazy(() => import('./pages/Dashboard'));
const LoginPage = lazy(() => import('./pages/LoginPage'));
const RegisterPage = lazy(() => import('./pages/RegisterPage'));
const ActivationPage = lazy(() => import('./pages/ActivationPage'));
const AdminDashboard = lazy(() => import('./pages/AdminDashboard'));
const CreateAdminPage = lazy(() => import('./pages/CreateAdminPage'));
const FlashPage = lazy(() => import('./pages/FlashPage'));
const ProfilePage = lazy(() => import('./pages/ProfilePage'));
const LandingPage = lazy(() => import('./pages/LandingPage'));
const PricingPage = lazy(() => import('./pages/PricingPage'));
const ContactPage = lazy(() => import('./pages/ContactPage'));
const AboutPage = lazy(() => import('./pages/AboutPage'));
const TemplatesPage = lazy(() => import('./pages/TemplatesPage'));
const IntegrationsPage = lazy(() => import('./pages/IntegrationsPage'));
const ApiPage = lazy(() => import('./pages/ApiPage'));
const SolutionsPage = lazy(() => import('./pages/SolutionsPage'));
const SmallBusinessPage = lazy(() => import('./pages/SmallBusinessPage'));
const EnterprisePage = lazy(() => import('./pages/EnterprisePage'));
const AgenciesPage = lazy(() => import('./pages/AgenciesPage'));
const EcommercePage = lazy(() => import('./pages/EcommercePage'));
const HelpCenterPage = lazy(() => import('./pages/HelpCenterPage'));
const BlogPage = lazy(() => import('./pages/BlogPage'));
const WebinarsPage = lazy(() => import('./pages/WebinarsPage'));
const CareersPage = lazy(() => import('./pages/CareersPage'));
const PressPage = lazy(() => import('./pages/PressPage'));
const DocsPage = lazy(() => import('./pages/DocsPage'));
const AdminLoginPage = lazy(() => import('./pages/AdminLoginPage'));
const SetupAdminPage = lazy(() => import('./pages/SetupAdminPage'));
const AdminBackupPage = lazy(() => import('./pages/AdminBackupPage'));
const LogoutPage = lazy(() => import('./pages/LogoutPage'));

// Loading component
const LoadingSpinner = () => (
  <div className="flex items-center justify-center min-h-screen">
    <div className="w-16 h-16 border-4 border-flashcore-purple border-t-transparent rounded-full animate-spin"></div>
  </div>
);

const queryClient = new QueryClient();

function App() {
  return (
    <ErrorBoundary>
      <QueryClientProvider client={queryClient}>
        <ThemeProvider>
          <TooltipProvider>
            <AuthProvider>
              <div className="App">
                <BrowserRouter basename={import.meta.env.BASE_URL}>
                  <Suspense fallback={<LoadingSpinner />}>
                    <Routes>
                      <Route path="/" element={<LandingPage />} />
                      <Route path="/test-layout" element={<TestLayout />} />
                      <Route path="/pricing" element={<PricingPage />} />
                      <Route path="/contact" element={<ContactPage />} />
                      <Route path="/about" element={<AboutPage />} />
                      <Route path="/templates" element={<TemplatesPage />} />
                      <Route path="/integrations" element={<IntegrationsPage />} />
                      <Route path="/api" element={<ApiPage />} />
                      <Route path="/solutions" element={<SolutionsPage />} />
                      <Route path="/solutions/small-business" element={<SmallBusinessPage />} />
                      <Route path="/solutions/enterprise" element={<EnterprisePage />} />
                      <Route path="/solutions/agencies" element={<AgenciesPage />} />
                      <Route path="/solutions/ecommerce" element={<EcommercePage />} />
                      <Route path="/help" element={<HelpCenterPage />} />
                      <Route path="/blog" element={<BlogPage />} />
                      <Route path="/webinars" element={<WebinarsPage />} />
                      <Route path="/careers" element={<CareersPage />} />
                      <Route path="/press" element={<PressPage />} />
                      <Route path="/docs" element={<DocsPage />} />
                      <Route path="/login" element={<LoginPage />} />
                      <Route path="/register" element={<RegisterPage />} />
                      <Route path="/activation" element={<ActivationPage />} />
                      <Route path="/setup-admin" element={<SetupAdminPage />} />
                      <Route path="/admin-login" element={<AdminLoginPage />} />
                      <Route path="/logout" element={<LogoutPage />} />
                      <Route path="/flash" element={<ProtectedRoute><FlashPage /></ProtectedRoute>} />
                      <Route path="/dashboard" element={<ProtectedRoute><Dashboard /></ProtectedRoute>} />
                      <Route path="/admin" element={<AdminProtectedRoute><AdminDashboard /></AdminProtectedRoute>} />
                      <Route path="/admin/backups" element={<AdminProtectedRoute><AdminBackupPage /></AdminProtectedRoute>} />
                      <Route path="/create-admin" element={<AdminProtectedRoute><CreateAdminPage /></AdminProtectedRoute>} />
                      <Route path="/profile" element={<ProfilePage />} />
                    </Routes>
                  </Suspense>
                </BrowserRouter>
                <Toaster />
              </div>
            </AuthProvider>
          </TooltipProvider>
        </ThemeProvider>
      </QueryClientProvider>
    </ErrorBoundary>
  );
}

export default App;