@echo off
title FlashCore Dashboard - XAMPP Setup

echo 🚀 Starting FlashCore Dashboard deployment for Windows XAMPP...
echo.

REM Check if we're in the correct directory
if not exist "package.json" (
    echo ❌ Error: Please run this script from the project root directory
    pause
    exit /b 1
)

REM Create necessary directories
echo 📁 Creating directories...
mkdir backend\config
mkdir database\backups

REM Check if Node.js is installed
node --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ❌ Error: Node.js is not installed or not in PATH
    echo Please install Node.js from https://nodejs.org/
    pause
    exit /b 1
)

REM Install Node.js dependencies
echo 📦 Installing Node.js dependencies...
npm install --production

REM Build the frontend
echo 🔨 Building frontend...
npm run build

REM Create a config file for database connection
echo ⚙️ Creating database configuration...
(
echo ^<?php
echo // Database configuration for XAMPP
echo $host = getenv('DB_HOST') ?: 'localhost';
echo $dbname = getenv('DB_NAME') ?: 'flashcore_dashboard';
echo $username = getenv('DB_USER') ?: 'root';
echo $password = getenv('DB_PASS') ?: '';
echo.
echo try {
echo     $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password, [
echo         PDO::ATTR_ERRMODE =^> PDO::ERRMODE_EXCEPTION,
echo         PDO::ATTR_DEFAULT_FETCH_MODE =^> PDO::FETCH_ASSOC,
echo         PDO::ATTR_EMULATE_PREPARES =^> false,
echo     ]^);
echo } catch (PDOException $e) {
echo     error_log("Database connection failed: " . $e-^>getMessage(^));
echo     die("Connection failed. Please check your database configuration.");
echo }
echo ?^>
) > backend\config\database.php

echo ✅ XAMPP deployment completed!
echo.
echo Next steps:
echo 1. Copy all files to your XAMPP htdocs directory (e.g., C:\xampp\htdocs\flashcore)
echo 2. Start Apache and MySQL in XAMPP Control Panel
echo 3. Create a database named 'flashcore_dashboard' in phpMyAdmin
echo 4. Import the database schema from database/schema.sql
echo 5. Access the application at http://localhost/flashcore
echo.
pause