#!/bin/bash

# Universal Deployment Script for FlashCore Dashboard
# This script detects the platform and runs the appropriate setup

echo "🚀 Starting FlashCore Dashboard universal deployment..."

# Check if we're in the correct directory
if [ ! -f "package.json" ]; then
    echo "❌ Error: Please run this script from the project root directory"
    exit 1
fi

# Detect platform
detect_platform() {
    if [ -n "$REPLIT_DB_URL" ]; then
        echo "replit"
    elif [ -d "/usr/local/cpanel" ]; then
        echo "cpanel"
    elif [ -d "/Applications/XAMPP" ] || [ -d "/opt/lampp" ] || [ -n "$WINDIR" ]; then
        echo "xampp"
    elif [ -n "$RENDER_SERVICE_ID" ]; then
        echo "render"
    elif [ -n "$CPANEL" ] || [ -n "$WHM" ]; then
        echo "cpanel"
    else
        # Check for common hosting panel identifiers
        if ps aux | grep -q "cpaneld"; then
            echo "cpanel"
        elif [ -f "/etc/hpanel-version" ]; then
            echo "hpanel"
        else
            echo "unknown"
        fi
    fi
}

PLATFORM=$(detect_platform)

echo "🖥️ Detected platform: $PLATFORM"

case $PLATFORM in
    "replit")
        echo "🔄 Running Replit setup..."
        chmod +x scripts/deployment/setup-replit.sh
        ./scripts/deployment/setup-replit.sh
        ;;
    "cpanel")
        echo "🔄 Running cPanel setup..."
        chmod +x scripts/deployment/setup-cpanel.sh
        ./scripts/deployment/setup-cpanel.sh
        ;;
    "xampp")
        echo "🔄 Running XAMPP setup..."
        echo "Please run setup-xampp.bat on Windows systems"
        ;;
    "render")
        echo "🔄 Running Render setup..."
        chmod +x scripts/deployment/setup-render.sh
        ./scripts/deployment/setup-render.sh
        ;;
    "hpanel")
        echo "🔄 Running HPanel setup..."
        chmod +x scripts/deployment/setup-hpanel.sh
        ./scripts/deployment/setup-hpanel.sh
        ;;
    *)
        echo "❓ Unknown platform detected"
        echo "Available setup scripts:"
        echo "  - HPanel: setup-hpanel.sh"
        echo "  - cPanel: setup-cpanel.sh"
        echo "  - Windows XAMPP: setup-xampp.bat"
        echo "  - Replit: setup-replit.sh"
        echo "  - Render: setup-render.sh"
        echo ""
        echo "Please run the appropriate script for your platform."
        ;;
esac

echo "✅ Universal deployment script completed!"