<?php
// PHP script to create an admin user
// This replaces the Supabase-based create-admin.js script

require_once '../backend/config/database.php';
require_once '../backend/utils/helpers.php';

function createAdminUser() {
    global $pdo;
    
    $adminData = [
        'email' => 'admin@flashcore.com',
        'password' => 'Admin123!',
        'firstName' => 'System',
        'lastName' => 'Administrator'
    ];
    
    echo "🚀 Creating admin user...\n";
    echo "📧 Email: {$adminData['email']}\n";
    echo "🔑 Password: {$adminData['password']}\n\n";
    
    try {
        // Check if user already exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$adminData['email']]);
        $existingUser = $stmt->fetch();
        
        if ($existingUser) {
            echo "⚠️  Admin user already exists!\n";
            echo "👤 User ID: {$existingUser['id']}\n";
            echo "📧 Email: {$adminData['email']}\n\n";
            echo "🔐 You can login with:\n";
            echo "   Email: {$adminData['email']}\n";
            echo "   Password: {$adminData['password']}\n";
            echo "\n🌐 Login at: /admin-login\n";
            return;
        }
        
        // Create user
        $userId = generateUUID();
        $passwordHash = password_hash($adminData['password'], PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("INSERT INTO users (id, email, password_hash, first_name, last_name, email_verified, created_at, last_login) VALUES (?, ?, ?, ?, ?, TRUE, NOW(), NOW())");
        $stmt->execute([
            $userId,
            $adminData['email'],
            $passwordHash,
            $adminData['firstName'],
            $adminData['lastName']
        ]);
        
        // Create profile with admin role (role_id = 1)
        $profileId = generateUUID();
        $stmt = $pdo->prepare("INSERT INTO profiles (id, user_id, first_name, last_name, role_id) VALUES (?, ?, ?, ?, 1)");
        $stmt->execute([
            $profileId,
            $userId,
            $adminData['firstName'],
            $adminData['lastName']
        ]);
        
        // Create user progress
        $progressId = generateUUID();
        $stmt = $pdo->prepare("INSERT INTO user_progress (id, user_id, current_rank, mails_sent, progress_percentage, referral_count, referral_earnings, total_earnings) VALUES (?, ?, 'Diamond', 1000, 100, 50, 250.00, 1000.00)");
        $stmt->execute([$progressId, $userId]);
        
        // Create user profile
        $userProfileId = generateUUID();
        $stmt = $pdo->prepare("INSERT INTO user_profiles (id, user_id, username, first_name, last_name) VALUES (?, ?, 'admin', ?, ?)");
        $stmt->execute([
            $userProfileId,
            $userId,
            $adminData['firstName'],
            $adminData['lastName']
        ]);
        
        echo "✅ Admin user created successfully!\n";
        echo "👤 User ID: $userId\n";
        echo "📧 Email: {$adminData['email']}\n\n";
        echo "🔐 You can now login with:\n";
        echo "   Email: {$adminData['email']}\n";
        echo "   Password: {$adminData['password']}\n";
        echo "\n🌐 Login at: /admin-login\n";
        
    } catch (Exception $e) {
        echo "❌ Error creating admin user: " . $e->getMessage() . "\n";
        exit(1);
    }
}

// Run the function
createAdminUser();
?>