# 🚀 FlashCore Backup System

A comprehensive, enterprise-grade backup and restore system for the FlashCore Pulse Dashboard. This system provides automated backup creation, intelligent restore procedures, scheduled backups, and complete maintenance tools.

![FlashCore Backup System](https://img.shields.io/badge/FlashCore-Backup%20System-blue?style=for-the-badge)
![Node.js](https://img.shields.io/badge/Node.js-18+-green?style=flat-square&logo=node.js)
![TypeScript](https://img.shields.io/badge/TypeScript-5.5.3-3178C6?style=flat-square&logo=typescript)
![License](https://img.shields.io/badge/License-MIT-green?style=flat-square)

## 📋 Table of Contents

- [✨ Features](#features)
- [🚀 Quick Start](#quick-start)
- [📦 Installation](#installation)
- [🔧 Usage](#usage)
- [📁 Scripts Overview](#scripts-overview)
- [⚙️ Configuration](#configuration)
- [🔄 Backup Process](#backup-process)
- [🔄 Restore Process](#restore-process)
- [⏰ Scheduling](#scheduling)
- [🔧 Maintenance](#maintenance)
- [📊 Monitoring](#monitoring)
- [🛡️ Security](#security)
- [🛠️ Troubleshooting](#troubleshooting)
- [🤝 Contributing](#contributing)

## ✨ Features

### 🔥 Core Features

- **📦 Complete Project Backup** - Source code, configuration, dependencies, and environment files
- **🗜️ Intelligent Compression** - Maximum compression with configurable levels
- **🔍 Integrity Verification** - SHA256 checksums and archive validation
- **🔄 Automated Restore** - One-command project restoration
- **⏰ Scheduled Backups** - Cron-based automated backup scheduling
- **🧹 Smart Cleanup** - Automated retention policies and disk space management

### 🛠️ Advanced Features

- **📋 Detailed Manifests** - Complete backup metadata and file listings
- **🔧 Interactive Mode** - User-friendly prompts and confirmations
- **📊 Status Monitoring** - Real-time backup system status
- **🛡️ Error Handling** - Comprehensive error recovery and logging
- **🌐 Cross-Platform** - Works on Windows, macOS, and Linux
- **📱 Progress Indicators** - Real-time progress with spinners and bars

### 🎯 Specialized Features

- **🗄️ Database Integration** - Supabase configuration and backup scripts
- **📧 Email Notifications** - Backup completion and error alerts
- **🔐 Security Features** - Environment variable protection and encryption
- **📈 Analytics** - Backup statistics and performance metrics
- **🔄 Rollback Support** - Safe restore with conflict resolution

## 🚀 Quick Start

### 1. Install Dependencies

```bash
cd scripts/backup-system
npm install
```

### 2. Create Your First Backup

```bash
# From project root
npm run backup

# Or directly
node scripts/backup-system/backup.js
```

### 3. Restore from Backup

```bash
# Restore latest backup
npm run restore:latest

# Or restore specific backup
node scripts/backup-system/restore.js backups/flashcore-pulse-dashboard_20241201_143022.tar.gz
```

### 4. Check Status

```bash
npm run backup:status
```

## 📦 Installation

### Prerequisites

- Node.js 18+ or Bun
- npm, yarn, or bun package manager
- Access to project root directory

### Step-by-Step Setup

1. **Navigate to Backup System Directory**

   ```bash
   cd scripts/backup-system
   ```

2. **Install Dependencies**

   ```bash
   npm install
   ```

3. **Verify Installation**

   ```bash
   node help.js overview
   ```

4. **Create Initial Configuration** (Optional)

   ```bash
   # Create backup configuration
   echo '{
     "projectName": "flashcore-pulse-dashboard",
     "backupDir": "backups",
     "compressionLevel": 9,
     "maxBackups": 10
   }' > backup-config.json
   ```

## 🔧 Usage

### Basic Commands

#### Create Backup

```bash
# Quick backup
npm run backup:quick

# Full backup with custom options
node scripts/backup-system/backup.js --compression 6 --max-backups 5
```

#### Restore Backup

```bash
# Interactive restore
node scripts/backup-system/restore.js --interactive

# Force restore (overwrite existing files)
node scripts/backup-system/restore.js backup-file.tar.gz --overwrite
```

#### Check Status

```bash
# Basic status
npm run backup:status

# Detailed status with JSON output
node scripts/backup-system/status.js --detailed --format json
```

#### Cleanup Old Backups

```bash
# Dry run (see what would be deleted)
node scripts/backup-system/cleanup.js --dry-run

# Clean up backups older than 30 days
node scripts/backup-system/cleanup.js --max-age 30 --force
```

#### Verify Backup Integrity

```bash
# Verify specific backup
node scripts/backup-system/verify.js backup-file.tar.gz

# Verify all backups with extraction
node scripts/backup-system/verify.js --extract --detailed
```

### Advanced Usage

#### Scheduled Backups

```bash
# Start daily scheduler
node scripts/backup-system/scheduler.js start --schedule "0 2 * * *"

# Check scheduler status
node scripts/backup-system/scheduler.js status

# Trigger immediate backup
node scripts/backup-system/scheduler.js backup-now
```

#### Custom Configuration

```bash
# Use custom config file
node scripts/backup-system/backup.js --config custom-backup-config.json

# Override specific options
node scripts/backup-system/backup.js --compression 7 --max-backups 15
```

## 📁 Scripts Overview

### Core Scripts

| Script | Purpose | Key Features |
|--------|---------|--------------|
| `backup.js` | Create project backups | Compression, filtering, manifest generation |
| `restore.js` | Restore from backups | Interactive mode, conflict resolution |
| `scheduler.js` | Automated scheduling | Cron support, monitoring, logging |
| `status.js` | System monitoring | Disk usage, backup statistics |
| `cleanup.js` | Maintenance | Retention policies, space management |
| `verify.js` | Integrity checking | Checksums, file validation |
| `help.js` | Documentation | Comprehensive help system |

### Utility Scripts

| Script | Purpose | Description |
|--------|---------|-------------|
| `test-backup.js` | Testing | Backup system testing and validation |
| `backup-config.json` | Configuration | Backup system settings |
| `backup-schedule.json` | Scheduling | Automated backup configuration |

## ⚙️ Configuration

### Backup Configuration (`backup-config.json`)

```json
{
  "projectName": "flashcore-pulse-dashboard",
  "backupDir": "backups",
  "compressionLevel": 9,
  "maxBackups": 10,
  "includeNodeModules": false,
  "includeDist": false,
  "includeLogs": false
}
```

### Schedule Configuration (`backup-schedule.json`)

```json
{
  "schedule": "0 2 * * *",
  "backupDir": "backups",
  "maxBackups": 10,
  "compressionLevel": 9,
  "enabled": true,
  "logFile": "backup-scheduler.log"
}
```

### Environment Variables

```bash
# Required for database integration
VITE_SUPABASE_URL=your_supabase_project_url
VITE_SUPABASE_ANON_KEY=your_supabase_anon_key

# Optional for notifications
BACKUP_NOTIFICATION_EMAIL=admin@example.com
BACKUP_NOTIFICATION_WEBHOOK=https://hooks.slack.com/...
```

## 🔄 Backup Process

### What Gets Backed Up

#### ✅ Included Files

- **Source Code**: `src/`, `components/`, `pages/`, `hooks/`, `utils/`
- **Configuration**: `package.json`, `tsconfig.json`, `vite.config.ts`
- **Environment**: `.env*` files
- **Documentation**: `README.md`, `docs/`, `*.md`
- **Database**: `supabase/` configuration
- **Build Config**: `tailwind.config.ts`, `eslint.config.js`

#### ❌ Excluded Files

- `node_modules/` (dependencies)
- `dist/` (build artifacts)
- `.git/` (version control)
- `backups/` (backup directory)
- `*.log` (log files)
- Temporary files

### Backup Process Flow

1. **Initialization**
   - Load configuration
   - Create backup directory
   - Validate environment

2. **File Collection**
   - Scan project directory
   - Apply inclusion/exclusion patterns
   - Generate file manifest

3. **Backup Creation**
   - Copy files to temporary directory
   - Generate backup manifest
   - Create restore script

4. **Compression**
   - Compress backup directory
   - Calculate checksums
   - Clean up temporary files

5. **Cleanup**
   - Remove old backups (if needed)
   - Update backup index
   - Log completion

## 🔄 Restore Process

### Restore Process Flow

1. **Validation**
   - Verify backup file exists
   - Check archive integrity
   - Extract manifest

2. **Conflict Detection**
   - Check for existing files
   - Prompt for overwrite (if interactive)
   - Validate restore environment

3. **File Restoration**
   - Extract backup archive
   - Restore project files
   - Preserve file permissions

4. **Dependency Installation**
   - Install npm dependencies
   - Verify package.json
   - Check for missing packages

5. **Environment Setup**
   - Restore environment files
   - Validate configuration
   - Setup database connections

6. **Verification**
   - Check critical files
   - Validate project structure
   - Test basic functionality

## ⏰ Scheduling

### Cron Expressions

| Pattern | Description | Example |
|---------|-------------|---------|
| `0 2 * * *` | Daily at 2 AM | `node scheduler.js start --schedule "0 2 * * *"` |
| `0 */6 * * *` | Every 6 hours | `node scheduler.js start --schedule "0 */6 * * *"` |
| `0 2 * * 0` | Weekly on Sunday | `node scheduler.js start --schedule "0 2 * * 0"` |
| `0 2 1 * *` | Monthly on 1st | `node scheduler.js start --schedule "0 2 1 * *"` |

### Scheduler Features

- **Automatic Execution**: Runs backups at specified intervals
- **Error Handling**: Retry logic and error logging
- **Resource Management**: Prevents overlapping backups
- **Monitoring**: Real-time status and health checks
- **Graceful Shutdown**: Handles system interruptions

## 🔧 Maintenance

### Regular Maintenance Tasks

#### Daily

- Check backup completion status
- Monitor disk space usage
- Review error logs

#### Weekly

- Verify backup integrity
- Clean up old backups
- Update backup statistics

#### Monthly

- Test restore procedures
- Review retention policies
- Update backup configuration

### Maintenance Commands

```bash
# Check system health
node scripts/backup-system/status.js --detailed

# Clean up old backups
node scripts/backup-system/cleanup.js --max-age 30 --force

# Verify all backups
node scripts/backup-system/verify.js --extract

# Test restore procedure
node scripts/backup-system/restore.js --dry-run
```

## 📊 Monitoring

### Status Monitoring

#### System Status

```bash
# Basic status
npm run backup:status

# Detailed status with JSON output
node scripts/backup-system/status.js --format json
```

#### Backup Health

```bash
# Verify backup integrity
node scripts/backup-system/verify.js

# Check backup statistics
node scripts/backup-system/status.js --detailed
```

### Logging

#### Log Files

- `backup-scheduler.log` - Scheduler activity
- `backup-system.log` - General system logs
- `backup-errors.log` - Error tracking

#### Log Levels

- `INFO` - General information
- `WARN` - Warning messages
- `ERROR` - Error conditions
- `DEBUG` - Detailed debugging

## 🛡️ Security

### Security Features

#### Data Protection

- **Environment Variables**: Sensitive data excluded from backups
- **Checksums**: SHA256 integrity verification
- **Encryption**: Optional backup encryption
- **Access Control**: File permission preservation

#### Backup Security

- **Secure Storage**: Backup files stored securely
- **Access Logging**: Backup access tracking
- **Audit Trail**: Complete backup history
- **Recovery Testing**: Regular restore validation

### Security Best Practices

1. **Environment Variables**

   ```bash
   # Never backup sensitive data
   .env.production
   .env.local
   ```

2. **Backup Location**

   ```bash
   # Store backups securely
   /secure/backup/location/
   ```

3. **Access Control**

   ```bash
   # Restrict backup access
   chmod 600 backup-file.tar.gz
   ```

## 🚨 Troubleshooting

### Common Issues

#### Backup Failures

**Issue**: Backup process fails

```bash
# Check disk space
df -h

# Verify permissions
ls -la scripts/backup-system/

# Check logs
tail -f backup-system.log
```

**Solution**: Ensure sufficient disk space and proper permissions

#### Restore Issues

**Issue**: Restore fails with conflicts

```bash
# Use interactive mode
node scripts/backup-system/restore.js --interactive

# Force overwrite
node scripts/backup-system/restore.js --overwrite
```

**Solution**: Resolve file conflicts or use force overwrite

#### Scheduler Problems

**Issue**: Scheduler not running

```bash
# Check scheduler status
node scripts/backup-system/scheduler.js status

# Restart scheduler
pkill -f scheduler.js
node scripts/backup-system/scheduler.js start
```

**Solution**: Restart scheduler or check cron configuration

### Error Codes

| Code | Description | Solution |
|------|-------------|----------|
| `EACCES` | Permission denied | Check file permissions |
| `ENOSPC` | No space left | Free up disk space |
| `ENOENT` | File not found | Verify file paths |
| `EINVAL` | Invalid argument | Check configuration |

### Debug Mode

```bash
# Enable debug logging
DEBUG=* node scripts/backup-system/backup.js

# Verbose output
node scripts/backup-system/backup.js --verbose
```

## 🤝 Contributing

### Development Setup

1. **Clone Repository**

   ```bash
   git clone <repository-url>
   cd scripts/backup-system
   ```

2. **Install Dependencies**

   ```bash
   npm install
   ```

3. **Run Tests**

   ```bash
   npm test
   ```

### Code Style

- Follow existing code patterns
- Use TypeScript for new features
- Add comprehensive error handling
- Include unit tests for new functionality
- Update documentation for changes

### Testing

```bash
# Run all tests
npm test

# Run specific test
npm test -- --grep "backup"

# Test with coverage
npm run test:coverage
```

---

## 📞 Support

### Getting Help

- **Documentation**: Check this README and help system
- **Help Command**: `node scripts/backup-system/help.js`
- **Examples**: `node scripts/backup-system/help.js examples`
- **Issues**: Report bugs and feature requests

### Community

- **Discussions**: GitHub Discussions
- **Issues**: GitHub Issues
- **Contributions**: Pull Requests welcome

---

## Made with ❤️ by the FlashCore Team

[![GitHub stars](https://img.shields.io/github/stars/your-username/flashcore-pulse-dashboard?style=social)](https://github.com/your-username/flashcore-pulse-dashboard)
[![GitHub forks](https://img.shields.io/github/forks/your-username/flashcore-pulse-dashboard?style=social)](https://github.com/your-username/flashcore-pulse-dashboard)
[![GitHub issues](https://img.shields.io/github/issues/your-username/flashcore-pulse-dashboard)](https://github.com/your-username/flashcore-pulse-dashboard/issues)
[![GitHub license](https://img.shields.io/github/license/your-username/flashcore-pulse-dashboard)](https://github.com/your-username/flashcore-pulse-dashboard/blob/main/LICENSE)
