<?php
require_once __DIR__ . '/config/database.php';

$stmt = $pdo->prepare("SELECT provider, host, port, username, from_email, from_name, is_active FROM smtp_settings WHERE is_active = TRUE LIMIT 1");
$stmt->execute();
$settings = $stmt->fetch();

if ($settings) {
    echo "Active SMTP Settings:\n";
    echo "  Provider: {$settings['provider']}\n";
    echo "  Host: {$settings['host']}\n";
    echo "  Port: {$settings['port']}\n";
    echo "  Username: {$settings['username']}\n";
    echo "  From Email: {$settings['from_email']}\n";
    echo "  From Name: {$settings['from_name']}\n";
    echo "  Active: " . ($settings['is_active'] ? 'Yes' : 'No') . "\n";
} else {
    echo "No active SMTP settings found\n";
}

