<?php
require_once dirname(__FILE__) . '/../config/database.php';

try {
    // 1. Add missing columns to user_profiles
    $columnsToAdd = [
        'location' => 'TEXT',
        'skills' => 'TEXT' // We'll store this as a JSON string
    ];

    foreach ($columnsToAdd as $column => $type) {
        // Check if column exists first (SQLite doesn't support IF NOT EXISTS in ALTER TABLE)
        $stmt = $pdo->query("PRAGMA table_info(user_profiles)");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $exists = false;
        foreach ($columns as $col) {
            if ($col['name'] === $column) {
                $exists = true;
                break;
            }
        }

        if (!$exists) {
            $pdo->exec("ALTER TABLE user_profiles ADD COLUMN $column $type");
            echo "Added column '$column' to 'user_profiles' table.\n";
        } else {
            echo "Column '$column' already exists in 'user_profiles' table.\n";
        }
    }

    // 2. Create user_settings table
    $pdo->exec("CREATE TABLE IF NOT EXISTS user_settings (
        id TEXT PRIMARY KEY,
        user_id TEXT NOT NULL UNIQUE,
        -- Notifications
        email_notifications INTEGER DEFAULT 1,
        push_notifications INTEGER DEFAULT 1,
        sms_notifications INTEGER DEFAULT 0,
        marketing_notifications INTEGER DEFAULT 0,
        security_alerts INTEGER DEFAULT 1,
        update_alerts INTEGER DEFAULT 1,
        -- Security
        two_factor_auth INTEGER DEFAULT 0,
        session_timeout TEXT DEFAULT '30',
        password_expiry TEXT DEFAULT '90',
        login_alerts INTEGER DEFAULT 1,
        -- Appearance
        theme TEXT DEFAULT 'system',
        compact_mode INTEGER DEFAULT 0,
        show_animations INTEGER DEFAULT 1,
        font_size TEXT DEFAULT 'medium',
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
    )");
    echo "Table 'user_settings' created or already exists.\n";

    // 3. Seed settings for existing users
    $stmt = $pdo->query("SELECT id FROM users");
    $users = $stmt->fetchAll();

    foreach ($users as $user) {
        $stmt = $pdo->prepare("INSERT OR IGNORE INTO user_settings (id, user_id) VALUES (?, ?)");
        $stmt->execute([bin2hex(random_bytes(16)), $user['id']]);
        
        // Also update profile with some default mock data if empty
        $stmt = $pdo->prepare("UPDATE user_profiles SET location = 'New York, NY', skills = '[\"React\", \"TypeScript\", \"Node.js\"]', bio = 'Software Developer' WHERE user_id = ? AND (location IS NULL OR location = '')");
        $stmt->execute([$user['id']]);
    }
    echo "Seeded default settings for existing users.\n";

} catch (PDOException $e) {
    die("Error setting up profile tables: " . $e->getMessage() . "\n");
}
