<?php
// Mock user session for testing
require_once 'config/database.php';
require_once 'utils/helpers.php';

// Find an admin user
$stmt = $pdo->query("SELECT u.id, u.email FROM users u JOIN profiles p ON u.id = p.user_id JOIN user_roles r ON p.role_id = r.id WHERE LOWER(r.name) = 'admin' LIMIT 1");
$admin = $stmt->fetch();

if (!$admin) {
    die("No admin user found for testing");
}

echo "Testing Email Template Actions as Admin: " . $admin['email'] . " (ID: " . $admin['id'] . ")\n";

// Action 1: List
$stmt = $pdo->prepare("SELECT et.*, u.email as created_by_email FROM email_templates et LEFT JOIN users u ON et.created_by = u.id ORDER BY et.created_at DESC");
$stmt->execute();
$templates = $stmt->fetchAll();
echo "Total templates found: " . count($templates) . "\n";

// Action 2: Create a dummy one
$id = generateUUID();
$name = "Test Template " . time();
$stmt = $pdo->prepare("INSERT INTO email_templates (id, name, subject, content, template_type, is_active, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
$stmt->execute([
    $id,
    $name,
    "Test Subject",
    "Test Content",
    "test_type",
    1,
    $admin['id']
]);
echo "Created test template with ID: $id\n";

// Action 3: Verify creation
$stmt = $pdo->prepare("SELECT * FROM email_templates WHERE id = ?");
$stmt->execute([$id]);
$newTemplate = $stmt->fetch();
if ($newTemplate) {
    echo "Verification SUCCESS: Template found.\n";
} else {
    echo "Verification FAILED: Template not found.\n";
}

// Cleanup
$pdo->prepare("DELETE FROM email_templates WHERE id = ?")->execute([$id]);
echo "Cleanup: Deleted test template.\n";
?>
