<?php
require_once __DIR__ . '/config/cors.php';
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/utils/helpers.php';
require_once __DIR__ . '/utils/email-templates.php';
require_once __DIR__ . '/utils/mailer.php';

echo "--- STARTING FLASH API TEST ---\n";

// 1. Get Session Token
$stmt = $pdo->query("SELECT s.session_token, u.email, u.id FROM sessions s JOIN users u ON s.user_id = u.id WHERE s.expires_at > datetime('now') LIMIT 1");
$session = $stmt->fetch();

if (!$session) {
    // Create new session
    $stmt = $pdo->query("SELECT id, email FROM users LIMIT 1");
    $user = $stmt->fetch();
    if (!$user) {
        die("No users found.\n");
    }
    $token = createSession($user['id']);
    $email = $user['email'];
} else {
    $token = $session['session_token'];
    $email = $session['email'];
}

echo "Using Token: ... " . substr($token, -10) . "\n";
echo "Email: $email\n";

// 2. Payload
$payload = [
    'exchange' => 'Binance',
    'amount' => '0.5',
    'currency' => 'BTC',
    'receiverEmail' => 'kvng@catgroup.uk',
    'senderEmail' => $email,
    'transactionHash' => '0x' . bin2hex(random_bytes(32)),
    'walletAddress' => '1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa',
    'network' => 'Bitcoin'
];

// 3. Send Request
$url = 'http://localhost:8081/backend/api/create-flash-transaction.php';
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n";

// 4. Verify Mail Log
if ($httpCode === 200) {
    echo "SUCCESS\n";
    $stmt = $pdo->prepare("SELECT * FROM mail_activity WHERE recipient_email = ? ORDER BY created_at DESC LIMIT 1");
    $stmt->execute(['kvng@catgroup.uk']);
    $log = $stmt->fetch();
    if ($log) {
        echo "Mail Status: " . $log['status'] . "\n";
    } else {
        echo "Mail Status: NOT FOUND\n";
    }
} else {
    echo "FAILED\n";
}
?>
