<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/utils/helpers.php';

echo "Testing Mail Activity Insert...\n";

try {
    $id = generateUUID();
    $userId = null; // Test with NULL
    $emailType = 'test_email';
    $recipient = 'test@example.com';
    $status = 'sent';
    $details = json_encode(['foo' => 'bar']);

    echo "ID: $id (Type: " . gettype($id) . ")\n";
    echo "UserID: " . var_export($userId, true) . "\n";
    
    $sql = "INSERT INTO mail_activity (id, user_id, email_type, recipient_email, status, details, created_at) VALUES (?, ?, ?, ?, ?, ?, datetime('now'))";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id, $userId, $emailType, $recipient, $status, $details]);
    
    echo "Insert Success!\n";
} catch (Exception $e) {
    echo "Insert Failed: " . $e->getMessage() . "\n";
    echo "Code: " . $e->getCode() . "\n";
}
?>
