<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/utils/helpers.php';

// Simulate adding a transaction for the first user found
try {
    $stmt = $pdo->query("SELECT id FROM users LIMIT 1");
    $user = $stmt->fetch();
    
    if ($user) {
        $userId = $user['id'];
        $txId = generateUUID();
        $txHash = '0x' . bin2hex(random_bytes(32));
        
        $stmt = $pdo->prepare("INSERT INTO transactions (id, sender_id, receiver_id, amount, symbol, status, tx_hash, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, datetime('now'))");
        $stmt->execute([
            $txId,
            $userId,
            $userId, // Self transfer for test
            1.5,
            'ETH',
            'completed',
            $txHash
        ]);
        
        echo "Test transaction inserted successfully.\nID: $txId\nHash: $txHash\n";
    } else {
        echo "No users found in database to attach transaction to.\n";
    }
} catch (PDOException $e) {
    echo "Error inserting test transaction: " . $e->getMessage() . "\n";
}
?>
