<?php
require_once 'config/database.php';
require_once 'utils/helpers.php';

echo "Seeding test subscribers...\n";

try {
    // Get all users
    $stmt = $pdo->query("SELECT id, email FROM users");
    $users = $stmt->fetchAll();
    
    if (count($users) === 0) {
        echo "No users found. Please run seeders or create users first.\n";
        exit;
    }

    // Get subscription tiers
    $stmt = $pdo->query("SELECT id FROM subscription_tiers");
    $tiers = $stmt->fetchAll(PDO::FETCH_COLUMN);

    foreach ($users as $user) {
        $id = generateUUID();
        $subscribed = rand(0, 1);
        $tierId = $subscribed ? $tiers[array_rand($tiers)] : null;
        $endDate = $subscribed ? date('Y-m-d H:i:s', strtotime('+' . rand(1, 12) . ' months')) : null;

        $stmt = $pdo->prepare("
            INSERT OR IGNORE INTO subscribers (id, user_id, email, subscribed, subscription_tier_id, subscription_end)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        
        $stmt->execute([
            $id,
            $user['id'],
            $user['email'],
            $subscribed,
            $tierId,
            $endDate
        ]);
        
        echo "Seeded subscriber: {$user['email']} (Subscribed: " . ($subscribed ? 'Yes' : 'No') . ")\n";
    }

    echo "\n✅ Subscribers seeding completed successfully!\n";
} catch (Exception $e) {
    echo "❌ Error seeding subscribers: " . $e->getMessage() . "\n";
}
?>
