<?php
require_once 'config/database.php';
require_once 'utils/helpers.php';

echo "Seeding email templates...\n";

$templates = [
    [
        'name' => 'Welcome Email',
        'subject' => 'Welcome to {company_name}!',
        'template_type' => 'welcome',
        'content' => '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f5f5f5;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f5f5f5; padding: 40px 0;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                    <tr>
                        <td style="padding: 40px; text-align: center; background: linear-gradient(135deg, #a16bf7 0%, #4cd97b 100%); border-radius: 10px 10px 0 0;">
                            <h1 style="color: #ffffff; margin: 0; font-size: 32px;">Welcome to FlashCore!</h1>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 40px;">
                            <h2 style="color: #333; margin-top: 0;">Hi {user_name},</h2>
                            <p style="color: #666; font-size: 16px; line-height: 1.6;">
                                Thank you for joining FlashCore! We\'re excited to have you on board. Your account has been successfully created.
                            </p>
                            <p style="color: #666; font-size: 16px; line-height: 1.6;">
                                Here\'s what you can do next:
                            </p>
                            <ul style="color: #666; font-size: 16px; line-height: 1.8;">
                                <li>Complete your profile</li>
                                <li>Explore the dashboard</li>
                                <li>Send your first email campaign</li>
                            </ul>
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin-top: 30px;">
                                <tr>
                                    <td align="center">
                                        <a href="{dashboard_url}" style="display: inline-block; padding: 15px 40px; background: linear-gradient(135deg, #a16bf7 0%, #4cd97b 100%); color: #ffffff; text-decoration: none; border-radius: 5px; font-weight: bold;">
                                            Get Started
                                        </a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 20px; background-color: #f8f8f8; text-align: center; border-radius: 0 0 10px 10px;">
                            <p style="color: #999; font-size: 14px; margin: 0;">
                                © 2025 FlashCore. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
        ',
        'is_active' => true
    ],
    [
        'name' => 'License Activation',
        'subject' => 'Your License Has Been Activated',
        'template_type' => 'license_activation',
        'content' => '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f5f5f5;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f5f5f5; padding: 40px 0;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                    <tr>
                        <td style="padding: 40px;">
                            <div style="text-align: center; margin-bottom: 30px;">
                                <div style="display: inline-block; width: 80px; height: 80px; background: linear-gradient(135deg, #4cd97b 0%, #8CBE06 100%); border-radius: 50%; line-height: 80px; font-size: 40px;">
                                    ✓
                                </div>
                            </div>
                            <h2 style="color: #333; text-align: center; margin: 0 0 20px 0;">License Activated Successfully!</h2>
                            <p style="color: #666; font-size: 16px; line-height: 1.6; text-align: center;">
                                Great news! Your {license_tier} license has been activated.
                            </p>
                            <div style="background-color: #f8f8f8; padding: 20px; border-radius: 8px; margin: 30px 0;">
                                <table width="100%" style="border-collapse: collapse;">
                                    <tr>
                                        <td style="padding: 10px 0; color: #666; font-weight: bold;">License Key:</td>
                                        <td style="padding: 10px 0; color: #333; text-align: right; font-family: monospace;">{license_key}</td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 10px 0; color: #666; font-weight: bold;">Plan:</td>
                                        <td style="padding: 10px 0; color: #333; text-align: right;">{license_tier}</td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 10px 0; color: #666; font-weight: bold;">Activated On:</td>
                                        <td style="padding: 10px 0; color: #333; text-align: right;">{activation_date}</td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 10px 0; color: #666; font-weight: bold;">Expires On:</td>
                                        <td style="padding: 10px 0; color: #333; text-align: right;">{expiry_date}</td>
                                    </tr>
                                </table>
                            </div>
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin-top: 30px;">
                                <tr>
                                    <td align="center">
                                        <a href="{dashboard_url}" style="display: inline-block; padding: 15px 40px; background: linear-gradient(135deg, #4cd97b 0%, #8CBE06 100%); color: #ffffff; text-decoration: none; border-radius: 5px; font-weight: bold;">
                                            View Dashboard
                                        </a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 20px; background-color: #f8f8f8; text-align: center; border-radius: 0 0 10px 10px;">
                            <p style="color: #999; font-size: 14px; margin: 0;">
                                © 2025 FlashCore. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
        ',
        'is_active' => true
    ],
    [
        'name' => 'Payment Receipt',
        'subject' => 'Payment Receipt - Transaction #{transaction_id}',
        'template_type' => 'receipt',
        'content' => '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        @media only screen and (max-width: 600px) {
            .container { width: 100% !important; }
            .content-padding { padding: 20px !important; }
        }
    </style>
</head>
<body style="margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, \'Helvetica Neue\', Arial, sans-serif; background-color: #f5f7fa;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f5f7fa; padding: 40px 20px;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 16px; box-shadow: 0 4px 20px rgba(0,0,0,0.08); overflow: hidden;" class="container">
                    <!-- Header with Exchange Branding -->
                    <tr>
                        <td style="background: linear-gradient(135deg, {exchange_color_start|#8b5cf6} 0%, {exchange_color_end|#7c3aed} 100%); padding: 0;">
                            <table width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td style="padding: 30px 40px; text-align: center;">
                                        <div style="margin-bottom: 20px;">
                                            <div style="display: inline-block; width: 60px; height: 60px; background-color: rgba(255,255,255,0.2); border-radius: 12px; padding: 12px; margin-bottom: 15px;">
                                                <div style="width: 36px; height: 36px; background-color: #ffffff; border-radius: 8px; display: flex; align-items: center; justify-content: center; font-size: 24px; font-weight: bold; color: {exchange_color_start|#8b5cf6};">
                                                    {exchange_icon|✓}
                                                </div>
                                            </div>
                                        </div>
                                        <h1 style="color: #ffffff; margin: 0 0 8px 0; font-size: 32px; font-weight: 700; letter-spacing: -0.5px;">Transaction Receipt</h1>
                                        <p style="color: rgba(255,255,255,0.9); margin: 0; font-size: 14px; font-weight: 500;">{exchange_name|FlashCore Exchange}</p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Receipt Number & Status -->
                    <tr>
                        <td style="padding: 25px 40px; background-color: #fafbfc; border-bottom: 1px solid #e5e7eb;" class="content-padding">
                            <table width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td>
                                        <p style="color: #6b7280; margin: 0 0 5px 0; font-size: 12px; text-transform: uppercase; letter-spacing: 0.5px; font-weight: 600;">Receipt Number</p>
                                        <p style="color: #111827; margin: 0; font-size: 18px; font-weight: 700; font-family: \'Courier New\', monospace;">#{transaction_id|TXN-000000}</p>
                                    </td>
                                    <td align="right">
                                        <span style="display: inline-block; padding: 6px 14px; background-color: #10b981; color: #ffffff; border-radius: 20px; font-size: 12px; font-weight: 600; text-transform: uppercase;">
                                            {status|Completed}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Main Content -->
                    <tr>
                        <td style="padding: 40px;" class="content-padding">
                            <p style="color: #374151; font-size: 16px; line-height: 1.6; margin: 0 0 30px 0;">
                                Dear {customer_name|Valued Customer},
                            </p>
                            <p style="color: #6b7280; font-size: 15px; line-height: 1.7; margin: 0 0 30px 0;">
                                Thank you for your transaction. This receipt confirms the successful completion of your payment. Please keep this receipt for your records.
                            </p>
                            
                            <!-- Transaction Details Box -->
                            <div style="background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%); border: 1px solid #e5e7eb; border-radius: 12px; padding: 25px; margin: 30px 0;">
                                <h3 style="color: #111827; margin: 0 0 20px 0; font-size: 18px; font-weight: 700; display: flex; align-items: center;">
                                    <span style="width: 4px; height: 20px; background: linear-gradient(135deg, {exchange_color_start|#8b5cf6} 0%, {exchange_color_end|#7c3aed} 100%); border-radius: 2px; margin-right: 12px;"></span>
                                    Transaction Details
                                </h3>
                                <table width="100%" cellpadding="0" cellspacing="0" style="border-collapse: collapse;">
                                    <tr>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb;">
                                            <p style="color: #6b7280; margin: 0; font-size: 14px; font-weight: 500;">Exchange Platform</p>
                                        </td>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb; text-align: right;">
                                            <p style="color: #111827; margin: 0; font-size: 14px; font-weight: 600;">{exchange_name|FlashCore Exchange}</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb;">
                                            <p style="color: #6b7280; margin: 0; font-size: 14px; font-weight: 500;">Transaction Type</p>
                                        </td>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb; text-align: right;">
                                            <p style="color: #111827; margin: 0; font-size: 14px; font-weight: 600;">{transaction_type|Payment}</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb;">
                                            <p style="color: #6b7280; margin: 0; font-size: 14px; font-weight: 500;">Currency</p>
                                        </td>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb; text-align: right;">
                                            <p style="color: #111827; margin: 0; font-size: 14px; font-weight: 600;">{currency|USD}</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb;">
                                            <p style="color: #6b7280; margin: 0; font-size: 14px; font-weight: 500;">Amount</p>
                                        </td>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb; text-align: right;">
                                            <p style="color: #10b981; margin: 0; font-size: 24px; font-weight: 700;">{amount|$0.00}</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb;">
                                            <p style="color: #6b7280; margin: 0; font-size: 14px; font-weight: 500;">Payment Method</p>
                                        </td>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb; text-align: right;">
                                            <p style="color: #111827; margin: 0; font-size: 14px; font-weight: 600;">{payment_method|Crypto Wallet}</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb;">
                                            <p style="color: #6b7280; margin: 0; font-size: 14px; font-weight: 500;">Transaction Hash</p>
                                        </td>
                                        <td style="padding: 12px 0; border-bottom: 1px solid #e5e7eb; text-align: right;">
                                            <p style="color: #6366f1; margin: 0; font-size: 12px; font-weight: 500; font-family: \'Courier New\', monospace; word-break: break-all;">{transaction_id|N/A}</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 12px 0;">
                                            <p style="color: #6b7280; margin: 0; font-size: 14px; font-weight: 500;">Date & Time</p>
                                        </td>
                                        <td style="padding: 12px 0; text-align: right;">
                                            <p style="color: #111827; margin: 0; font-size: 14px; font-weight: 600;">{transaction_date|' . date('F j, Y \a\t g:i A') . '}</p>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            
                            <!-- Exchange Branding Section -->
                            <div style="background-color: #f9fafb; border-left: 4px solid {exchange_color_start|#8b5cf6}; border-radius: 8px; padding: 20px; margin: 25px 0;">
                                <table width="100%" cellpadding="0" cellspacing="0">
                                    <tr>
                                        <td width="48" style="padding-right: 15px;">
                                            <div style="width: 48px; height: 48px; background: linear-gradient(135deg, {exchange_color_start|#8b5cf6} 0%, {exchange_color_end|#7c3aed} 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 24px; color: #ffffff; font-weight: bold;">
                                                {exchange_icon|E}
                                            </div>
                                        </td>
                                        <td>
                                            <p style="color: #111827; margin: 0 0 4px 0; font-size: 16px; font-weight: 700;">{exchange_name|FlashCore Exchange}</p>
                                            <p style="color: #6b7280; margin: 0; font-size: 13px; line-height: 1.5;">Secured by industry-leading encryption and blockchain technology</p>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            
                            <!-- Additional Info -->
                            <div style="margin-top: 30px; padding-top: 25px; border-top: 1px solid #e5e7eb;">
                                <p style="color: #6b7280; font-size: 14px; line-height: 1.7; margin: 0 0 15px 0;">
                                    <strong style="color: #111827;">Important:</strong> This is an automated receipt. If you have any questions or concerns about this transaction, please contact our support team immediately.
                                </p>
                                <p style="color: #6b7280; font-size: 13px; line-height: 1.6; margin: 0;">
                                    Please retain this receipt for your records. This document serves as proof of your transaction.
                                </p>
                            </div>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="padding: 30px 40px; background-color: #fafbfc; border-top: 1px solid #e5e7eb; text-align: center;" class="content-padding">
                            <p style="color: #9ca3af; margin: 0 0 8px 0; font-size: 12px;">
                                © ' . date('Y') . ' {exchange_name|FlashCore Exchange}. All rights reserved.
                            </p>
                            <p style="color: #9ca3af; margin: 0; font-size: 11px; line-height: 1.6;">
                                This receipt was generated automatically. For support, visit our help center or contact customer service.
                            </p>
                            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #e5e7eb;">
                                <a href="#" style="color: {exchange_color_start|#8b5cf6}; text-decoration: none; font-size: 12px; margin: 0 12px; font-weight: 500;">Support</a>
                                <span style="color: #d1d5db;">|</span>
                                <a href="#" style="color: {exchange_color_start|#8b5cf6}; text-decoration: none; font-size: 12px; margin: 0 12px; font-weight: 500;">Privacy Policy</a>
                                <span style="color: #d1d5db;">|</span>
                                <a href="#" style="color: {exchange_color_start|#8b5cf6}; text-decoration: none; font-size: 12px; margin: 0 12px; font-weight: 500;">Terms of Service</a>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
        ',
        'is_active' => true
    ],
    [
        'name' => 'System Notification',
        'subject' => '{notification_title}',
        'template_type' => 'notification',
        'content' => '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f5f5f5;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f5f5f5; padding: 40px 0;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                    <tr>
                        <td style="padding: 40px; border-left: 4px solid #ff9f40;">
                            <h2 style="color: #333; margin: 0 0 20px 0;">{notification_title}</h2>
                            <p style="color: #666; font-size: 16px; line-height: 1.6;">
                                {notification_message}
                            </p>
                            <div style="background-color: #fff3e0; border-left: 4px solid #ff9f40; padding: 15px; margin: 20px 0; border-radius: 4px;">
                                <p style="color: #e65100; margin: 0; font-size: 14px;">
                                    <strong>Action Required:</strong> {action_required}
                                </p>
                            </div>
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin-top: 30px;">
                                <tr>
                                    <td align="center">
                                        <a href="{action_url}" style="display: inline-block; padding: 15px 40px; background: linear-gradient(135deg, #ff9f40 0%, #ff6f00 100%); color: #ffffff; text-decoration: none; border-radius: 5px; font-weight: bold;">
                                            Take Action
                                        </a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 20px; background-color: #f8f8f8; text-align: center; border-radius: 0 0 10px 10px;">
                            <p style="color: #999; font-size: 14px; margin: 0;">
                                © 2025 FlashCore. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
        ',
        'is_active' => true
    ],
    [
        'name' => 'Password Reset',
        'subject' => 'Reset Your Password',
        'template_type' => 'notification',
        'content' => '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f5f5f5;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f5f5f5; padding: 40px 0;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                    <tr>
                        <td style="padding: 40px;">
                            <h2 style="color: #333; margin: 0 0 20px 0;">Reset Your Password</h2>
                            <p style="color: #666; font-size: 16px; line-height: 1.6;">
                                Hi {user_name},
                            </p>
                            <p style="color: #666; font-size: 16px; line-height: 1.6;">
                                We received a request to reset your password. Click the button below to create a new password:
                            </p>
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin: 30px 0;">
                                <tr>
                                    <td align="center">
                                        <a href="{reset_url}" style="display: inline-block; padding: 15px 40px; background: linear-gradient(135deg, #a16bf7 0%, #4cd97b 100%); color: #ffffff; text-decoration: none; border-radius: 5px; font-weight: bold;">
                                            Reset Password
                                        </a>
                                    </td>
                                </tr>
                            </table>
                            <p style="color: #666; font-size: 14px; line-height: 1.6;">
                                If you didn\'t request this password reset, please ignore this email or contact support if you have concerns.
                            </p>
                            <p style="color: #999; font-size: 12px; line-height: 1.6; margin-top: 30px;">
                                This link will expire in 24 hours for security reasons.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 20px; background-color: #f8f8f8; text-align: center; border-radius: 0 0 10px 10px;">
                            <p style="color: #999; font-size: 14px; margin: 0;">
                                © 2025 FlashCore. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
        ',
        'is_active' => true
    ]
];

try {
    // Get admin user (assuming first user is admin for seeding)
    $stmt = $pdo->query("SELECT id FROM users LIMIT 1");
    $adminUser = $stmt->fetch();
    
    if (!$adminUser) {
        echo "No users found in database. Please create a user first.\n";
        exit(1);
    }
    
    $adminUserId = $adminUser['id'];
    $templatesCreated = 0;
    
    foreach ($templates as $template) {
        // Check if template already exists
        $stmt = $pdo->prepare("SELECT id FROM email_templates WHERE name = ?");
        $stmt->execute([$template['name']]);
        $existing = $stmt->fetch();
        
        if ($existing) {
            echo "Template '{$template['name']}' already exists, skipping...\n";
            continue;
        }
        
        $id = generateUUID();
        $stmt = $pdo->prepare("
            INSERT INTO email_templates 
            (id, name, subject, content, template_type, is_active, created_by) 
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        
        $stmt->execute([
            $id,
            $template['name'],
            $template['subject'],
            $template['content'],
            $template['template_type'],
            $template['is_active'] ? 1 : 0,
            $adminUserId
        ]);
        
        echo "Created template: {$template['name']}\n";
        $templatesCreated++;
    }
    
    echo "\n✓ Successfully created $templatesCreated email templates.\n";
    
} catch (Exception $e) {
    echo "Error seeding templates: " . $e->getMessage() . "\n";
    exit(1);
}
?>
