<?php
require_once 'config/database.php';

echo "Adding email provider columns to smtp_settings table...\n";

try {
    // Add new columns for Resend and EmailJS
    $pdo->exec("
        ALTER TABLE smtp_settings 
        ADD COLUMN api_key TEXT DEFAULT '';
    ");
    echo "Added api_key column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'duplicate column name') !== false) {
        echo "api_key column already exists\n";
    } else {
        throw $e;
    }
}

try {
    $pdo->exec("
        ALTER TABLE smtp_settings 
        ADD COLUMN service_id TEXT DEFAULT '';
    ");
    echo "Added service_id column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'duplicate column name') !== false) {
        echo "service_id column already exists\n";
    } else {
        throw $e;
    }
}

try {
    $pdo->exec("
        ALTER TABLE smtp_settings 
        ADD COLUMN template_id TEXT DEFAULT '';
    ");
    echo "Added template_id column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'duplicate column name') !== false) {
        echo "template_id column already exists\n";
    } else {
        throw $e;
    }
}

try {
    $pdo->exec("
        ALTER TABLE smtp_settings 
        ADD COLUMN user_id TEXT DEFAULT '';
    ");
    echo "Added user_id column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'duplicate column name') !== false) {
        echo "user_id column already exists\n";
    } else {
        throw $e;
    }
}

echo "\n✓ Database migration completed successfully!\n";
?>
