<?php
// backend/migrate.php

require_once __DIR__ . '/config/database.php';

echo "Starting database migration...\n";

// Helper to safely add columns
function addColumnIfNotExists($pdo, $table, $column, $definition) {
    try {
        $pdo->exec("ALTER TABLE $table ADD COLUMN $column $definition");
        echo "Added column $column to table $table.\n";
    } catch (Exception $e) {
        // Simple check: most likely error is duplicate column
        if (strpos($e->getMessage(), 'duplicate column name') !== false) {
            echo "Column $column already exists in table $table. Skipping.\n";
        } else {
            // Re-throw if it's something else, or just log it
            echo "Note: Could not add column $column to $table (might already exist). Error: " . $e->getMessage() . "\n";
        }
    }
}

// Ensure new columns exist
addColumnIfNotExists($pdo, 'users', 'is_approved', 'INTEGER DEFAULT 0');
addColumnIfNotExists($pdo, 'users', 'email_verified', 'INTEGER DEFAULT 0');
addColumnIfNotExists($pdo, 'users', 'verification_token', 'TEXT');

echo "Migration complete.\n";
?>
