<?php
// verify_admin_endpoints.php
require_once 'config/database.php';
require_once 'utils/helpers.php';

// Mock everything needed to test these endpoints standalone
// We will manually invoke the logic or just use curl commands in the shell
// But a script that sets up state is better.

// 1. Ensure we have an admin user
$stmt = $pdo->query("SELECT id, email FROM users WHERE email = 'admin@flashcore.com'");
$admin = $stmt->fetch();
if (!$admin) {
    die("Admin user not found. Please run seed first.\n");
}
echo "Found Admin: " . $admin['email'] . " (" . $admin['id'] . ")\n";

// We need a valid session token for this admin to call endpoints if we were using curl
// But we can also simulate the endpoint logic by including it? 
// No, the endpoints output JSON and exit. Better to use curl with a valid token.

// Create a session for admin
$token = bin2hex(random_bytes(32));
$stmt = $pdo->prepare("INSERT INTO sessions (id, user_id, session_token, expires_at) VALUES (?, ?, ?, datetime('now', '+1 hour'))");
$stmt->execute([generateUUID(), $admin['id'], $token]);
echo "Generated Session Token: $token\n";

// Save token to file for curl use
file_put_contents('admin_token.txt', $token);
?>
