<?php
require_once __DIR__ . '/config/database.php';

function inspectTable($pdo, $tableName) {
    echo "Inspecting table: $tableName\n";
    try {
        $stmt = $pdo->prepare("PRAGMA table_info($tableName)");
        $stmt->execute();
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($columns)) {
            echo "Table $tableName does not exist or has no columns.\n";
        } else {
            foreach ($columns as $col) {
                echo "  - " . $col['name'] . " (" . $col['type'] . ")\n";
            }
        }
    } catch (PDOException $e) {
        echo "Error inspecting $tableName: " . $e->getMessage() . "\n";
    }
    echo "\n";
}

inspectTable($pdo, 'mail_activity');
inspectTable($pdo, 'transactions');
inspectTable($pdo, 'email_templates');
?>
