<?php
require_once 'config/database.php';

echo "Database Path: " . DB_PATH . "\n";
if (file_exists(DB_PATH)) {
    echo "Database file exists.\n";
} else {
    echo "Database file NOT found!\n";
}

try {
    $stmt = $pdo->query("SELECT u.id, u.email, u.password_hash, p.role_id, r.name as role 
                         FROM users u 
                         LEFT JOIN profiles p ON u.id = p.user_id 
                         LEFT JOIN user_roles r ON p.role_id = r.id");
    $users = $stmt->fetchAll();
    
    echo "Users found: " . count($users) . "\n";
    foreach ($users as $user) {
        echo "ID: " . $user['id'] . ", Email: " . $user['email'] . ", Role: " . $user['role'] . " (ID: " . $user['role_id'] . ")\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

try {
    $stmt = $pdo->query("SELECT name FROM sqlite_master WHERE type='table'");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "Tables: " . implode(", ", $tables) . "\n";
} catch (Exception $e) {
    echo "Error listing tables: " . $e->getMessage() . "\n";
}
?>
