<?php
// Script to test Auth Flow: Register -> Verify -> Approve -> Login

$baseUrl = 'http://localhost:8080/api';
$email = 'test_' . time() . '@example.com';
$password = 'Password123!';

function post($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['code' => $httpCode, 'body' => json_decode($response, true)];
}

function get($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['code' => $httpCode, 'body' => $response]; // Body might be HTML
}

echo "1. Registering User ($email)...\n";
$res = post("$baseUrl/auth.php/register", [
    'email' => $email,
    'password' => $password,
    'firstName' => 'Test',
    'lastName' => 'User'
]);

if ($res['code'] !== 200) {
    echo "Register failed: " . json_encode($res) . "\n";
    exit;
}

$verifLink = $res['body']['debug_verification_link'];
$token = explode('token=', $verifLink)[1];
echo "   Success! Verification Link: $verifLink\n";

echo "2. Attempting Login (Unverified & Unapproved)...\n";
$res = post("$baseUrl/auth.php/login", ['email' => $email, 'password' => $password]);
if ($res['code'] === 403) {
    echo "   Correctly blocked (403): " . $res['body']['error'] . "\n";
} else {
    echo "   UNEXPECTED CODE: " . $res['code'] . "\n";
}

echo "3. Verifying Email...\n";
// Actually calling the verify endpoint
$res = get("http://localhost:8080/backend/api/verify-email.php?token=$token");
echo "   Verification request sent.\n";

echo "4. Attempting Login (Verified but Unapproved)...\n";
$res = post("$baseUrl/auth.php/login", ['email' => $email, 'password' => $password]);
if ($res['code'] === 403) {
    echo "   Correctly blocked (403): " . $res['body']['error'] . "\n";
} else {
    echo "   UNEXPECTED CODE: " . $res['code'] . "\n";
}

// 5. Admin Approve
// We need an admin token. Assuming there's a way to get one or we just simulate DB update.
// For this script, let's just cheat and update DB directly if we can, 
// OR simpler: Try to login as admin?
// I'll skip building a full admin login flow here and manually approve via SQLite command for this test script if I could.
// But wait, the environment PHP script can access the DB file?
// Yes, I can just use SQLite3 in this script if I point to the DB file.
// Or I can use the existing `database.php` if I include it.

echo "5. Admin Approving User (Simulated)...\n";
// Update DB directly
try {
    $db = new PDO('sqlite:../database/database.sqlite');
    $stmt = $db->prepare("UPDATE users SET is_approved = 1 WHERE email = ?");
    $stmt->execute([$email]);
    echo "   User approved in DB.\n";
} catch (Exception $e) {
    echo "   DB Error: " . $e->getMessage() . "\n";
}

echo "6. Attempting Login (Verified & Approved)...\n";
$res = post("$baseUrl/auth.php/login", ['email' => $email, 'password' => $password]);
if ($res['code'] === 200) {
    echo "   Login Successful! Token: " . substr($res['body']['session_token'], 0, 10) . "...\n";
} else {
    echo "   Login Failed: " . json_encode($res) . "\n";
}

?>
