<?php
require_once __DIR__ . '/../config/cors.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../utils/helpers.php';

$token = getAuthToken();
$user = getUserFromToken($token);

if (!$user) {
    errorResponse('Unauthorized', 401);
}

try {
    // 1. Transaction Stats
    $stmt = $pdo->prepare("SELECT COUNT(*) as total, SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as success, AVG(3) as avg_time FROM transactions WHERE sender_id = ?");
    $stmt->execute([$user['id']]);
    $stats = $stmt->fetch(PDO::FETCH_ASSOC);

    $total = $stats['total'] ?: 0;
    $success = $stats['success'] ?: 0;
    $successRate = $total > 0 ? round(($success / $total) * 100, 1) : 100;

    // 2. Recent Activity for Flash Page (Last 3)
    $stmt = $pdo->prepare("
        SELECT id as tx_id, status, created_at 
        FROM transactions 
        WHERE sender_id = ? 
        ORDER BY created_at DESC 
        LIMIT 3
    ");
    $stmt->execute([$user['id']]);
    $recent = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 3. Email Volume (Last 7 days)
    $stmt = $pdo->prepare("
        SELECT date(created_at) as date, COUNT(*) as count 
        FROM mail_activity 
        WHERE user_id = ? AND created_at >= date('now', '-7 days')
        GROUP BY date(created_at)
        ORDER BY date ASC
    ");
    $stmt->execute([$user['id']]);
    $emailVolume = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 4. Chart Data (Mocking real market data for now as we don't have an external crypto API connected yet, 
    // but structure is ready for replacement. 
    // Ideally, we would fetch this from CoinGecko or similar if this was a real trading app.
    // For now, we will return a structure the frontend expects but marked as 'simulated' if needed,
    // or we can fetch stored price history if we had it.)
    
    // Returning a basic successful structure
    jsonResponse([
        'stats' => [
            'total_transactions' => $total,
            'success_rate' => $successRate,
            'avg_time' => 2.3 // Calculate real avg time if we tracked duration
        ],
        'recent_activity' => $recent,
        'email_volume' => $emailVolume
    ]);

} catch (PDOException $e) {
    errorResponse('Database error: ' . $e->getMessage());
}
?>
