<?php
require_once __DIR__ . '/../config/cors.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../utils/helpers.php';

$token = getAuthToken();
$user = getUserFromToken($token);

if (!$user) {
    errorResponse('Unauthorized', 401);
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    try {
        $stmt = $pdo->prepare("
            SELECT 
                id,
                name,
                logo_path,
                gradient_start,
                gradient_end,
                description,
                volume_24h,
                rating,
                features,
                is_active,
                is_hot,
                has_ai,
                website_url,
                api_supported,
                created_at,
                updated_at
            FROM exchanges
            WHERE is_active = 1
            ORDER BY volume_24h DESC, rating DESC
        ");
        $stmt->execute();
        $exchanges = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Format the response
        $formatted = array_map(function($exchange) {
            $features = json_decode($exchange['features'], true) ?? [];
            
            return [
                'id' => $exchange['id'],
                'name' => $exchange['name'],
                'logoPath' => $exchange['logo_path'],
                'gradientStart' => $exchange['gradient_start'],
                'gradientEnd' => $exchange['gradient_end'],
                'description' => $exchange['description'],
                'volume24h' => floatval($exchange['volume_24h']),
                'volume24hFormatted' => formatVolume($exchange['volume_24h']),
                'rating' => floatval($exchange['rating']),
                'features' => $features,
                'isActive' => (bool)$exchange['is_active'],
                'isHot' => (bool)$exchange['is_hot'],
                'hasAI' => (bool)$exchange['has_ai'],
                'websiteUrl' => $exchange['website_url'],
                'apiSupported' => (bool)$exchange['api_supported'],
            ];
        }, $exchanges);

        jsonResponse(['exchanges' => $formatted]);
    } catch (PDOException $e) {
        errorResponse('Database error: ' . $e->getMessage(), 500);
    }
} else {
    errorResponse('Method not allowed', 405);
}

function formatVolume($volume) {
    if ($volume >= 1000000000) {
        return '$' . number_format($volume / 1000000000, 2) . 'B';
    } elseif ($volume >= 1000000) {
        return '$' . number_format($volume / 1000000, 2) . 'M';
    } elseif ($volume >= 1000) {
        return '$' . number_format($volume / 1000, 2) . 'K';
    }
    return '$' . number_format($volume, 2);
}
?>
