<?php
require_once __DIR__ . '/../config/cors.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../utils/helpers.php';

$token = getAuthToken();
$user = getUserFromToken($token);

if (!$user) {
    errorResponse('Unauthorized', 401);
}

// Fetch PUBLIC email config (sender identity only)
$stmt = $pdo->prepare("SELECT from_name, from_email, provider FROM smtp_settings WHERE is_active = TRUE LIMIT 1");
$stmt->execute();
$config = $stmt->fetch();

if ($config) {
    // Do NOT return host/port/creds to regular users
    jsonResponse([
        'success' => true,
        'sender' => [
            'name' => $config['from_name'],
            'email' => $config['from_email'],
            'provider' => $config['provider']
        ]
    ]);
} else {
    jsonResponse([
        'success' => true, 
        'sender' => null
    ]);
}
?>
