<?php
require_once '../config/cors.php';
require_once '../config/database.php';
require_once '../utils/helpers.php';

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Extract authorization token
$token = getAuthToken();

// Validate token
$user = getUserFromToken($token);
if (!$user) {
    errorResponse('User not authenticated', 401);
}

// Validate required fields
if (!isset($input['plan'])) {
    errorResponse('Plan is required', 400);
}

$plan = $input['plan'];

try {
    // Define plan pricing (in cents)
    $planPricing = [
        'basic' => ['amount' => 999, 'name' => 'Basic Plan'],
        'pro' => ['amount' => 2999, 'name' => 'Pro Plan'],
        'enterprise' => ['amount' => 9999, 'name' => 'Enterprise Plan']
    ];

    if (!isset($planPricing[$plan])) {
        errorResponse('Invalid plan selected', 400);
    }

    $selectedPlan = $planPricing[$plan];

    // For now, we'll just simulate creating a checkout session
    // In a real implementation, you would integrate with Stripe to create an actual checkout session
    
    // Generate a simulated session ID
    $sessionId = 'cs_' . bin2hex(random_bytes(16));
    
    // Get subscription tier ID
    $stmt = $pdo->prepare("SELECT id FROM subscription_tiers WHERE name = ?");
    $stmt->execute([$plan]);
    $tier = $stmt->fetch();
    
    if (!$tier) {
        errorResponse('Subscription tier not found', 500);
    }

    // Create order record
    $orderId = generateUUID();
    $stmt = $pdo->prepare("INSERT INTO orders (id, user_id, stripe_session_id, amount, currency, subscription_tier_id, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $orderId,
        $user['id'],
        $sessionId,
        $selectedPlan['amount'],
        'usd',
        $tier['id'],
        'pending'
    ]);

    // Return the order details for the frontend simulation
    jsonResponse([
        'order_id' => $orderId,
        'amount' => $selectedPlan['amount'],
        'currency' => 'usd',
        'plan' => $plan,
        'status' => 'pending'
    ], 200);
} catch (Exception $e) {
    errorResponse('Error creating checkout session: ' . $e->getMessage(), 500);
}
?>