<?php
require_once '../config/cors.php';
require_once '../config/database.php';
require_once '../utils/helpers.php';

// Database schema is managed by backend/migrate.php

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Determine action from URL path
$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$action = basename($path);

require_once __DIR__ . '/controllers/AuthController.php';

$controller = new AuthController($pdo);

try {
    switch ($action) {
        case 'login':
            $response = $controller->login($input);
            jsonResponse($response, 200);
            break;
            
        case 'register':
            $response = $controller->register($input);
            jsonResponse($response, 200);
            break;
            
        case 'logout':
            $response = $controller->logout();
            jsonResponse($response, 200);
            break;
            
        default:
            errorResponse('Invalid action', 400);
    }
} catch (Exception $e) {
    errorResponse('Authentication error: ' . $e->getMessage(), 500);
}
?>