<?php
require_once __DIR__ . '/../../config/cors.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../utils/helpers.php';

// Verify Admin Access
$token = getAuthToken();
$user = getUserFromToken($token);

if (!$user || !isAdmin($user['id'])) {
    errorResponse('Unauthorized access', 403);
}

// Handle Requests
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Fetch current SMTP settings
    $stmt = $pdo->prepare("SELECT provider, host, port, username, from_email, from_name FROM smtp_settings WHERE is_active = TRUE LIMIT 1");
    $stmt->execute();
    $config = $stmt->fetch();

    if ($config) {
        jsonResponse(['success' => true, 'config' => $config]);
    } else {
        jsonResponse(['success' => true, 'config' => null]);
    }

} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Update SMTP settings
    $input = getJsonInput();
    
    // Only 'smtp' provider is fully configurable via UI for now to ensure robustness
    // Validation
    $required = ['host', 'port', 'username', 'password', 'from_email', 'from_name'];
    validateInput($input, $required);

    try {
        $pdo->beginTransaction();

        // Deactivate all existing
        $pdo->exec("UPDATE smtp_settings SET is_active = FALSE");

        // Insert new settings
        $id = generateUUID();
        $stmt = $pdo->prepare("
            INSERT INTO smtp_settings 
            (id, provider, host, port, username, password, from_email, from_name, encryption, is_active, created_at, updated_at) 
            VALUES (?, 'smtp', ?, ?, ?, ?, ?, ?, ?, TRUE, datetime('now'), datetime('now'))
        ");
        
        // Determine encryption based on port
        $encryption = ($input['port'] == 465) ? 'ssl' : 'tls';

        $stmt->execute([
            $id,
            $input['host'],
            $input['port'],
            $input['username'],
            $input['password'],
            $input['from_email'],
            $input['from_name'],
            $encryption
        ]);

        $pdo->commit();
        jsonResponse(['success' => true, 'message' => 'Email settings updated successfully']);

    } catch (Exception $e) {
        $pdo->rollBack();
        errorResponse('Failed to update settings: ' . $e->getMessage(), 500);
    }
} else {
    errorResponse('Method not allowed', 405);
}
?>
