import { r as reactExports, j as jsxRuntimeExports, I as Input, B as Button, i as Card, l as CardHeader, m as CardTitle, n as CardDescription, k as CardContent, q as Link, v as Mail } from "./index-dFGJiMHg.js";
import { B as Badge } from "./badge-w0XFTSDO.js";
import { V as Video } from "./video-fHxt0CwQ.js";
import { S as Search } from "./search-B1vmXDJS.js";
import { C as Calendar } from "./calendar-D_NP4res.js";
import { U as User } from "./user-d7xPbjjb.js";
import { C as Clock } from "./clock-jZHyhb-c.js";
import { U as Users } from "./users-D6qkMSDa.js";
import { E as ExternalLink } from "./external-link-8SiAMmvs.js";
import { P as Play } from "./play-D2NLOcoQ.js";
import { S as Star } from "./star-B_Vhg7wU.js";
import { B as BookOpen } from "./book-open-DugKzpVc.js";
import { A as Award } from "./award-CMmuLhvk.js";
import { T as Target } from "./target-DOPjxujo.js";
import { Z as Zap } from "./zap-BzUDRoi9.js";
import { C as ChartColumn } from "./chart-column-B-pc1RkE.js";
import { S as ShoppingCart } from "./shopping-cart-DfNqioM_.js";
import { B as Building } from "./building-B3F7FJiI.js";
const WebinarsPage = () => {
  const [searchQuery, setSearchQuery] = reactExports.useState("");
  const [selectedFilter, setSelectedFilter] = reactExports.useState("all");
  const filters = [
    { id: "all", name: "All Webinars", icon: Video },
    { id: "upcoming", name: "Upcoming", icon: Calendar },
    { id: "past", name: "Past Webinars", icon: Play },
    { id: "email-marketing", name: "Email Marketing", icon: Mail },
    { id: "automation", name: "Automation", icon: Zap },
    { id: "analytics", name: "Analytics", icon: ChartColumn },
    { id: "ecommerce", name: "E-commerce", icon: ShoppingCart },
    { id: "enterprise", name: "Enterprise", icon: Building }
  ];
  const upcomingWebinars = [
    {
      id: 1,
      title: "Mastering Email Automation: From Welcome Series to Win-Back Campaigns",
      description: "Learn how to create sophisticated email automation workflows that nurture leads and drive conversions. We'll cover welcome series, abandoned cart recovery, win-back campaigns, and more.",
      speaker: "Sarah Johnson",
      speakerRole: "Email Marketing Expert",
      speakerCompany: "FlashCore",
      date: "March 25, 2024",
      time: "2:00 PM EST",
      duration: "60 minutes",
      category: "automation",
      attendees: 1247,
      maxAttendees: 2e3,
      isLive: true,
      registrationRequired: true,
      tags: ["Automation", "Welcome Series", "Win-Back", "Advanced"],
      rating: 0,
      reviewCount: 0
    },
    {
      id: 2,
      title: "E-commerce Email Marketing: Holiday Season Success Strategies",
      description: "Prepare for the upcoming holiday season with proven email marketing strategies that drive sales and customer engagement. Learn from real case studies and expert insights.",
      speaker: "Michael Chen",
      speakerRole: "E-commerce Specialist",
      speakerCompany: "FlashCore",
      date: "March 28, 2024",
      time: "1:00 PM EST",
      duration: "45 minutes",
      category: "ecommerce",
      attendees: 892,
      maxAttendees: 1500,
      isLive: true,
      registrationRequired: true,
      tags: ["E-commerce", "Holiday", "Sales", "Strategy"],
      rating: 0,
      reviewCount: 0
    },
    {
      id: 3,
      title: "Email Analytics Deep Dive: Understanding Your Data for Better ROI",
      description: "Go beyond basic metrics and learn how to analyze email performance data to optimize campaigns and maximize your return on investment.",
      speaker: "Emily Rodriguez",
      speakerRole: "Data Analyst",
      speakerCompany: "FlashCore",
      date: "April 2, 2024",
      time: "3:00 PM EST",
      duration: "75 minutes",
      category: "analytics",
      attendees: 567,
      maxAttendees: 1e3,
      isLive: true,
      registrationRequired: true,
      tags: ["Analytics", "ROI", "Data", "Optimization"],
      rating: 0,
      reviewCount: 0
    },
    {
      id: 4,
      title: "Enterprise Email Marketing: Scaling Success for Large Organizations",
      description: "Discover how enterprise companies are leveraging email marketing to scale their operations, improve customer relationships, and drive growth.",
      speaker: "David Thompson",
      speakerRole: "Enterprise Consultant",
      speakerCompany: "FlashCore",
      date: "April 5, 2024",
      time: "2:30 PM EST",
      duration: "90 minutes",
      category: "enterprise",
      attendees: 234,
      maxAttendees: 500,
      isLive: true,
      registrationRequired: true,
      tags: ["Enterprise", "Scaling", "Growth", "Strategy"],
      rating: 0,
      reviewCount: 0
    }
  ];
  const pastWebinars = [
    {
      id: 5,
      title: "Email Marketing Fundamentals: Building Your First Campaign",
      description: "Perfect for beginners! Learn the basics of email marketing, from list building to creating your first successful campaign.",
      speaker: "Lisa Chen",
      speakerRole: "Marketing Educator",
      speakerCompany: "FlashCore",
      date: "March 15, 2024",
      time: "1:00 PM EST",
      duration: "60 minutes",
      category: "email-marketing",
      attendees: 2156,
      maxAttendees: 2500,
      isLive: false,
      registrationRequired: false,
      recordingUrl: "/webinars/email-fundamentals-march-15",
      rating: 4.8,
      reviewCount: 156,
      tags: ["Fundamentals", "Beginners", "Campaigns"]
    },
    {
      id: 6,
      title: "Subject Line Mastery: Writing Headlines That Get Opened",
      description: "Master the art of writing compelling subject lines that increase open rates and drive engagement. Includes A/B testing strategies.",
      speaker: "Amanda Kim",
      speakerRole: "Copywriting Expert",
      speakerCompany: "FlashCore",
      date: "March 8, 2024",
      time: "2:00 PM EST",
      duration: "45 minutes",
      category: "email-marketing",
      attendees: 1892,
      maxAttendees: 2e3,
      isLive: false,
      registrationRequired: false,
      recordingUrl: "/webinars/subject-lines-march-8",
      rating: 4.9,
      reviewCount: 203,
      tags: ["Subject Lines", "Open Rates", "Copywriting"]
    },
    {
      id: 7,
      title: "GDPR Compliance in Email Marketing: What You Need to Know",
      description: "Stay compliant with GDPR regulations. Learn best practices for data collection, consent management, and maintaining customer trust.",
      speaker: "Mark Johnson",
      speakerRole: "Legal Expert",
      speakerCompany: "FlashCore",
      date: "March 1, 2024",
      time: "3:00 PM EST",
      duration: "75 minutes",
      category: "email-marketing",
      attendees: 1347,
      maxAttendees: 1500,
      isLive: false,
      registrationRequired: false,
      recordingUrl: "/webinars/gdpr-compliance-march-1",
      rating: 4.7,
      reviewCount: 89,
      tags: ["GDPR", "Compliance", "Legal"]
    },
    {
      id: 8,
      title: "Advanced Segmentation: Targeting the Right Audience",
      description: "Learn advanced segmentation techniques to deliver personalized content that resonates with different audience segments.",
      speaker: "Robert Martinez",
      speakerRole: "Segmentation Specialist",
      speakerCompany: "FlashCore",
      date: "February 23, 2024",
      time: "2:30 PM EST",
      duration: "60 minutes",
      category: "automation",
      attendees: 987,
      maxAttendees: 1200,
      isLive: false,
      registrationRequired: false,
      recordingUrl: "/webinars/advanced-segmentation-feb-23",
      rating: 4.6,
      reviewCount: 134,
      tags: ["Segmentation", "Personalization", "Advanced"]
    }
  ];
  const allWebinars = [...upcomingWebinars, ...pastWebinars];
  const filteredWebinars = allWebinars.filter((webinar) => {
    const matchesSearch = webinar.title.toLowerCase().includes(searchQuery.toLowerCase()) || webinar.description.toLowerCase().includes(searchQuery.toLowerCase()) || webinar.tags.some((tag) => tag.toLowerCase().includes(searchQuery.toLowerCase()));
    const matchesFilter = selectedFilter === "all" || selectedFilter === "upcoming" && webinar.isLive || selectedFilter === "past" && !webinar.isLive || webinar.category === selectedFilter;
    return matchesSearch && matchesFilter;
  });
  const upcomingFiltered = filteredWebinars.filter((w) => w.isLive);
  const pastFiltered = filteredWebinars.filter((w) => !w.isLive);
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen bg-background", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Video, { className: "w-3 h-3 mr-1" }),
        "Live & On-Demand Webinars"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "Learn Email Marketing from Industry Experts" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Join our live webinars and access on-demand recordings to master email marketing strategies, automation, analytics, and more." }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-2xl mx-auto mb-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-3 top-1/2 transform -translate-y-1/2 text-muted-foreground w-5 h-5" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            type: "text",
            placeholder: "Search webinars by topic, speaker, or keyword...",
            value: searchQuery,
            onChange: (e) => setSearchQuery(e.target.value),
            className: "pl-10 pr-4 py-3 text-lg"
          }
        )
      ] }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-6xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-2 justify-center", children: filters.map((filter) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
      Button,
      {
        variant: selectedFilter === filter.id ? "default" : "outline",
        size: "sm",
        onClick: () => setSelectedFilter(filter.id),
        className: "flex items-center space-x-2",
        children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(filter.icon, { className: "w-4 h-4" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: filter.name })
        ]
      },
      filter.id
    )) }) }) }),
    upcomingFiltered.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Upcoming Live Webinars" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Register for our upcoming live sessions and learn from industry experts." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-6 md:gap-8", children: upcomingFiltered.map((webinar) => {
        var _a;
        return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group border-2 border-flashcore-purple/20", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between mb-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "destructive", className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-3 h-3 mr-1" }),
                "Live"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: "text-xs", children: (_a = filters.find((f) => f.id === webinar.category)) == null ? void 0 : _a.name })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl group-hover:text-flashcore-purple transition-colors", children: webinar.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: webinar.description })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-3", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-full flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "w-5 h-5 text-white" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "font-semibold", children: webinar.speaker }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-muted-foreground", children: [
                  webinar.speakerRole,
                  " at ",
                  webinar.speakerCompany
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-sm", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-4", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-4 h-4 mr-1" }),
                  webinar.date
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-4 h-4 mr-1" }),
                  webinar.time,
                  " (",
                  webinar.duration,
                  ")"
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center text-muted-foreground", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-4 h-4 mr-1" }),
                webinar.attendees,
                "/",
                webinar.maxAttendees
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-1", children: webinar.tags.map((tag, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: tag }, index)) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "w-full bg-flashcore-purple hover:bg-flashcore-purple/90", children: [
              "Register Now",
              /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { className: "w-4 h-4 ml-2" })
            ] })
          ] }) })
        ] }, webinar.id);
      }) })
    ] }) }),
    pastFiltered.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "On-Demand Webinars" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Watch recorded webinars at your own pace and learn from past sessions." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-6 md:gap-8", children: pastFiltered.map((webinar) => {
        var _a;
        return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between mb-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Play, { className: "w-3 h-3 mr-1" }),
                "On-Demand"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: (_a = filters.find((f) => f.id === webinar.category)) == null ? void 0 : _a.name })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl group-hover:text-flashcore-purple transition-colors", children: webinar.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: webinar.description })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-3", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 bg-gradient-to-r from-gray-400 to-gray-500 rounded-full flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "w-5 h-5 text-white" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "font-semibold", children: webinar.speaker }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-muted-foreground", children: [
                  webinar.speakerRole,
                  " at ",
                  webinar.speakerCompany
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-sm", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-4", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-4 h-4 mr-1" }),
                  webinar.date
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-4 h-4 mr-1" }),
                  webinar.duration
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-4 h-4 text-yellow-500 mr-1" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-semibold", children: webinar.rating }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-muted-foreground ml-1", children: [
                  "(",
                  webinar.reviewCount,
                  ")"
                ] })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-1", children: webinar.tags.map((tag, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: tag }, index)) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", className: "w-full group-hover:bg-flashcore-purple group-hover:text-white transition-colors", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Play, { className: "w-4 h-4 mr-2" }),
              "Watch Recording"
            ] })
          ] }) })
        ] }, webinar.id);
      }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-4xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-8 md:p-12 text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Never Miss a Webinar" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg mb-6 opacity-90", children: "Get notified about upcoming webinars and receive exclusive content from our email marketing experts." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 max-w-md mx-auto", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            type: "email",
            placeholder: "Enter your email address",
            className: "bg-white text-gray-900 placeholder-gray-500"
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Subscribe",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { className: "w-4 h-4 ml-2" })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm opacity-75 mt-4", children: "Get early access to webinar registrations and exclusive content." })
    ] }) }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "More Learning Resources" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Explore additional resources to enhance your email marketing knowledge." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6 text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(BookOpen, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Blog" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Latest insights and tips from our experts." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/blog", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Read Articles" }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6 text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Award, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Certification" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Get certified in email marketing." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/certification", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Get Certified" }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6 text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Users, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Community" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Connect with other marketers." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/community", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Join Community" }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6 text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Target, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Help Center" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Find answers to your questions." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/help", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Get Help" }) })
        ] }) })
      ] })
    ] }) })
  ] });
};
export {
  WebinarsPage as default
};
//# sourceMappingURL=WebinarsPage-fkuMIdlm.js.map
