import { c as createLucideIcon, r as reactExports, a as apiService, b as useToast, j as jsxRuntimeExports, D as Dialog, E as DialogContent, F as DialogHeader, G as DialogTitle, H as DialogDescription, t as Label, I as Input, J as DialogFooter, B as Button, a2 as Send, y as React, i as Card, l as CardHeader, m as CardTitle, k as CardContent, p as useNavigate, L as Layout, T as TrendingUp, x as CardFooter } from "./index-GlGoHQS3.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-jrC1WfMe.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-B0DdrR_V.js";
import { Q as QrCode } from "./qr-code-CQayf2T0.js";
import { C as Copy } from "./copy-C_jo3Fif.js";
import { S as Search } from "./search-qyfysnCX.js";
import { A as ArrowUpRight } from "./arrow-up-right-DUyGbstd.js";
import { u as useLendingData, L as LendingActionModal } from "./useLendingData-3IgjSCRv.js";
import { P as Plus } from "./plus-DOE21YSp.js";
import { E as Ellipsis } from "./ellipsis-DU_YZixr.js";
import "./index-CRzR833T.js";
import "./chevron-down-CfVNtG1C.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const ArrowDownLeft = createLucideIcon("ArrowDownLeft", [
  ["path", { d: "M17 7 7 17", key: "15tmo1" }],
  ["path", { d: "M17 17H7V7", key: "1org7z" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const ArrowLeftRight = createLucideIcon("ArrowLeftRight", [
  ["path", { d: "M8 3 4 7l4 4", key: "9rb6wj" }],
  ["path", { d: "M4 7h16", key: "6tx8e3" }],
  ["path", { d: "m16 21 4-4-4-4", key: "siv7j2" }],
  ["path", { d: "M20 17H4", key: "h6l3hr" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const RefreshCcw = createLucideIcon("RefreshCcw", [
  ["path", { d: "M21 12a9 9 0 0 0-9-9 9.75 9.75 0 0 0-6.74 2.74L3 8", key: "14sxne" }],
  ["path", { d: "M3 3v5h5", key: "1xhq8a" }],
  ["path", { d: "M3 12a9 9 0 0 0 9 9 9.75 9.75 0 0 0 6.74-2.74L21 16", key: "1hlbsb" }],
  ["path", { d: "M16 16h5v5", key: "ccwih5" }]
]);
const BASE_PRICES = {
  "BTC": 64230.5,
  "ETH": 3450.2,
  "SOL": 148.9,
  "USDT": 1,
  "ADA": 0.45,
  "BNB": 590,
  "XRP": 0.6,
  "USDC": 1,
  "AVAX": 35,
  "DOGE": 0.16,
  "DOT": 7,
  "TRX": 0.12,
  "LINK": 14,
  "MATIC": 0.7,
  "WBTC": 64200,
  "SHIB": 25e-6,
  "LTC": 80,
  "DAI": 1,
  "BCH": 450,
  "UNI": 10,
  "ATOM": 8.5,
  "XLM": 0.1,
  "ETC": 25,
  "FIL": 5,
  "HBAR": 0.1,
  "APT": 12,
  "CRO": 0.12,
  "LDO": 2,
  "NEAR": 6,
  "VET": 0.04
};
const CURRENCY_RATES = {
  USD: 1,
  EUR: 0.92,
  GBP: 0.79,
  JPY: 151.5,
  NGN: 1650
};
const CURRENCY_SYMBOLS = {
  USD: "$",
  EUR: "€",
  GBP: "£",
  JPY: "¥",
  NGN: "₦"
};
const useWalletPortfolio = () => {
  const [currency, setCurrency] = reactExports.useState("USD");
  const [assets, setAssets] = reactExports.useState([]);
  const [loading, setLoading] = reactExports.useState(true);
  const [totalBalance, setTotalBalance] = reactExports.useState(0);
  const [portfolioChange, setPortfolioChange] = reactExports.useState(0);
  const [walletAddress, setWalletAddress] = reactExports.useState("");
  reactExports.useEffect(() => {
    loadAssets();
  }, []);
  const loadAssets = async () => {
    try {
      setLoading(true);
      const response = await apiService.getWalletAssets();
      if (response.data) {
        if (response.data.address) {
          setWalletAddress(response.data.address);
        }
        const assetsData = response.data.assets || (Array.isArray(response.data) ? response.data : []);
        const dbAssets = assetsData.map((a) => {
          const basePrice = BASE_PRICES[a.symbol] || Math.random() * 100;
          return {
            ...a,
            price: basePrice,
            change24h: Math.random() * 5 - 2.5,
            // Random initial change
            value: a.balance * basePrice
          };
        });
        setAssets(dbAssets);
        calculateTotals(dbAssets);
      }
    } catch (error) {
      console.error("Failed to load wallet assets", error);
    } finally {
      setLoading(false);
    }
  };
  reactExports.useEffect(() => {
    if (assets.length === 0) return;
    const interval = setInterval(() => {
      setAssets((currentAssets) => {
        const updated = currentAssets.map((asset) => {
          const movement = (Math.random() - 0.5) * 4e-3;
          const currentPriceUSD = asset.price / CURRENCY_RATES[currency];
          const newPriceUSD = currentPriceUSD * (1 + movement);
          const newPrice = newPriceUSD * CURRENCY_RATES[currency];
          return {
            ...asset,
            price: newPrice,
            value: asset.balance * newPrice
          };
        });
        calculateTotals(updated);
        return updated;
      });
    }, 3e3);
    return () => clearInterval(interval);
  }, [assets.length, currency]);
  reactExports.useEffect(() => {
    setAssets((currentAssets) => {
      return currentAssets.map((asset) => {
        return {
          ...asset,
          price: asset.price * CURRENCY_RATES[currency],
          // This accumulates error if swapped back and forth, but fine for demo
          value: asset.balance * (asset.price * CURRENCY_RATES[currency])
        };
      });
    });
  }, [currency]);
  const calculateTotals = (currentAssets) => {
    const total = currentAssets.reduce((acc, curr) => acc + curr.value, 0);
    setTotalBalance(total);
    const weightedChange = currentAssets.reduce((acc, curr) => {
      const val = curr.value || 0;
      const tot = total || 1;
      return acc + curr.change24h * (val / tot);
    }, 0);
    setPortfolioChange(weightedChange);
  };
  const addAsset = async (asset) => {
    try {
      await apiService.addWalletAsset({
        symbol: asset.symbol,
        name: asset.name,
        balance: asset.balance,
        color: asset.color,
        icon: asset.icon
      });
      loadAssets();
    } catch (error) {
      console.error("Failed to add asset", error);
    }
  };
  return {
    totalBalance,
    portfolioChange,
    assets,
    currency,
    setCurrency,
    currencySymbol: CURRENCY_SYMBOLS[currency],
    addAsset,
    loading,
    walletAddress
  };
};
const WalletActionModal = ({ isOpen, onClose, defaultAction = "send", walletAddress }) => {
  const { toast } = useToast();
  const [activeTab, setActiveTab] = reactExports.useState(defaultAction);
  const [isLoading, setIsLoading] = reactExports.useState(false);
  const [sendAddress, setSendAddress] = reactExports.useState("");
  const [sendAmount, setSendAmount] = reactExports.useState("");
  const [sendAsset, setSendAsset] = reactExports.useState("BTC");
  const [swapFrom, setSwapFrom] = reactExports.useState("BTC");
  const [swapTo, setSwapTo] = reactExports.useState("ETH");
  const [swapAmount, setSwapAmount] = reactExports.useState("");
  const handleCopy = (text) => {
    navigator.clipboard.writeText(text);
    toast({
      title: "Copied!",
      description: "Address copied to clipboard"
    });
  };
  const handleSend = async () => {
    var _a, _b;
    setIsLoading(true);
    try {
      await apiService.sendCrypto({
        address: sendAddress,
        amount: parseFloat(sendAmount),
        symbol: sendAsset
      });
      toast({
        title: "Transaction Sent",
        description: `Successfully sent ${sendAmount} ${sendAsset} to ${sendAddress.substring(0, 6)}...`,
        className: "bg-green-500 text-white border-none"
      });
      onClose();
    } catch (error) {
      console.error("Transfer failed", error);
      toast({
        title: "Transfer Failed",
        description: ((_b = (_a = error.response) == null ? void 0 : _a.data) == null ? void 0 : _b.error) || "Failed to send transaction. Please try again.",
        variant: "destructive"
      });
    } finally {
      setIsLoading(false);
    }
  };
  const handleSwap = async () => {
    setIsLoading(true);
    await new Promise((resolve) => setTimeout(resolve, 2e3));
    setIsLoading(false);
    toast({
      title: "Swap Successful",
      description: `Swapped ${swapAmount} ${swapFrom} to ${swapTo}`,
      className: "bg-green-500 text-white border-none"
    });
    onClose();
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Dialog, { open: isOpen, onOpenChange: (open) => !open && onClose(), children: /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { className: "sm:max-w-[425px] glass-card border-white/10", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogHeader, { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTitle, { children: "Wallet Actions" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(DialogDescription, { children: "Send, receive, or swap your crypto assets instantly." })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { defaultValue: defaultAction, value: activeTab, onValueChange: setActiveTab, className: "w-full", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { className: "grid w-full grid-cols-3 mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "send", children: "Send" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "receive", children: "Receive" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "swap", children: "Swap" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "send", className: "space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "asset", children: "Asset" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Select, { value: sendAsset, onValueChange: setSendAsset, children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, { placeholder: "Select asset" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "BTC", children: "Bitcoin (BTC)" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "ETH", children: "Ethereum (ETH)" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "USDT", children: "Tether (USDT)" })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "address", children: "Recipient Address" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Input,
            {
              id: "address",
              placeholder: "0x...",
              value: sendAddress,
              onChange: (e) => setSendAddress(e.target.value)
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "amount", children: "Amount" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                id: "amount",
                type: "number",
                placeholder: "0.00",
                value: sendAmount,
                onChange: (e) => setSendAmount(e.target.value)
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "absolute right-3 top-2.5 text-sm text-muted-foreground", children: sendAsset })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(DialogFooter, { className: "pt-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "w-full bg-flashcore-purple hover:bg-flashcore-purple/90", onClick: handleSend, disabled: isLoading, children: [
          isLoading ? "Broadcasting..." : "Send Transaction",
          !isLoading && /* @__PURE__ */ jsxRuntimeExports.jsx(Send, { className: "w-4 h-4 ml-2" })
        ] }) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "receive", className: "space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center justify-center py-4 bg-white/5 rounded-lg border border-white/5", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-white p-2 rounded-lg mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(QrCode, { className: "w-32 h-32 text-black" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-center text-muted-foreground mb-4", children: [
            "Scan to receive ",
            sendAsset
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2 w-full px-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { readOnly: true, value: walletAddress || "Generating address...", className: "font-mono text-xs" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "icon", variant: "outline", onClick: () => handleCopy(walletAddress || ""), disabled: !walletAddress, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { className: "w-4 h-4" }) })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center text-xs text-muted-foreground", children: [
          "Only send ",
          sendAsset ? sendAsset : "Supported Assets",
          " to this address. Sending other assets may result in permanent loss."
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "swap", className: "space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "From" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  type: "number",
                  placeholder: "0.00",
                  value: swapAmount,
                  onChange: (e) => setSwapAmount(e.target.value),
                  className: "flex-1"
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Select, { value: swapFrom, onValueChange: setSwapFrom, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { className: "w-[100px]", children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, {}) }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "BTC", children: "BTC" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "ETH", children: "ETH" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "USDT", children: "USDT" })
                ] })
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex justify-center -my-2 relative z-10", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-background rounded-full p-2 border border-border shadow-sm", children: /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowLeftRight, { className: "w-4 h-4 rotate-90" }) }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { children: "To (Estimated)" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  readOnly: true,
                  value: swapAmount ? (parseFloat(swapAmount || "0") * 14.5).toFixed(4) : "",
                  className: "flex-1 bg-muted/50"
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Select, { value: swapTo, onValueChange: setSwapTo, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { className: "w-[100px]", children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, {}) }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "BTC", children: "BTC" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "ETH", children: "ETH" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "USDT", children: "USDT" })
                ] })
              ] })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(DialogFooter, { className: "pt-4", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "w-full bg-flashcore-green hover:bg-flashcore-green/90 text-white", onClick: handleSwap, disabled: isLoading, children: [
          isLoading ? "Swapping..." : "Swap Assets",
          !isLoading && /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowLeftRight, { className: "w-4 h-4 ml-2" })
        ] }) })
      ] })
    ] })
  ] }) });
};
const PREDEFINED_COLORS = [
  { name: "Blue", value: "from-blue-500 to-indigo-600" },
  { name: "Purple", value: "from-purple-500 to-pink-600" },
  { name: "Green", value: "from-green-500 to-emerald-600" },
  { name: "Orange", value: "from-orange-500 to-red-600" },
  { name: "Yellow", value: "from-yellow-400 to-orange-500" },
  { name: "Gray", value: "from-gray-500 to-gray-700" }
];
const AddAssetModal = ({ isOpen, onClose, onAdd }) => {
  const [name, setName] = reactExports.useState("");
  const [symbol, setSymbol] = reactExports.useState("");
  const [balance, setBalance] = reactExports.useState("");
  const [price, setPrice] = reactExports.useState("");
  const [color, setColor] = reactExports.useState(PREDEFINED_COLORS[0].value);
  const handleSubmit = (e) => {
    e.preventDefault();
    if (!name || !symbol || !balance || !price) return;
    onAdd({
      name,
      symbol: symbol.toUpperCase(),
      balance: parseFloat(balance),
      price: parseFloat(price),
      icon: "Wallet",
      // Default icon for custom assets
      color
    });
    setName("");
    setSymbol("");
    setBalance("");
    setPrice("");
    onClose();
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Dialog, { open: isOpen, onOpenChange: (open) => !open && onClose(), children: /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogContent, { className: "sm:max-w-[425px]", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs(DialogHeader, { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(DialogTitle, { children: "Add Custom Asset" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(DialogDescription, { children: "Track any token or asset manually in your portfolio." })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: handleSubmit, className: "grid gap-4 py-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-4 items-center gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "name", className: "text-right", children: "Name" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { id: "name", value: name, onChange: (e) => setName(e.target.value), placeholder: "e.g. Pepe", className: "col-span-3", required: true })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-4 items-center gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "symbol", className: "text-right", children: "Symbol" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { id: "symbol", value: symbol, onChange: (e) => setSymbol(e.target.value), placeholder: "e.g. PEPE", className: "col-span-3", required: true })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-4 items-center gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "price", className: "text-right", children: "Price ($)" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { id: "price", type: "number", step: "0.00000001", value: price, onChange: (e) => setPrice(e.target.value), placeholder: "0.00004", className: "col-span-3", required: true })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-4 items-center gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "balance", className: "text-right", children: "Balance" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { id: "balance", type: "number", step: "any", value: balance, onChange: (e) => setBalance(e.target.value), placeholder: "100000", className: "col-span-3", required: true })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-4 items-center gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "color", className: "text-right", children: "Color" }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Select, { value: color, onValueChange: setColor, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { className: "col-span-3", children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, {}) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(SelectContent, { children: PREDEFINED_COLORS.map((c) => /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: c.value, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `w-4 h-4 rounded-full bg-gradient-to-br ${c.value}` }),
            c.name
          ] }) }, c.value)) })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(DialogFooter, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { type: "submit", children: "Add Asset" }) })
    ] })
  ] }) });
};
const TransactionHistory = () => {
  const [transactions, setTransactions] = React.useState([]);
  const [loading, setLoading] = React.useState(true);
  React.useEffect(() => {
    loadTransactions();
  }, []);
  const loadTransactions = async () => {
    try {
      const response = await apiService.getTransactions();
      if (response.data && response.data.transactions) {
        setTransactions(response.data.transactions);
      }
    } catch (error) {
      console.error("Failed to load transactions", error);
    } finally {
      setLoading(false);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "h-full", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "flex flex-row items-center justify-between space-y-0 pb-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl font-bold", children: "Transaction History" }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative w-[200px]", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-2 top-2.5 h-4 w-4 text-muted-foreground" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Input, { placeholder: "Search...", className: "pl-8 h-9" })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-4 max-h-[600px] overflow-y-auto pr-2 custom-scrollbar", children: loading ? /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-center text-muted-foreground py-8", children: "Loading transactions..." }) : transactions.length === 0 ? /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-center text-muted-foreground py-8", children: "No transactions found." }) : transactions.map((tx) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-3 rounded-lg hover:bg-muted/30 transition-colors border border-transparent hover:border-border/50", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `w-10 h-10 rounded-full flex items-center justify-center ${tx.type === "receive" ? "bg-green-500/10 text-green-500" : tx.type === "send" ? "bg-red-500/10 text-red-500" : "bg-blue-500/10 text-blue-500"}`, children: [
          tx.type === "receive" && /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowDownLeft, { className: "w-5 h-5" }),
          tx.type === "send" && /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowUpRight, { className: "w-5 h-5" }),
          tx.type === "swap" && /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCcw, { className: "w-5 h-5" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "font-medium capitalize", children: tx.type === "swap" ? `Swap ${tx.from} to ${tx.to}` : `${tx.type} ${tx.asset}` }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-xs text-muted-foreground", children: [
            tx.date,
            " • ",
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: tx.status === "completed" ? "text-green-500" : "text-yellow-500", children: tx.status })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-right", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `font-bold ${tx.type === "receive" ? "text-green-500" : tx.type === "send" ? "text-foreground" : "text-blue-500"}`, children: [
          tx.type === "receive" ? "+" : tx.type === "send" ? "-" : "",
          tx.type === "swap" ? tx.amountIn : tx.amount,
          " ",
          tx.type === "swap" ? tx.from : tx.asset
        ] }),
        tx.counterparty && tx.counterparty !== "Unknown" && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-[10px] text-muted-foreground max-w-[100px] truncate ml-auto", title: tx.counterparty, children: tx.counterparty.startsWith("0x") ? `${tx.counterparty.substring(0, 6)}...` : tx.counterparty })
      ] })
    ] }, tx.id)) }) })
  ] });
};
const AssetIcon = ({ symbol }) => {
  const localMap = {
    btc: "bitcoin.png",
    eth: "ethereum.png",
    usdt: "tether.png",
    bnb: "binance.png",
    sol: "solana.png",
    xrp: "xrp.png",
    ada: "cardano.png",
    avax: "avalanch.png",
    doge: "logo.png",
    dot: "polkadot.png",
    matic: "polygone.png",
    ltc: "litecoin.png",
    trx: "tron.png",
    atom: "cosmos.png",
    link: "chainlink.png",
    xlm: "stellar.png",
    algo: "algorand.png",
    xmr: "monero.png",
    eos: "eos.png",
    bch: "bitcoin.png",
    fil: "filecoin.png",
    aave: "aave.png",
    uni: "uniswap.png",
    usdc: "usd.png",
    shib: "logo.png",
    apt: "apt.png",
    near: "near.png",
    ton: "ton.png",
    flow: "flow.png",
    miota: "iota.png"
  };
  const file = localMap[symbol.toLowerCase()] || `${symbol.toLowerCase()}.png`;
  const src = `/images/${file}`;
  return /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-10 h-10 flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx("img", { src, alt: symbol, className: "w-9 h-9 object-contain" }) });
};
const WalletPage = () => {
  const navigate = useNavigate();
  const [actionModalOpen, setActionModalOpen] = reactExports.useState(false);
  const [addAssetModalOpen, setAddAssetModalOpen] = reactExports.useState(false);
  const [modalAction, setModalAction] = reactExports.useState("send");
  const [lendingModalOpen, setLendingModalOpen] = reactExports.useState(false);
  const [selectedLendingMarket, setSelectedLendingMarket] = reactExports.useState(null);
  const [lendingAction, setLendingAction] = reactExports.useState("supply");
  const { markets, refresh: refreshLending } = useLendingData();
  const {
    totalBalance,
    portfolioChange,
    assets,
    currency,
    setCurrency,
    currencySymbol,
    addAsset,
    walletAddress
  } = useWalletPortfolio();
  const openAction = (action) => {
    setModalAction(action);
    setActionModalOpen(true);
  };
  const openLending = (symbol) => {
    const market = markets.find((m) => m.symbol.toUpperCase() === symbol.toUpperCase());
    if (market) {
      setSelectedLendingMarket(market);
      setLendingAction("supply");
      setLendingModalOpen(true);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-8 animate-in fade-in duration-500", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col md:flex-row justify-between items-start md:items-center gap-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "My Wallet" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Manage your crypto assets and transactions" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-wrap gap-2 items-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Select, { value: currency, onValueChange: (v) => setCurrency(v), children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(SelectTrigger, { className: "w-[115px] border-border/50 bg-background/50 backdrop-blur-sm", children: /* @__PURE__ */ jsxRuntimeExports.jsx(SelectValue, {}) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(SelectContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "USD", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "w-4 text-center font-bold", children: "$" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "USD" })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "EUR", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "w-4 text-center font-bold", children: "€" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "EUR" })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "GBP", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "w-4 text-center font-bold", children: "£" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "GBP" })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "JPY", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "w-4 text-center font-bold", children: "¥" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "JPY" })
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(SelectItem, { value: "NGN", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "w-4 text-center font-bold", children: "₦" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "NGN" })
            ] }) })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { onClick: () => openAction("send"), className: "bg-flashcore-purple hover:bg-purple-700", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowUpRight, { className: "mr-2 h-4 w-4" }),
          " Send"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { onClick: () => openAction("receive"), variant: "outline", className: "border-flashcore-green text-flashcore-green hover:bg-flashcore-green/10", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowDownLeft, { className: "mr-2 h-4 w-4" }),
          " Receive"
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-3 gap-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "lg:col-span-2 bg-gradient-to-br from-background to-secondary/10 border-border/50 overflow-hidden relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-0 right-0 p-32 bg-flashcore-purple/5 blur-[100px] rounded-full pointer-events-none" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-sm font-medium text-muted-foreground uppercase tracking-wider", children: "Total Portfolio Value" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-baseline gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-4xl md:text-5xl font-bold font-mono", children: [
              currencySymbol,
              totalBalance.toLocaleString("en-US", { minimumFractionDigits: 2, maximumFractionDigits: 2 })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `flex items-center gap-1 px-2 py-1 rounded-full text-sm font-medium ${portfolioChange >= 0 ? "text-green-500 bg-green-500/10" : "text-red-500 bg-red-500/10"}`, children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: `w-3 h-3 ${portfolioChange < 0 ? "rotate-180" : ""}` }),
              portfolioChange >= 0 ? "+" : "",
              portfolioChange.toFixed(2),
              "%"
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "mt-8 grid grid-cols-3 gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "p-4 rounded-xl bg-background/50 border border-border/50 backdrop-blur-sm", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground mb-1", children: "Available" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-lg font-bold text-foreground", children: [
                currencySymbol,
                (totalBalance * 0.85).toLocaleString("en-US", { maximumFractionDigits: 0 })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "p-4 rounded-xl bg-background/50 border border-border/50 backdrop-blur-sm", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground mb-1", children: "In Orders" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-lg font-bold text-foreground", children: [
                currencySymbol,
                (totalBalance * 0.05).toLocaleString("en-US", { maximumFractionDigits: 0 })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "p-4 rounded-xl bg-background/50 border border-border/50 backdrop-blur-sm", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-xs text-muted-foreground mb-1", children: "Staked" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-lg font-bold text-foreground", children: [
                currencySymbol,
                (totalBalance * 0.1).toLocaleString("en-US", { maximumFractionDigits: 0 })
              ] })
            ] })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "flex flex-col justify-center items-center bg-gradient-to-br from-flashcore-purple/20 to-flashcore-green/20 border-border/50 text-center p-6 space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-16 h-16 rounded-full bg-background/30 backdrop-blur-md flex items-center justify-center border border-white/10 shadow-xl", children: /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCcw, { className: "w-8 h-8 text-white" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-bold", children: "Swap Crypto Instantly" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground/80 max-w-[200px]", children: "Exchange assets with zero fees on your first swap." }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { onClick: () => openAction("swap"), className: "w-full bg-white text-black hover:bg-gray-200", children: "Swap Now" })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-3 gap-6 items-start", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "lg:col-span-2 space-y-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl font-bold tracking-tight", children: "Your Assets" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", onClick: () => setAddAssetModalOpen(true), className: "border-border/50 bg-background/50 hover:bg-muted", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Plus, { className: "w-4 h-4 mr-2" }),
            "Add Asset"
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 xl:grid-cols-3 gap-4", children: assets.map((asset) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "group relative overflow-hidden border-border/50 bg-background/50 backdrop-blur-sm hover:shadow-xl hover:border-flashcore-purple/30 transition-all duration-300", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 bg-gradient-to-br from-flashcore-purple/5 to-flashcore-green/5 opacity-0 group-hover:opacity-100 transition-opacity pointer-events-none" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { className: "p-5 pb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between gap-3", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(AssetIcon, { symbol: asset.symbol }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-bold text-base leading-tight", children: asset.name }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xs text-muted-foreground font-medium uppercase tracking-tight", children: asset.symbol })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "icon", variant: "ghost", className: "h-8 w-8 text-muted-foreground hover:text-foreground", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Ellipsis, { className: "h-4 w-4" }) })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-5 py-4 space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-2xl font-bold font-mono tracking-tighter", children: [
                asset.balance.toLocaleString(),
                " ",
                asset.symbol
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-sm text-muted-foreground font-medium", children: [
                "≈ ",
                currencySymbol,
                asset.value.toLocaleString("en-US", { minimumFractionDigits: 2, maximumFractionDigits: 2 })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between pt-2 border-t border-border/30", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-[10px] uppercase font-bold text-muted-foreground tracking-wider mb-0.5", children: "Price" }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-sm font-semibold font-mono", children: [
                  currencySymbol,
                  asset.price.toLocaleString("en-US", { minimumFractionDigits: 2, maximumFractionDigits: 6 })
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `flex items-center gap-1 px-2 py-0.5 rounded-full text-xs font-bold ${asset.change24h >= 0 ? "text-green-500 bg-green-500/10" : "text-red-500 bg-red-500/10"}`, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(TrendingUp, { className: `w-3 h-3 ${asset.change24h < 0 ? "rotate-180" : ""}` }),
                asset.change24h >= 0 ? "+" : "",
                asset.change24h ? asset.change24h.toFixed(2) : "0.00",
                "%"
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardFooter, { className: "p-5 pt-0 flex gap-2", children: [
            markets.some((m) => m.symbol === asset.symbol) && /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                size: "sm",
                variant: "outline",
                className: "flex-1 h-9 bg-flashcore-green/5 text-flashcore-green border-flashcore-green/20 hover:bg-flashcore-green/10 hover:border-flashcore-green/30 font-bold text-xs",
                onClick: () => openLending(asset.symbol),
                children: "Lend"
              }
            ),
            ["BTC", "ETH", "USDT", "SOL"].includes(asset.symbol) && /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                size: "sm",
                variant: "outline",
                className: "flex-1 h-9 bg-flashcore-purple/5 text-flashcore-purple border-flashcore-purple/20 hover:bg-flashcore-purple/10 hover:border-flashcore-purple/30 font-bold text-xs",
                onClick: () => navigate("/staking"),
                children: "Stake"
              }
            )
          ] })
        ] }, asset.id)) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "lg:col-span-1", children: /* @__PURE__ */ jsxRuntimeExports.jsx(TransactionHistory, {}) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      WalletActionModal,
      {
        isOpen: actionModalOpen,
        onClose: () => setActionModalOpen(false),
        defaultAction: modalAction,
        walletAddress
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      AddAssetModal,
      {
        isOpen: addAssetModalOpen,
        onClose: () => setAddAssetModalOpen(false),
        onAdd: addAsset
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      LendingActionModal,
      {
        isOpen: lendingModalOpen,
        onClose: () => setLendingModalOpen(false),
        market: selectedLendingMarket,
        action: lendingAction,
        onSuccess: () => {
          refreshLending();
        }
      }
    )
  ] }) });
};
export {
  WalletPage as default
};
//# sourceMappingURL=WalletPage-u4W0_EM0.js.map
