import { c as createLucideIcon, a3 as createContextScope, r as reactExports, a5 as useControllableState, j as jsxRuntimeExports, an as useId, a6 as Primitive, a7 as composeEventHandlers, a8 as Presence, a4 as useComposedRefs, aB as useLayoutEffect2, ay as createCollection, y as React, am as useDirection, P as cn, p as useNavigate, L as Layout, i as Card, l as CardHeader, m as CardTitle, n as CardDescription, k as CardContent, C as CircleCheckBig, B as Button, x as CardFooter, S as Shield, w as Lock } from "./index-GlGoHQS3.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-jrC1WfMe.js";
import { B as Badge } from "./badge-CPhJg0YM.js";
import { C as ChevronDown } from "./chevron-down-CfVNtG1C.js";
import { P as Play } from "./play-M8AY3OSD.js";
import { S as Settings } from "./settings-CxhYnKqf.js";
import { C as Clock } from "./clock-zJerAcLz.js";
import { W as Wallet } from "./wallet-B5o1Kmtv.js";
import { C as Coins } from "./coins-oiIje05R.js";
import { Z as Zap } from "./zap-DzaCSTJR.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const ArrowRightLeft = createLucideIcon("ArrowRightLeft", [
  ["path", { d: "m16 3 4 4-4 4", key: "1x1c3m" }],
  ["path", { d: "M20 7H4", key: "zbl0bi" }],
  ["path", { d: "m8 21-4-4 4-4", key: "h9nckh" }],
  ["path", { d: "M4 17h16", key: "g4d7ey" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Book = createLucideIcon("Book", [
  [
    "path",
    {
      d: "M4 19.5v-15A2.5 2.5 0 0 1 6.5 2H19a1 1 0 0 1 1 1v18a1 1 0 0 1-1 1H6.5a1 1 0 0 1 0-5H20",
      key: "k3hazp"
    }
  ]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const PiggyBank = createLucideIcon("PiggyBank", [
  [
    "path",
    {
      d: "M19 5c-1.5 0-2.8 1.4-3 2-3.5-1.5-11-.3-11 5 0 1.8 0 3 2 4.5V20h4v-2h3v2h4v-4c1-.5 1.7-1 2-2h2v-4h-2c0-1-.5-1.5-1-2V5z",
      key: "1ivx2i"
    }
  ],
  ["path", { d: "M2 9v1c0 1.1.9 2 2 2h1", key: "nm575m" }],
  ["path", { d: "M16 11h.01", key: "xkw8gn" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const UserCog = createLucideIcon("UserCog", [
  ["circle", { cx: "18", cy: "15", r: "3", key: "gjjjvw" }],
  ["circle", { cx: "9", cy: "7", r: "4", key: "nufk8" }],
  ["path", { d: "M10 15H6a4 4 0 0 0-4 4v2", key: "1nfge6" }],
  ["path", { d: "m21.7 16.4-.9-.3", key: "12j9ji" }],
  ["path", { d: "m15.2 13.9-.9-.3", key: "1fdjdi" }],
  ["path", { d: "m16.6 18.7.3-.9", key: "heedtr" }],
  ["path", { d: "m19.1 12.2.3-.9", key: "1af3ki" }],
  ["path", { d: "m19.6 18.7-.4-1", key: "1x9vze" }],
  ["path", { d: "m16.8 12.3-.4-1", key: "vqeiwj" }],
  ["path", { d: "m14.3 16.6 1-.4", key: "1qlj63" }],
  ["path", { d: "m20.7 13.8 1-.4", key: "1v5t8k" }]
]);
var COLLAPSIBLE_NAME = "Collapsible";
var [createCollapsibleContext, createCollapsibleScope] = createContextScope(COLLAPSIBLE_NAME);
var [CollapsibleProvider, useCollapsibleContext] = createCollapsibleContext(COLLAPSIBLE_NAME);
var Collapsible = reactExports.forwardRef(
  (props, forwardedRef) => {
    const {
      __scopeCollapsible,
      open: openProp,
      defaultOpen,
      disabled,
      onOpenChange,
      ...collapsibleProps
    } = props;
    const [open = false, setOpen] = useControllableState({
      prop: openProp,
      defaultProp: defaultOpen,
      onChange: onOpenChange
    });
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      CollapsibleProvider,
      {
        scope: __scopeCollapsible,
        disabled,
        contentId: useId(),
        open,
        onOpenToggle: reactExports.useCallback(() => setOpen((prevOpen) => !prevOpen), [setOpen]),
        children: /* @__PURE__ */ jsxRuntimeExports.jsx(
          Primitive.div,
          {
            "data-state": getState$1(open),
            "data-disabled": disabled ? "" : void 0,
            ...collapsibleProps,
            ref: forwardedRef
          }
        )
      }
    );
  }
);
Collapsible.displayName = COLLAPSIBLE_NAME;
var TRIGGER_NAME$1 = "CollapsibleTrigger";
var CollapsibleTrigger = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeCollapsible, ...triggerProps } = props;
    const context = useCollapsibleContext(TRIGGER_NAME$1, __scopeCollapsible);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      Primitive.button,
      {
        type: "button",
        "aria-controls": context.contentId,
        "aria-expanded": context.open || false,
        "data-state": getState$1(context.open),
        "data-disabled": context.disabled ? "" : void 0,
        disabled: context.disabled,
        ...triggerProps,
        ref: forwardedRef,
        onClick: composeEventHandlers(props.onClick, context.onOpenToggle)
      }
    );
  }
);
CollapsibleTrigger.displayName = TRIGGER_NAME$1;
var CONTENT_NAME$1 = "CollapsibleContent";
var CollapsibleContent = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { forceMount, ...contentProps } = props;
    const context = useCollapsibleContext(CONTENT_NAME$1, props.__scopeCollapsible);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Presence, { present: forceMount || context.open, children: ({ present }) => /* @__PURE__ */ jsxRuntimeExports.jsx(CollapsibleContentImpl, { ...contentProps, ref: forwardedRef, present }) });
  }
);
CollapsibleContent.displayName = CONTENT_NAME$1;
var CollapsibleContentImpl = reactExports.forwardRef((props, forwardedRef) => {
  const { __scopeCollapsible, present, children, ...contentProps } = props;
  const context = useCollapsibleContext(CONTENT_NAME$1, __scopeCollapsible);
  const [isPresent, setIsPresent] = reactExports.useState(present);
  const ref = reactExports.useRef(null);
  const composedRefs = useComposedRefs(forwardedRef, ref);
  const heightRef = reactExports.useRef(0);
  const height = heightRef.current;
  const widthRef = reactExports.useRef(0);
  const width = widthRef.current;
  const isOpen = context.open || isPresent;
  const isMountAnimationPreventedRef = reactExports.useRef(isOpen);
  const originalStylesRef = reactExports.useRef();
  reactExports.useEffect(() => {
    const rAF = requestAnimationFrame(() => isMountAnimationPreventedRef.current = false);
    return () => cancelAnimationFrame(rAF);
  }, []);
  useLayoutEffect2(() => {
    const node = ref.current;
    if (node) {
      originalStylesRef.current = originalStylesRef.current || {
        transitionDuration: node.style.transitionDuration,
        animationName: node.style.animationName
      };
      node.style.transitionDuration = "0s";
      node.style.animationName = "none";
      const rect = node.getBoundingClientRect();
      heightRef.current = rect.height;
      widthRef.current = rect.width;
      if (!isMountAnimationPreventedRef.current) {
        node.style.transitionDuration = originalStylesRef.current.transitionDuration;
        node.style.animationName = originalStylesRef.current.animationName;
      }
      setIsPresent(present);
    }
  }, [context.open, present]);
  return /* @__PURE__ */ jsxRuntimeExports.jsx(
    Primitive.div,
    {
      "data-state": getState$1(context.open),
      "data-disabled": context.disabled ? "" : void 0,
      id: context.contentId,
      hidden: !isOpen,
      ...contentProps,
      ref: composedRefs,
      style: {
        [`--radix-collapsible-content-height`]: height ? `${height}px` : void 0,
        [`--radix-collapsible-content-width`]: width ? `${width}px` : void 0,
        ...props.style
      },
      children: isOpen && children
    }
  );
});
function getState$1(open) {
  return open ? "open" : "closed";
}
var Root = Collapsible;
var Trigger = CollapsibleTrigger;
var Content = CollapsibleContent;
var ACCORDION_NAME = "Accordion";
var ACCORDION_KEYS = ["Home", "End", "ArrowDown", "ArrowUp", "ArrowLeft", "ArrowRight"];
var [Collection, useCollection, createCollectionScope] = createCollection(ACCORDION_NAME);
var [createAccordionContext, createAccordionScope] = createContextScope(ACCORDION_NAME, [
  createCollectionScope,
  createCollapsibleScope
]);
var useCollapsibleScope = createCollapsibleScope();
var Accordion$1 = React.forwardRef(
  (props, forwardedRef) => {
    const { type, ...accordionProps } = props;
    const singleProps = accordionProps;
    const multipleProps = accordionProps;
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Collection.Provider, { scope: props.__scopeAccordion, children: type === "multiple" ? /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionImplMultiple, { ...multipleProps, ref: forwardedRef }) : /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionImplSingle, { ...singleProps, ref: forwardedRef }) });
  }
);
Accordion$1.displayName = ACCORDION_NAME;
var [AccordionValueProvider, useAccordionValueContext] = createAccordionContext(ACCORDION_NAME);
var [AccordionCollapsibleProvider, useAccordionCollapsibleContext] = createAccordionContext(
  ACCORDION_NAME,
  { collapsible: false }
);
var AccordionImplSingle = React.forwardRef(
  (props, forwardedRef) => {
    const {
      value: valueProp,
      defaultValue,
      onValueChange = () => {
      },
      collapsible = false,
      ...accordionSingleProps
    } = props;
    const [value, setValue] = useControllableState({
      prop: valueProp,
      defaultProp: defaultValue,
      onChange: onValueChange
    });
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      AccordionValueProvider,
      {
        scope: props.__scopeAccordion,
        value: value ? [value] : [],
        onItemOpen: setValue,
        onItemClose: React.useCallback(() => collapsible && setValue(""), [collapsible, setValue]),
        children: /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionCollapsibleProvider, { scope: props.__scopeAccordion, collapsible, children: /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionImpl, { ...accordionSingleProps, ref: forwardedRef }) })
      }
    );
  }
);
var AccordionImplMultiple = React.forwardRef((props, forwardedRef) => {
  const {
    value: valueProp,
    defaultValue,
    onValueChange = () => {
    },
    ...accordionMultipleProps
  } = props;
  const [value = [], setValue] = useControllableState({
    prop: valueProp,
    defaultProp: defaultValue,
    onChange: onValueChange
  });
  const handleItemOpen = React.useCallback(
    (itemValue) => setValue((prevValue = []) => [...prevValue, itemValue]),
    [setValue]
  );
  const handleItemClose = React.useCallback(
    (itemValue) => setValue((prevValue = []) => prevValue.filter((value2) => value2 !== itemValue)),
    [setValue]
  );
  return /* @__PURE__ */ jsxRuntimeExports.jsx(
    AccordionValueProvider,
    {
      scope: props.__scopeAccordion,
      value,
      onItemOpen: handleItemOpen,
      onItemClose: handleItemClose,
      children: /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionCollapsibleProvider, { scope: props.__scopeAccordion, collapsible: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionImpl, { ...accordionMultipleProps, ref: forwardedRef }) })
    }
  );
});
var [AccordionImplProvider, useAccordionContext] = createAccordionContext(ACCORDION_NAME);
var AccordionImpl = React.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, disabled, dir, orientation = "vertical", ...accordionProps } = props;
    const accordionRef = React.useRef(null);
    const composedRefs = useComposedRefs(accordionRef, forwardedRef);
    const getItems = useCollection(__scopeAccordion);
    const direction = useDirection(dir);
    const isDirectionLTR = direction === "ltr";
    const handleKeyDown = composeEventHandlers(props.onKeyDown, (event) => {
      var _a;
      if (!ACCORDION_KEYS.includes(event.key)) return;
      const target = event.target;
      const triggerCollection = getItems().filter((item) => {
        var _a2;
        return !((_a2 = item.ref.current) == null ? void 0 : _a2.disabled);
      });
      const triggerIndex = triggerCollection.findIndex((item) => item.ref.current === target);
      const triggerCount = triggerCollection.length;
      if (triggerIndex === -1) return;
      event.preventDefault();
      let nextIndex = triggerIndex;
      const homeIndex = 0;
      const endIndex = triggerCount - 1;
      const moveNext = () => {
        nextIndex = triggerIndex + 1;
        if (nextIndex > endIndex) {
          nextIndex = homeIndex;
        }
      };
      const movePrev = () => {
        nextIndex = triggerIndex - 1;
        if (nextIndex < homeIndex) {
          nextIndex = endIndex;
        }
      };
      switch (event.key) {
        case "Home":
          nextIndex = homeIndex;
          break;
        case "End":
          nextIndex = endIndex;
          break;
        case "ArrowRight":
          if (orientation === "horizontal") {
            if (isDirectionLTR) {
              moveNext();
            } else {
              movePrev();
            }
          }
          break;
        case "ArrowDown":
          if (orientation === "vertical") {
            moveNext();
          }
          break;
        case "ArrowLeft":
          if (orientation === "horizontal") {
            if (isDirectionLTR) {
              movePrev();
            } else {
              moveNext();
            }
          }
          break;
        case "ArrowUp":
          if (orientation === "vertical") {
            movePrev();
          }
          break;
      }
      const clampedIndex = nextIndex % triggerCount;
      (_a = triggerCollection[clampedIndex].ref.current) == null ? void 0 : _a.focus();
    });
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      AccordionImplProvider,
      {
        scope: __scopeAccordion,
        disabled,
        direction: dir,
        orientation,
        children: /* @__PURE__ */ jsxRuntimeExports.jsx(Collection.Slot, { scope: __scopeAccordion, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
          Primitive.div,
          {
            ...accordionProps,
            "data-orientation": orientation,
            ref: composedRefs,
            onKeyDown: disabled ? void 0 : handleKeyDown
          }
        ) })
      }
    );
  }
);
var ITEM_NAME = "AccordionItem";
var [AccordionItemProvider, useAccordionItemContext] = createAccordionContext(ITEM_NAME);
var AccordionItem$1 = React.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, value, ...accordionItemProps } = props;
    const accordionContext = useAccordionContext(ITEM_NAME, __scopeAccordion);
    const valueContext = useAccordionValueContext(ITEM_NAME, __scopeAccordion);
    const collapsibleScope = useCollapsibleScope(__scopeAccordion);
    const triggerId = useId();
    const open = value && valueContext.value.includes(value) || false;
    const disabled = accordionContext.disabled || props.disabled;
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      AccordionItemProvider,
      {
        scope: __scopeAccordion,
        open,
        disabled,
        triggerId,
        children: /* @__PURE__ */ jsxRuntimeExports.jsx(
          Root,
          {
            "data-orientation": accordionContext.orientation,
            "data-state": getState(open),
            ...collapsibleScope,
            ...accordionItemProps,
            ref: forwardedRef,
            disabled,
            open,
            onOpenChange: (open2) => {
              if (open2) {
                valueContext.onItemOpen(value);
              } else {
                valueContext.onItemClose(value);
              }
            }
          }
        )
      }
    );
  }
);
AccordionItem$1.displayName = ITEM_NAME;
var HEADER_NAME = "AccordionHeader";
var AccordionHeader = React.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, ...headerProps } = props;
    const accordionContext = useAccordionContext(ACCORDION_NAME, __scopeAccordion);
    const itemContext = useAccordionItemContext(HEADER_NAME, __scopeAccordion);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      Primitive.h3,
      {
        "data-orientation": accordionContext.orientation,
        "data-state": getState(itemContext.open),
        "data-disabled": itemContext.disabled ? "" : void 0,
        ...headerProps,
        ref: forwardedRef
      }
    );
  }
);
AccordionHeader.displayName = HEADER_NAME;
var TRIGGER_NAME = "AccordionTrigger";
var AccordionTrigger$1 = React.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, ...triggerProps } = props;
    const accordionContext = useAccordionContext(ACCORDION_NAME, __scopeAccordion);
    const itemContext = useAccordionItemContext(TRIGGER_NAME, __scopeAccordion);
    const collapsibleContext = useAccordionCollapsibleContext(TRIGGER_NAME, __scopeAccordion);
    const collapsibleScope = useCollapsibleScope(__scopeAccordion);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Collection.ItemSlot, { scope: __scopeAccordion, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
      Trigger,
      {
        "aria-disabled": itemContext.open && !collapsibleContext.collapsible || void 0,
        "data-orientation": accordionContext.orientation,
        id: itemContext.triggerId,
        ...collapsibleScope,
        ...triggerProps,
        ref: forwardedRef
      }
    ) });
  }
);
AccordionTrigger$1.displayName = TRIGGER_NAME;
var CONTENT_NAME = "AccordionContent";
var AccordionContent$1 = React.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, ...contentProps } = props;
    const accordionContext = useAccordionContext(ACCORDION_NAME, __scopeAccordion);
    const itemContext = useAccordionItemContext(CONTENT_NAME, __scopeAccordion);
    const collapsibleScope = useCollapsibleScope(__scopeAccordion);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      Content,
      {
        role: "region",
        "aria-labelledby": itemContext.triggerId,
        "data-orientation": accordionContext.orientation,
        ...collapsibleScope,
        ...contentProps,
        ref: forwardedRef,
        style: {
          ["--radix-accordion-content-height"]: "var(--radix-collapsible-content-height)",
          ["--radix-accordion-content-width"]: "var(--radix-collapsible-content-width)",
          ...props.style
        }
      }
    );
  }
);
AccordionContent$1.displayName = CONTENT_NAME;
function getState(open) {
  return open ? "open" : "closed";
}
var Root2 = Accordion$1;
var Item = AccordionItem$1;
var Header = AccordionHeader;
var Trigger2 = AccordionTrigger$1;
var Content2 = AccordionContent$1;
const Accordion = Root2;
const AccordionItem = reactExports.forwardRef(({ className, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Item,
  {
    ref,
    className: cn("border-b", className),
    ...props
  }
));
AccordionItem.displayName = "AccordionItem";
const AccordionTrigger = reactExports.forwardRef(({ className, children, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(Header, { className: "flex", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(
  Trigger2,
  {
    ref,
    className: cn(
      "flex flex-1 items-center justify-between py-4 font-medium transition-all hover:underline [&[data-state=open]>svg]:rotate-180",
      className
    ),
    ...props,
    children: [
      children,
      /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronDown, { className: "h-4 w-4 shrink-0 transition-transform duration-200" })
    ]
  }
) }));
AccordionTrigger.displayName = Trigger2.displayName;
const AccordionContent = reactExports.forwardRef(({ className, children, ...props }, ref) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Content2,
  {
    ref,
    className: "overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down",
    ...props,
    children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: cn("pb-4 pt-0", className), children })
  }
));
AccordionContent.displayName = Content2.displayName;
const TutorialPage = () => {
  const navigate = useNavigate();
  const tutorials = [
    {
      title: "Mastering Your Wallet",
      description: "Learn how to manage your assets, view balances, and track detailed transaction history.",
      category: "Features",
      duration: "5 min",
      icon: Wallet,
      path: "/wallet",
      isNew: false,
      completed: false
    },
    {
      title: "Instant Flash Transfers",
      description: "Send crypto instantly to any user or external address using our Flash Transfer system.",
      category: "Features",
      duration: "3 min",
      icon: ArrowRightLeft,
      path: "/flash",
      isNew: true,
      completed: false
    },
    {
      title: "Staking 101: Earn Rewards",
      description: "Maximize your holdings by staking assets in our secure high-yield pools.",
      category: "Finance",
      duration: "7 min",
      icon: Coins,
      path: "/staking",
      isNew: true,
      completed: false
    },
    {
      title: "Lending & Borrowing",
      description: "Supply assets to earn interest or borrow against your crypto collateral.",
      category: "Finance",
      duration: "10 min",
      icon: PiggyBank,
      path: "/lending",
      isNew: false,
      completed: false
    },
    {
      title: "Account Security & 2FA",
      description: "Secure your account with Two-Factor Authentication and profile management.",
      category: "Security",
      duration: "4 min",
      icon: Shield,
      path: "/settings",
      isNew: false,
      completed: true
    },
    {
      title: "Understanding Analytics",
      description: "Track your portfolio performance and market trends with our advanced analytics tools.",
      category: "Features",
      duration: "6 min",
      icon: Zap,
      path: "/analytics",
      isNew: false,
      completed: false
    }
  ];
  const features = [
    {
      title: "Authentication & Security",
      icon: Lock,
      description: "Enterprise-grade security module ensuring data integrity and user protection.",
      specs: [
        "JWT-based stateless authentication",
        "Role-Based Access Control (RBAC) with 'admin' and 'user' scopes",
        "Encrypted password hashing (Argon2id)",
        "Session management with automatic expiry"
      ]
    },
    {
      title: "Wallet & Assets",
      icon: Wallet,
      description: "Core financial engine managing multi-asset portfolios and real-time balances.",
      specs: [
        "Support for top 10 cryptocurrencies (BTC, ETH, etc.)",
        "Real-time fiat value conversion based on live market data",
        "Unified 'user_assets' table for secure balance tracking",
        "Automated asset seeding for new users"
      ]
    },
    {
      title: "Financial Services",
      icon: Coins,
      description: "Advanced DeFi capabilities for passive income and liquidity management.",
      specs: [
        "Staking Pools: Dynamic APY calculation and reward distribution",
        "Lending Protocol: Collateralized borrowing with health factor monitoring",
        "Flash Transfers: Instant, zero-fee internal transfers",
        "Transaction history with detailed audit logs"
      ]
    },
    {
      title: "Admin Management",
      icon: UserCog,
      description: "Comprehensive dashboard for system oversight and configuration.",
      specs: [
        "User management: View, edit, and suspend user accounts",
        "Pricing Plans: Configure subscription tiers and limits",
        "System Logs: Full visibility into error and access logs",
        "Backup & Restore: Database snapshot management"
      ]
    }
  ];
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col space-y-1", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "Tutorials & Documentation" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Comprehensive guides and technical documentation for the FlashCore platform." })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { defaultValue: "guides", className: "w-full", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { className: "bg-muted/50 p-1 rounded-xl mb-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "guides", className: "rounded-lg data-[state=active]:bg-background data-[state=active]:shadow-sm px-6", children: "User Guides" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "documentation", className: "rounded-lg data-[state=active]:bg-background data-[state=active]:shadow-sm px-6", children: "Documentation" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "guides", className: "space-y-8 animate-in fade-in duration-500", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { className: "text-xl font-bold mb-4 flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Play, { className: "w-5 h-5 mr-2 text-flashcore-purple" }),
            " Interactive Tutorials"
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TutorialGrid, { tutorials, navigate })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-card border rounded-xl p-6 shadow-sm", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { className: "text-xl font-bold mb-4 flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Book, { className: "w-5 h-5 mr-2 text-flashcore-green" }),
            " Step-by-Step Instructions"
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Accordion, { type: "single", collapsible: true, className: "w-full", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(AccordionItem, { value: "item-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionTrigger, { children: "How to Deposit Assets" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("ol", { className: "list-decimal list-inside space-y-2 text-muted-foreground", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Navigate to the ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Wallet" }),
                  " page using the sidebar."
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: 'Locate the asset you wish to deposit (e.g., Bitcoin) in the "Your Assets" grid.' }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Click the ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Receive" }),
                  ' button (or "More" → Receive).'
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Copy your unique deposit address or scan the QR code." }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Isolate the transfer from your external wallet to this address. ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Note:" }),
                  " Only send the specific asset to its corresponding address."
                ] })
              ] }) })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(AccordionItem, { value: "item-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionTrigger, { children: "Sending Crypto via Flash Transfer" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("ol", { className: "list-decimal list-inside space-y-2 text-muted-foreground", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Go to the ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Flash Transfer" }),
                  " page."
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Select the asset you want to send from the dropdown menu." }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Enter the recipient's email address or wallet address." }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Input the amount you wish to transfer." }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Review the transaction details and click ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Send Now" }),
                  ". Flash transfers are instant and fee-free!"
                ] })
              ] }) })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(AccordionItem, { value: "item-3", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionTrigger, { children: "Staking Your Assets" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("ol", { className: "list-decimal list-inside space-y-2 text-muted-foreground", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Visit the ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Staking" }),
                  " page."
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Browse the available staking pools and check the APY rates." }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Click ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Stake" }),
                  " on your chosen asset pool."
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Enter the amount you wish to lock up." }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Confirm the transaction. Your rewards will start accumulating immediately and can be claimed anytime." })
              ] }) })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(AccordionItem, { value: "item-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionTrigger, { children: "How to Borrow Funds" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(AccordionContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("ol", { className: "list-decimal list-inside space-y-2 text-muted-foreground", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Navigate to the ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Lending" }),
                  " page."
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Ensure you have supplied collateral (e.g., ETH) to the protocol first." }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
                  "Find the asset you want to borrow (e.g., USDT) and click ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Borrow" }),
                  "."
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: 'Enter the amount. Ensure your "Health Factor" remains above 1.0 to avoid liquidation.' }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Confirm the borrow request. The funds will be added to your wallet instantly." })
              ] }) })
            ] })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsContent, { value: "documentation", className: "space-y-6 animate-in fade-in duration-500", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6", children: features.map((feature, idx) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "border-l-4 border-l-flashcore-purple hover:shadow-md transition-shadow", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center text-xl", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "p-2 rounded-lg bg-primary/10 mr-3", children: /* @__PURE__ */ jsxRuntimeExports.jsx(feature.icon, { className: "w-6 h-6 text-primary" }) }),
              feature.title
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: feature.description })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm mb-2 uppercase tracking-wider text-muted-foreground", children: "Key Specifications" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("ul", { className: "space-y-2", children: feature.specs.map((spec, sIdx) => /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { className: "flex items-start text-sm", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "w-4 h-4 mr-2 text-green-500 mt-0.5" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-foreground/90", children: spec })
            ] }, sIdx)) })
          ] })
        ] }, idx)) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "bg-slate-950 text-white border-slate-800", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardTitle, { className: "flex items-center", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Settings, { className: "w-5 h-5 mr-2" }),
            " Technical Architecture"
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "grid grid-cols-1 md:grid-cols-3 gap-8", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-bold text-flashcore-purple mb-2", children: "Frontend Core" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("ul", { className: "text-sm text-slate-400 space-y-1", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "React 18 (TypeScript)" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Vite Build System" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "TailwindCSS + Shadcn/UI" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "TanStack Query (Data Fetching)" })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-bold text-flashcore-purple mb-2", children: "Backend Services" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("ul", { className: "text-sm text-slate-400 space-y-1", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "PHP 8.2+ (REST API)" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "SQLite 3 (Embedded DB)" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "JWT Authentication" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "File-based Session Storage" })
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-bold text-flashcore-purple mb-2", children: "Platform Support" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("ul", { className: "text-sm text-slate-400 space-y-1", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Web (Responsive PWA)" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Desktop (Electron/Windows)" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Mobile (Android/Capacitor)" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Cross-platform Sync" })
              ] })
            ] })
          ] })
        ] })
      ] })
    ] })
  ] }) });
};
const TutorialGrid = ({ tutorials, navigate }) => /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6", children: tutorials.map((tutorial, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "overflow-hidden flex flex-col group hover:shadow-xl transition-all duration-300 border-none bg-card", children: [
  /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative h-44 bg-gradient-to-br from-flashcore-purple/20 to-flashcore-green/20 overflow-hidden", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity bg-black/20 backdrop-blur-[2px]", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "icon", className: "h-14 w-14 rounded-full bg-white text-flashcore-purple hover:scale-110 transition-transform", onClick: () => navigate(tutorial.path), children: /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRightLeft, { className: "h-6 w-6" }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute inset-0 flex items-center justify-center pointer-events-none", children: /* @__PURE__ */ jsxRuntimeExports.jsx(tutorial.icon, { className: "h-12 w-12 text-flashcore-purple/40 group-hover:scale-125 transition-transform duration-500" }) }),
    tutorial.isNew && /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { className: "absolute top-3 right-3 bg-flashcore-purple text-white border-none text-[10px] font-bold uppercase py-1", children: "New" }),
    tutorial.completed && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute bottom-3 right-3 bg-flashcore-green text-white rounded-full p-1 shadow-lg", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "h-4 w-4" }) })
  ] }),
  /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "pb-2 space-y-1", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center mb-1", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: `border-none text-[10px] font-bold uppercase py-0.5 px-2 rounded-full ${tutorial.category === "Features" ? "bg-blue-100 text-blue-700" : tutorial.category === "Finance" ? "bg-green-100 text-green-700" : "bg-purple-100 text-purple-700"}`, children: tutorial.category }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center text-muted-foreground text-[10px] font-bold uppercase", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "h-3 w-3 mr-1" }),
        tutorial.duration
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg group-hover:text-flashcore-purple transition-colors", children: tutorial.title }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm line-clamp-2", children: tutorial.description })
  ] }),
  /* @__PURE__ */ jsxRuntimeExports.jsx(CardFooter, { className: "pt-0 border-t bg-muted/20 mt-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx(
    Button,
    {
      className: `w-full h-10 font-bold uppercase text-xs tracking-wider transition-all mt-4 ${tutorial.completed ? "variant-outline border-flashcore-green text-flashcore-green" : "bg-gradient-to-r from-flashcore-purple to-flashcore-green"}`,
      onClick: () => navigate(tutorial.path),
      children: tutorial.completed ? "View Again" : "Try Feature"
    }
  ) })
] }, index)) });
export {
  TutorialPage as default
};
//# sourceMappingURL=TutorialPage-BssIxqvZ.js.map
