import { r as reactExports, p as useNavigate, b as useToast, e as useAuthPhp, j as jsxRuntimeExports, q as Link, s as Logo, S as Shield, i as Card, l as CardHeader, m as CardTitle, n as CardDescription, k as CardContent, t as Label, I as Input, v as Mail, w as Lock, B as Button, A as ArrowRight, x as CardFooter } from "./index-dFGJiMHg.js";
import { C as Checkbox } from "./checkbox-BO6xeP5V.js";
import { S as Sparkles } from "./sparkles-BKtKxp2J.js";
import { C as CircleCheck } from "./circle-check-BeOyS43y.js";
import { U as UserPlus } from "./user-plus-C118H9wK.js";
import { U as User } from "./user-d7xPbjjb.js";
import { E as EyeOff } from "./eye-off-IbIu2UAU.js";
import { E as Eye } from "./eye-GLKHuDTw.js";
import { C as CircleX } from "./circle-x-D-XTx57Y.js";
import "./index-MRYMZwGx.js";
const RegisterPage = () => {
  const [firstName, setFirstName] = reactExports.useState("");
  const [lastName, setLastName] = reactExports.useState("");
  const [email, setEmail] = reactExports.useState("");
  const [password, setPassword] = reactExports.useState("");
  const [confirmPassword, setConfirmPassword] = reactExports.useState("");
  const [showPassword, setShowPassword] = reactExports.useState(false);
  const [showConfirmPassword, setShowConfirmPassword] = reactExports.useState(false);
  const [agreed, setAgreed] = reactExports.useState(false);
  const [loading, setLoading] = reactExports.useState(false);
  const navigate = useNavigate();
  const { toast } = useToast();
  const { register } = useAuthPhp();
  const passwordStrength = reactExports.useMemo(() => {
    if (!password) return { score: 0, label: "", color: "" };
    let score = 0;
    if (password.length >= 8) score++;
    if (password.length >= 12) score++;
    if (/[a-z]/.test(password) && /[A-Z]/.test(password)) score++;
    if (/\d/.test(password)) score++;
    if (/[^a-zA-Z0-9]/.test(password)) score++;
    if (score <= 1) return { score, label: "Weak", color: "bg-red-500" };
    if (score <= 3) return { score, label: "Fair", color: "bg-yellow-500" };
    if (score <= 4) return { score, label: "Good", color: "bg-blue-500" };
    return { score, label: "Strong", color: "bg-green-500" };
  }, [password]);
  const passwordsMatch = password && confirmPassword && password === confirmPassword;
  const handleSubmit = async (e) => {
    e.preventDefault();
    if (!agreed) {
      toast({
        title: "Terms not agreed",
        description: "You must agree to the Terms of Service and Privacy Policy.",
        variant: "destructive"
      });
      return;
    }
    if (password !== confirmPassword) {
      toast({
        title: "Password Mismatch",
        description: "Passwords do not match.",
        variant: "destructive"
      });
      return;
    }
    setLoading(true);
    const response = await register(email, password, firstName, lastName);
    setLoading(false);
    if (!response.success) {
      toast({
        title: "Registration Error",
        description: response.error,
        variant: "destructive"
      });
    } else {
      if (response.debug_verification_link) {
        console.log("DEBUG: Verification Link:", response.debug_verification_link);
      }
      toast({
        title: "Registration Successful",
        description: "Please check your email to verify your account. Your account also requires admin approval.",
        duration: 6e3
      });
      navigate("/login");
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen flex overflow-hidden bg-background", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "hidden lg:flex lg:w-1/2 relative bg-gradient-to-br from-flashcore-green via-flashcore-purple to-flashcore-orange p-12 flex-col justify-between overflow-hidden", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "absolute inset-0 opacity-10", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-0 left-0 w-96 h-96 bg-white rounded-full blur-3xl animate-pulse-glow", style: { animationDelay: "0s" } }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute bottom-0 right-0 w-96 h-96 bg-white rounded-full blur-3xl animate-pulse-glow", style: { animationDelay: "1s" } }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-96 h-96 bg-white rounded-full blur-3xl animate-pulse-glow", style: { animationDelay: "2s" } })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative z-10", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center gap-3 group", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-16 h-16 drop-shadow-2xl transition-transform group-hover:scale-110 duration-300" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-5xl font-bold text-white drop-shadow-lg", children: "FLASHCORE" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-white/90 text-lg mt-6 max-w-md leading-relaxed", children: "Join thousands of businesses managing their licenses with confidence and ease." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative z-10 space-y-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-white text-2xl font-bold mb-6", children: "Why Choose FlashCore?" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "space-y-3", children: [
          { icon: Shield, text: "Enterprise-grade security" },
          { icon: Sparkles, text: "Intuitive dashboard" },
          { icon: CircleCheck, text: "24/7 customer support" },
          { icon: UserPlus, text: "Easy team collaboration" }
        ].map((benefit, idx) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3 bg-white/10 backdrop-blur-md border border-white/20 rounded-xl p-4 hover:bg-white/15 transition-all", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(benefit.icon, { className: "w-6 h-6 text-white flex-shrink-0" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-white/90 font-medium", children: benefit.text })
        ] }, idx)) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute bottom-0 left-0 w-full h-32 bg-gradient-to-t from-black/20 to-transparent pointer-events-none" })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex-1 flex items-center justify-center p-4 lg:p-12 relative overflow-y-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-6 left-6 lg:hidden", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Link, { to: "/", className: "flex items-center gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Logo, { className: "w-10 h-10 drop-shadow-lg" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-2xl font-bold bg-gradient-to-r from-flashcore-green via-flashcore-purple to-flashcore-orange bg-clip-text text-transparent", children: "FLASHCORE" })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "w-full max-w-md border-0 shadow-2xl bg-card/50 backdrop-blur-sm my-20 lg:my-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "space-y-3 pb-6", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-gradient-to-br from-flashcore-green to-flashcore-purple p-4 rounded-2xl shadow-lg", children: /* @__PURE__ */ jsxRuntimeExports.jsx(UserPlus, { className: "w-8 h-8 text-white" }) }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-3xl font-bold text-center", children: "Create Account" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-center text-sm", children: "Enter your information to get started" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: handleSubmit, className: "space-y-5", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "firstName", className: "text-sm font-medium", children: "First Name" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground group-focus-within:text-flashcore-green transition-colors" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Input,
                  {
                    id: "firstName",
                    placeholder: "John",
                    value: firstName,
                    onChange: (e) => setFirstName(e.target.value),
                    className: "pl-10 h-11 bg-background/50 border-border/50 focus:border-flashcore-green focus:ring-flashcore-green/20 transition-all",
                    required: true
                  }
                )
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "lastName", className: "text-sm font-medium", children: "Last Name" }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground group-focus-within:text-flashcore-green transition-colors" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  Input,
                  {
                    id: "lastName",
                    placeholder: "Doe",
                    value: lastName,
                    onChange: (e) => setLastName(e.target.value),
                    className: "pl-10 h-11 bg-background/50 border-border/50 focus:border-flashcore-green focus:ring-flashcore-green/20 transition-all",
                    required: true
                  }
                )
              ] })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "email", className: "text-sm font-medium", children: "Email Address" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground group-focus-within:text-flashcore-green transition-colors" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  id: "email",
                  type: "email",
                  placeholder: "name@example.com",
                  value: email,
                  onChange: (e) => setEmail(e.target.value),
                  className: "pl-10 h-12 bg-background/50 border-border/50 focus:border-flashcore-green focus:ring-flashcore-green/20 transition-all",
                  required: true
                }
              )
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "password", className: "text-sm font-medium", children: "Password" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Lock, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground group-focus-within:text-flashcore-green transition-colors" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  id: "password",
                  type: showPassword ? "text" : "password",
                  placeholder: "••••••••",
                  value: password,
                  onChange: (e) => setPassword(e.target.value),
                  className: "pl-10 pr-12 h-12 bg-background/50 border-border/50 focus:border-flashcore-green focus:ring-flashcore-green/20 transition-all",
                  required: true
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "button",
                {
                  type: "button",
                  tabIndex: -1,
                  className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-flashcore-green transition-colors p-1",
                  onClick: () => setShowPassword((v) => !v),
                  "aria-label": showPassword ? "Hide password" : "Show password",
                  children: showPassword ? /* @__PURE__ */ jsxRuntimeExports.jsx(EyeOff, { className: "w-5 h-5" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Eye, { className: "w-5 h-5" })
                }
              )
            ] }),
            password && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2 mt-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-xs", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-muted-foreground", children: "Password strength:" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: `font-medium ${passwordStrength.label === "Weak" ? "text-red-500" : passwordStrength.label === "Fair" ? "text-yellow-500" : passwordStrength.label === "Good" ? "text-blue-500" : "text-green-500"}`, children: passwordStrength.label })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex gap-1", children: [1, 2, 3, 4, 5].map((level) => /* @__PURE__ */ jsxRuntimeExports.jsx(
                "div",
                {
                  className: `h-1.5 flex-1 rounded-full transition-all ${level <= passwordStrength.score ? passwordStrength.color : "bg-muted"}`
                },
                level
              )) })
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "confirmPassword", className: "text-sm font-medium", children: "Confirm Password" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative group", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Lock, { className: "absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground group-focus-within:text-flashcore-green transition-colors" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  id: "confirmPassword",
                  type: showConfirmPassword ? "text" : "password",
                  placeholder: "••••••••",
                  value: confirmPassword,
                  onChange: (e) => setConfirmPassword(e.target.value),
                  className: "pl-10 pr-12 h-12 bg-background/50 border-border/50 focus:border-flashcore-green focus:ring-flashcore-green/20 transition-all",
                  required: true
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "button",
                {
                  type: "button",
                  tabIndex: -1,
                  className: "absolute right-3 top-1/2 -translate-y-1/2 text-muted-foreground hover:text-flashcore-green transition-colors p-1",
                  onClick: () => setShowConfirmPassword((v) => !v),
                  "aria-label": showConfirmPassword ? "Hide password" : "Show password",
                  children: showConfirmPassword ? /* @__PURE__ */ jsxRuntimeExports.jsx(EyeOff, { className: "w-5 h-5" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Eye, { className: "w-5 h-5" })
                }
              )
            ] }),
            confirmPassword && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center gap-2 text-xs mt-2", children: passwordsMatch ? /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheck, { className: "w-4 h-4 text-green-500" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-green-500 font-medium", children: "Passwords match" })
            ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(CircleX, { className: "w-4 h-4 text-red-500" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-red-500 font-medium", children: "Passwords don't match" })
            ] }) })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start space-x-3 py-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Checkbox,
              {
                id: "terms",
                checked: agreed,
                onCheckedChange: (checked) => setAgreed(checked),
                className: "mt-0.5"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(
              "label",
              {
                htmlFor: "terms",
                className: "text-sm leading-relaxed cursor-pointer select-none",
                children: [
                  "I agree to the",
                  " ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/terms", className: "text-flashcore-green font-medium hover:text-flashcore-purple transition-colors hover:underline", children: "Terms of Service" }),
                  " ",
                  "and",
                  " ",
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/privacy", className: "text-flashcore-green font-medium hover:text-flashcore-purple transition-colors hover:underline", children: "Privacy Policy" })
                ]
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Button,
            {
              className: "w-full h-12 bg-gradient-to-r from-flashcore-green via-flashcore-purple to-flashcore-orange hover:opacity-90 transition-all duration-300 hover:scale-[1.02] active:scale-95 shadow-lg text-white font-semibold text-base",
              type: "submit",
              disabled: loading,
              children: loading ? /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-5 h-5 border-2 border-white/30 border-t-white rounded-full animate-spin" }),
                "Creating Account..."
              ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center gap-2", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(UserPlus, { className: "w-5 h-5" }),
                "Create Account",
                /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-5 h-5" })
              ] })
            }
          )
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardFooter, { className: "flex flex-col border-t border-border/50 pt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-sm text-center text-muted-foreground", children: [
          "Already have an account?",
          " ",
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            Link,
            {
              to: "/login",
              className: "text-flashcore-purple font-semibold hover:text-flashcore-green transition-colors hover:underline",
              children: "Sign in"
            }
          )
        ] }) })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("style", { children: `
        @keyframes pulse-glow {
          0%, 100% { 
            opacity: 0.1;
            transform: scale(1);
          }
          50% { 
            opacity: 0.2;
            transform: scale(1.1);
          }
        }
      ` })
  ] });
};
export {
  RegisterPage as default
};
//# sourceMappingURL=RegisterPage-4MnTqlIN.js.map
