import { r as reactExports, j as jsxRuntimeExports, i as Card, l as CardHeader, m as CardTitle, n as CardDescription, k as CardContent, d as Check, ah as X, q as Link, B as Button, A as ArrowRight, a as apiService } from "./index-GlGoHQS3.js";
import { B as Badge } from "./badge-CPhJg0YM.js";
import { Z as Zap } from "./zap-DzaCSTJR.js";
const PricingPage = () => {
  const [plans, setPlans] = reactExports.useState([]);
  const [loading, setLoading] = reactExports.useState(true);
  reactExports.useEffect(() => {
    const fetchPlans = async () => {
      try {
        const response = await apiService.getPricingPlans();
        if (response.data) {
          setPlans(response.data);
        }
      } catch (error) {
        console.error("Failed to fetch pricing plans:", error);
      } finally {
        setLoading(false);
      }
    };
    fetchPlans();
  }, []);
  if (loading) {
    return /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex justify-center items-center min-h-screen", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "animate-spin rounded-full h-12 w-12 border-t-2 border-b-2 border-primary" }) });
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Zap, { className: "w-3 h-3 mr-1" }),
        "Simple Pricing"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "Choose Your Plan" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Start free and scale as you grow. All plans include our core features with no hidden fees." })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-8 max-w-6xl mx-auto", children: plans.map((plan, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
      Card,
      {
        className: `relative overflow-hidden transition-all duration-300 hover:shadow-2xl hover:-translate-y-1 ${plan.popular ? "border-2 border-flashcore-purple bg-gradient-to-b from-background to-flashcore-purple/5" : "border border-border/50 bg-card/50 backdrop-blur-sm"}`,
        children: [
          plan.popular && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "absolute top-0 right-0", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "bg-gradient-to-l from-flashcore-purple to-flashcore-pink text-white text-xs font-bold px-3 py-1 rounded-bl-lg shadow-md", children: "MOST POPULAR" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { className: "text-center pb-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-2xl font-bold", children: plan.name }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-baseline justify-center mt-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: `text-4xl font-extrabold bg-clip-text text-transparent bg-gradient-to-r ${plan.color}`, children: plan.price }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "ml-2 text-muted-foreground", children: "/month" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "mt-2 text-base", children: plan.description })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-6", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-semibold text-foreground/80 uppercase tracking-wider text-left", children: "What's included:" }),
              plan.features.map((feature, featureIndex) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-start gap-3 text-left", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "mt-1 flex-shrink-0", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `p-0.5 rounded-full bg-gradient-to-r ${plan.color} bg-opacity-10`, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-3 h-3 text-white" }) }) }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-muted-foreground leading-tight", children: feature })
              ] }, featureIndex)),
              plan.notIncluded && plan.notIncluded.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "my-4 border-t border-border/50" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "text-sm font-semibold text-foreground/80 uppercase tracking-wider text-left", children: "Not included:" }),
                plan.notIncluded.map((feature, featureIndex) => /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3 opacity-60 text-left", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(X, { className: "w-4 h-4 text-muted-foreground flex-shrink-0" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm text-muted-foreground", children: feature })
                ] }, featureIndex))
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: `/register?plan=${plan.name.toLowerCase()}`, className: "block", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(
              Button,
              {
                className: `w-full font-semibold shadow-lg transition-all duration-300 ${plan.popular ? "bg-gradient-to-r from-flashcore-purple to-flashcore-pink hover:opacity-90 text-white" : "hover:bg-primary/90"}`,
                variant: plan.popular ? "default" : "outline",
                children: [
                  plan.buttonText,
                  plan.popular && /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
                ]
              }
            ) })
          ] })
        ]
      },
      index
    )) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Feature Comparison" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "Compare all features across our plans to find the perfect fit for your business." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("table", { className: "w-full border-collapse", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("thead", { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b border-border", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "text-left p-4 font-semibold", children: "Feature" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "text-center p-4 font-semibold", children: "Basic" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "text-center p-4 font-semibold", children: "Pro" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "text-center p-4 font-semibold", children: "Enterprise" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("tbody", { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Monthly Emails" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "1,000" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "10,000" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Unlimited" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Email Templates" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Basic" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Advanced" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Custom" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Analytics" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Basic" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Advanced" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Advanced" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Support" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "24/7" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Priority" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: "Dedicated" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "Custom Branding" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { className: "w-4 h-4 text-red-500 mx-auto" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mx-auto" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mx-auto" }) })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "API Access" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { className: "w-4 h-4 text-red-500 mx-auto" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { className: "w-4 h-4 text-red-500 mx-auto" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mx-auto" }) })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 font-medium", children: "A/B Testing" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { className: "w-4 h-4 text-red-500 mx-auto" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mx-auto" }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "p-4 text-center", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500 mx-auto" }) })
          ] })
        ] })
      ] }) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12 md:mb-16", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Frequently Asked Questions" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground max-w-2xl mx-auto", children: "Get answers to common questions about our pricing and plans." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-8 max-w-4xl mx-auto", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Can I change plans anytime?" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Yes, you can upgrade or downgrade your plan at any time. Changes take effect immediately." }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Is there a free trial?" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Yes, all plans come with a 14-day free trial. No credit card required to start." }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "What payment methods do you accept?" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "We accept all major credit cards, PayPal, and bank transfers for Enterprise plans." }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Do you offer refunds?" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "We offer a 30-day money-back guarantee. If you're not satisfied, we'll refund your payment." }) })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-2xl p-6 md:p-8 lg:p-12 text-center text-white", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Ready to Get Started?" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl mb-6 md:mb-8 opacity-90", children: "Join thousands of businesses using FlashCore to automate their communications." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/register", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { size: "lg", variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Start Free Trial",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/contact", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { size: "lg", variant: "outline", className: "border-white text-white hover:bg-white hover:text-flashcore-purple", children: "Contact Sales" }) })
      ] })
    ] }) })
  ] });
};
export {
  PricingPage as default
};
//# sourceMappingURL=PricingPage-C2HIACl8.js.map
