import { c as createLucideIcon, r as reactExports, j as jsxRuntimeExports, I as Input, B as Button, i as Card, l as CardHeader, m as CardTitle, n as CardDescription, k as CardContent, A as ArrowRight, v as Mail, a6 as Globe, T as TrendingUp } from "./index-dFGJiMHg.js";
import { B as Badge } from "./badge-w0XFTSDO.js";
import { S as Search } from "./search-B1vmXDJS.js";
import { S as Star } from "./star-B_Vhg7wU.js";
import { C as Calendar } from "./calendar-D_NP4res.js";
import { E as ExternalLink } from "./external-link-8SiAMmvs.js";
import { D as Download } from "./download-Crm3eFeY.js";
import { P as Phone } from "./phone-Fn3-ZINr.js";
import { M as MapPin } from "./map-pin-KY1TXmj6.js";
import { F as FileText } from "./file-text-DZdhJPDK.js";
import { B as Building } from "./building-B3F7FJiI.js";
import { A as Award } from "./award-CMmuLhvk.js";
import { Z as Zap } from "./zap-BzUDRoi9.js";
import { U as Users } from "./users-D6qkMSDa.js";
import { V as Video } from "./video-fHxt0CwQ.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Image = createLucideIcon("Image", [
  ["rect", { width: "18", height: "18", x: "3", y: "3", rx: "2", ry: "2", key: "1m3agn" }],
  ["circle", { cx: "9", cy: "9", r: "2", key: "af1f0g" }],
  ["path", { d: "m21 15-3.086-3.086a2 2 0 0 0-2.828 0L6 21", key: "1xmnt7" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const Newspaper = createLucideIcon("Newspaper", [
  [
    "path",
    {
      d: "M4 22h16a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v16a2 2 0 0 1-2 2Zm0 0a2 2 0 0 1-2-2v-9c0-1.1.9-2 2-2h2",
      key: "7pis2x"
    }
  ],
  ["path", { d: "M18 14h-8", key: "sponae" }],
  ["path", { d: "M15 18h-5", key: "95g1m2" }],
  ["path", { d: "M10 6h8v4h-8V6Z", key: "smlsk5" }]
]);
const PressPage = () => {
  const [searchQuery, setSearchQuery] = reactExports.useState("");
  const [selectedCategory, setSelectedCategory] = reactExports.useState("all");
  const categories = [
    { id: "all", name: "All News", icon: Newspaper },
    { id: "press-releases", name: "Press Releases", icon: FileText },
    { id: "media-coverage", name: "Media Coverage", icon: Globe },
    { id: "company-news", name: "Company News", icon: Building },
    { id: "awards", name: "Awards", icon: Award },
    { id: "product-updates", name: "Product Updates", icon: Zap }
  ];
  const pressReleases = [
    {
      id: 1,
      title: "FlashCore Raises $25M Series B Funding to Accelerate Email Marketing Innovation",
      category: "press-releases",
      date: "March 15, 2024",
      summary: "FlashCore announces $25M Series B funding round led by TechVentures Capital to expand product development and global market presence.",
      content: "FlashCore, the leading email marketing automation platform, today announced it has raised $25 million in Series B funding led by TechVentures Capital, with participation from existing investors GrowthFund and Innovation Partners. This funding will accelerate product development, expand the company's global presence, and strengthen its position as the premier email marketing solution for businesses of all sizes.",
      tags: ["Funding", "Series B", "Growth", "Investment"],
      featured: true,
      readTime: "3 min read"
    },
    {
      id: 2,
      title: "FlashCore Launches Advanced AI-Powered Email Personalization Engine",
      category: "product-updates",
      date: "March 8, 2024",
      summary: "New AI engine delivers personalized email content in real-time, increasing engagement rates by up to 300%.",
      content: "FlashCore today announced the launch of its revolutionary AI-powered email personalization engine, designed to transform how businesses connect with their customers. The new technology uses advanced machine learning algorithms to analyze customer behavior and deliver highly personalized email content in real-time, resulting in engagement rate increases of up to 300%.",
      tags: ["AI", "Personalization", "Product Launch", "Machine Learning"],
      featured: true,
      readTime: "4 min read"
    },
    {
      id: 3,
      title: "FlashCore Named 'Best Email Marketing Platform' at 2024 SaaS Awards",
      category: "awards",
      date: "February 28, 2024",
      summary: "FlashCore recognized for excellence in email marketing innovation and customer success.",
      content: "FlashCore has been named 'Best Email Marketing Platform' at the prestigious 2024 SaaS Awards, recognizing the company's innovative approach to email marketing automation and exceptional customer success rates. The award highlights FlashCore's commitment to delivering cutting-edge technology that empowers businesses to build meaningful customer relationships.",
      tags: ["Award", "Recognition", "SaaS", "Excellence"],
      featured: false,
      readTime: "2 min read"
    },
    {
      id: 4,
      title: "FlashCore Expands European Operations with New London Office",
      category: "company-news",
      date: "February 15, 2024",
      summary: "Strategic expansion into European market with dedicated team and localized support.",
      content: "FlashCore today announced the opening of its new European headquarters in London, marking a significant milestone in the company's global expansion strategy. The new office will serve as the hub for European operations, providing localized support and expertise to customers across the region.",
      tags: ["Expansion", "Europe", "London", "Global Growth"],
      featured: false,
      readTime: "3 min read"
    },
    {
      id: 5,
      title: "FlashCore Partners with Leading E-commerce Platforms for Seamless Integration",
      category: "company-news",
      date: "February 1, 2024",
      summary: "Strategic partnerships with Shopify, WooCommerce, and Magento enhance customer experience.",
      content: "FlashCore has announced strategic partnerships with leading e-commerce platforms including Shopify, WooCommerce, and Magento. These partnerships will provide seamless integration capabilities, enabling merchants to leverage FlashCore's advanced email marketing features directly within their existing e-commerce workflows.",
      tags: ["Partnership", "E-commerce", "Integration", "Shopify"],
      featured: false,
      readTime: "3 min read"
    },
    {
      id: 6,
      title: "FlashCore Introduces Enterprise-Grade Security and Compliance Features",
      category: "product-updates",
      date: "January 20, 2024",
      summary: "New security features meet enterprise requirements for data protection and compliance.",
      content: "FlashCore has launched comprehensive enterprise-grade security and compliance features, including advanced data encryption, GDPR compliance tools, and SOC 2 Type II certification. These enhancements ensure that enterprise customers can confidently use FlashCore while meeting their strict security and regulatory requirements.",
      tags: ["Security", "Compliance", "Enterprise", "GDPR"],
      featured: false,
      readTime: "4 min read"
    }
  ];
  const mediaCoverage = [
    {
      id: 1,
      title: "How FlashCore is Revolutionizing Email Marketing with AI",
      source: "TechCrunch",
      date: "March 10, 2024",
      author: "Sarah Johnson",
      summary: "An in-depth look at FlashCore's AI-powered approach to email marketing and its impact on the industry.",
      url: "https://techcrunch.com/flashcore-ai-email-marketing",
      logo: "techcrunch",
      featured: true
    },
    {
      id: 2,
      title: "FlashCore's $25M Funding Round Signals Growing Demand for Email Automation",
      source: "VentureBeat",
      date: "March 16, 2024",
      author: "Michael Chen",
      summary: "Analysis of FlashCore's recent funding round and the broader email marketing automation market.",
      url: "https://venturebeat.com/flashcore-funding-email-automation",
      logo: "venturebeat",
      featured: true
    },
    {
      id: 3,
      title: "The Future of Email Marketing: Interview with FlashCore CEO",
      source: "Forbes",
      date: "February 25, 2024",
      author: "Emily Rodriguez",
      summary: "Exclusive interview with FlashCore's CEO discussing the future of email marketing and company vision.",
      url: "https://forbes.com/flashcore-ceo-interview",
      logo: "forbes",
      featured: false
    },
    {
      id: 4,
      title: "FlashCore Named Top Email Marketing Platform for Small Businesses",
      source: "Business Insider",
      date: "February 10, 2024",
      author: "David Thompson",
      summary: "Review and ranking of FlashCore as the leading email marketing solution for small business needs.",
      url: "https://businessinsider.com/flashcore-small-business",
      logo: "business-insider",
      featured: false
    }
  ];
  const companyStats = [
    {
      icon: Users,
      number: "50,000+",
      label: "Active Customers",
      description: "Businesses worldwide trust FlashCore"
    },
    {
      icon: TrendingUp,
      number: "2.5B+",
      label: "Emails Sent",
      description: "Through our platform monthly"
    },
    {
      icon: Star,
      number: "98%",
      label: "Customer Satisfaction",
      description: "Based on verified reviews"
    },
    {
      icon: Globe,
      number: "150+",
      label: "Countries Served",
      description: "Global reach and support"
    }
  ];
  const mediaResources = [
    {
      title: "Company Logo",
      description: "High-resolution FlashCore logos in various formats",
      icon: Image,
      downloads: ["PNG", "SVG", "EPS"]
    },
    {
      title: "Product Screenshots",
      description: "Latest screenshots of FlashCore platform features",
      icon: Image,
      downloads: ["PNG", "JPG"]
    },
    {
      title: "Brand Guidelines",
      description: "Complete brand guidelines and style guide",
      icon: FileText,
      downloads: ["PDF"]
    },
    {
      title: "Company Fact Sheet",
      description: "Key facts and figures about FlashCore",
      icon: FileText,
      downloads: ["PDF"]
    },
    {
      title: "Executive Bios",
      description: "Biographies and photos of FlashCore leadership",
      icon: Users,
      downloads: ["PDF", "JPG"]
    },
    {
      title: "Product Videos",
      description: "Demo videos and product overviews",
      icon: Video,
      downloads: ["MP4", "WebM"]
    }
  ];
  const filteredPress = pressReleases.filter((item) => {
    const matchesSearch = item.title.toLowerCase().includes(searchQuery.toLowerCase()) || item.summary.toLowerCase().includes(searchQuery.toLowerCase()) || item.tags.some((tag) => tag.toLowerCase().includes(searchQuery.toLowerCase()));
    const matchesCategory = selectedCategory === "all" || item.category === selectedCategory;
    return matchesSearch && matchesCategory;
  });
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "min-h-screen bg-background", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Newspaper, { className: "w-3 h-3 mr-1" }),
        "Press & Media"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "FlashCore in the News" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Stay updated with the latest news, press releases, and media coverage about FlashCore's mission to revolutionize email marketing." }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-2xl mx-auto mb-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-3 top-1/2 transform -translate-y-1/2 text-muted-foreground w-5 h-5" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            type: "text",
            placeholder: "Search press releases, news, and media coverage...",
            value: searchQuery,
            onChange: (e) => setSearchQuery(e.target.value),
            className: "pl-10 pr-4 py-3 text-lg"
          }
        )
      ] }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-6xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-2 justify-center", children: categories.map((category) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
      Button,
      {
        variant: selectedCategory === category.id ? "default" : "outline",
        size: "sm",
        onClick: () => setSelectedCategory(category.id),
        className: "flex items-center space-x-2",
        children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(category.icon, { className: "w-4 h-4" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: category.name })
        ]
      },
      category.id
    )) }) }) }),
    filteredPress.filter((item) => item.featured).length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Featured News" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Latest major announcements and updates from FlashCore" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-8", children: filteredPress.filter((item) => item.featured).map((item) => {
        var _a;
        return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group border-2 border-flashcore-purple/20", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between mb-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "destructive", className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { className: "w-3 h-3 mr-1" }),
                "Featured"
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: "text-xs", children: (_a = categories.find((c) => c.id === item.category)) == null ? void 0 : _a.name })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-xl group-hover:text-flashcore-purple transition-colors", children: item.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: item.summary })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-sm", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-4 h-4 mr-1" }),
                item.date
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-muted-foreground", children: item.readTime })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-1", children: item.tags.map((tag, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: tag }, index)) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "w-full bg-flashcore-purple hover:bg-flashcore-purple/90", children: [
              "Read Full Release",
              /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
            ] })
          ] }) })
        ] }, item.id);
      }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Press Releases" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Official announcements and updates from FlashCore" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-6 md:gap-8", children: filteredPress.filter((item) => !item.featured).map((item) => {
        var _a;
        return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between mb-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: "text-xs", children: (_a = categories.find((c) => c.id === item.category)) == null ? void 0 : _a.name }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xs text-muted-foreground", children: item.readTime })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg group-hover:text-flashcore-purple transition-colors", children: item.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: item.summary })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-between text-sm", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-4 h-4 mr-1" }),
              item.date
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-1", children: item.tags.slice(0, 3).map((tag, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: tag }, index)) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", className: "w-full group-hover:bg-flashcore-purple group-hover:text-white transition-colors", children: [
              "Read More",
              /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
            ] })
          ] }) })
        ] }, item.id);
      }) }),
      filteredPress.length === 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center py-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Newspaper, { className: "w-16 h-16 text-muted-foreground mx-auto mb-4" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-semibold mb-2", children: "No press releases found" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-4", children: "Try adjusting your search criteria or check back later for updates." }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Button,
          {
            variant: "outline",
            onClick: () => {
              setSearchQuery("");
              setSelectedCategory("all");
            },
            children: "Clear Filters"
          }
        )
      ] })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Media Coverage" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Recent coverage of FlashCore in leading publications" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-8", children: mediaCoverage.map((coverage) => /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between mb-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: coverage.source }),
            coverage.featured && /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "destructive", className: "text-xs", children: "Featured" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg group-hover:text-flashcore-purple transition-colors", children: coverage.title }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: coverage.summary })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-sm", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-4 h-4 mr-1" }),
              coverage.date
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-muted-foreground", children: [
              "by ",
              coverage.author
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", className: "w-full group-hover:bg-flashcore-purple group-hover:text-white transition-colors", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(ExternalLink, { className: "w-4 h-4 mr-2" }),
            "Read Article"
          ] })
        ] }) })
      ] }, coverage.id)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "FlashCore by the Numbers" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Key metrics and achievements that define our success" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8", children: companyStats.map((stat, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "text-center hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(stat.icon, { className: "w-6 h-6 text-white" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-2xl font-bold mb-2", children: stat.number }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm font-semibold mb-2", children: stat.label }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: stat.description })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Media Resources" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Download logos, screenshots, and other media assets" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: mediaResources.map((resource, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(resource.icon, { className: "w-6 h-6 text-white" }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: resource.title }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: resource.description }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-2 mb-4", children: resource.downloads.map((format, idx) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: format }, idx)) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", className: "w-full", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "w-4 h-4 mr-2" }),
          "Download"
        ] })
      ] }) }, index)) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Media Inquiries" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-8", children: "For press inquiries, interview requests, or media partnerships, please contact our communications team." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6 mb-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-center space-x-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-5 h-5 text-flashcore-purple" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-left", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "font-semibold", children: "Email" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "press@flashcore.com" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-center space-x-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Phone, { className: "w-5 h-5 text-flashcore-purple" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-left", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "font-semibold", children: "Phone" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "+1 (555) 123-4567" })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-center space-x-3", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(MapPin, { className: "w-5 h-5 text-flashcore-purple" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-left", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "font-semibold", children: "Office" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground", children: "San Francisco, CA" })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 justify-center", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { className: "bg-flashcore-purple hover:bg-flashcore-purple/90", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Mail, { className: "w-4 h-4 mr-2" }),
          "Contact Press Team"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "w-4 h-4 mr-2" }),
          "Download Press Kit"
        ] })
      ] })
    ] }) })
  ] });
};
export {
  PressPage as default
};
//# sourceMappingURL=PressPage-DNfYqDRE.js.map
