import { j as jsxRuntimeExports, I as Input, B as Button, b2 as useSearchParams, p as useNavigate, b as useToast, r as reactExports, L as Layout, h as CircleAlert, i as Card, l as CardHeader, m as CardTitle, n as CardDescription, k as CardContent, d as Check, S as Shield, a as apiService } from "./index-GlGoHQS3.js";
import { T as Tabs, a as TabsList, b as TabsTrigger, c as TabsContent } from "./tabs-jrC1WfMe.js";
import { o as objectType, s as stringType, g as anyType, u as useForm, F as Form, a as FormField, c as FormItem, d as FormLabel, e as FormControl, f as FormMessage, t } from "./form-lyvyV3tp.js";
import { C as Copy } from "./copy-C_jo3Fif.js";
import { U as Upload } from "./upload-BhsjjPdn.js";
import { B as Badge } from "./badge-CPhJg0YM.js";
const creditCardSchema = objectType({
  cardNumber: stringType(),
  expiryDate: stringType(),
  cvv: stringType(),
  cardholderName: stringType(),
  paymentProof: anyType().optional()
});
const CreditCardForm = ({ onSubmit, isLoading }) => {
  const adminCardDetails = {
    cardNumber: "4532 1234 5678 9012",
    expiryDate: "12/28",
    cvv: "123",
    cardholderName: "FlashCore Admin"
  };
  const form = useForm({
    resolver: t(creditCardSchema),
    defaultValues: {
      cardNumber: adminCardDetails.cardNumber,
      expiryDate: adminCardDetails.expiryDate,
      cvv: adminCardDetails.cvv,
      cardholderName: adminCardDetails.cardholderName
    }
  });
  const copyToClipboard = async (text) => {
    try {
      await navigator.clipboard.writeText(text);
      console.log("Copied to clipboard:", text);
    } catch (err) {
      console.error("Failed to copy: ", err);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Form, { ...form, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: form.handleSubmit(onSubmit), className: "space-y-4", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "cardNumber",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Card Number" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: () => copyToClipboard(field.value),
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-2 gap-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        FormField,
        {
          control: form.control,
          name: "expiryDate",
          render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Expiry Date" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  ...field,
                  readOnly: true,
                  className: "font-mono text-sm bg-secondary/20"
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Button,
                {
                  type: "button",
                  variant: "outline",
                  size: "icon",
                  onClick: () => copyToClipboard(field.value),
                  className: "shrink-0",
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
                }
              )
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
          ] })
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        FormField,
        {
          control: form.control,
          name: "cvv",
          render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "CVV" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Input,
                {
                  ...field,
                  readOnly: true,
                  className: "font-mono text-sm bg-secondary/20"
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Button,
                {
                  type: "button",
                  variant: "outline",
                  size: "icon",
                  onClick: () => copyToClipboard(field.value),
                  className: "shrink-0",
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
                }
              )
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
          ] })
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "cardholderName",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Cardholder Name" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: () => copyToClipboard(field.value),
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "paymentProof",
        render: ({ field: { onChange, value, ...field } }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Upload Payment Proof" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                type: "file",
                accept: "image/*,.pdf",
                onChange: (e) => {
                  var _a;
                  return onChange((_a = e.target.files) == null ? void 0 : _a[0]);
                },
                className: "flex h-10 w-full rounded-md border border-input bg-background px-3 py-2 text-sm ring-offset-background file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:cursor-not-allowed disabled:opacity-50"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Upload, { size: 16, className: "text-muted-foreground shrink-0" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Upload screenshot or receipt of your payment (JPG, PNG, PDF)" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-secondary/20 p-3 rounded-lg", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm mb-2", children: "Payment Instructions:" }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-xs text-muted-foreground", children: [
        "1. Complete your card payment through the secure payment gateway",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "2. Save the payment confirmation or receipt",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "3. Upload proof of payment above",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "4. Payment will be processed immediately upon verification"
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { type: "submit", className: "w-full", disabled: isLoading, children: isLoading ? "Submitting Receipt..." : "Send Payment Receipt/Proof" })
  ] }) });
};
const cryptoSchema = objectType({
  walletAddress: stringType().min(26, "Please enter a valid wallet address"),
  cryptoCurrency: stringType().min(1, "Please select a cryptocurrency"),
  paymentProof: anyType().optional()
});
const CryptoForm = ({ onSubmit, isLoading }) => {
  const adminWalletAddresses = {
    bitcoin: "1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa",
    ethereum: "0x742d35Cc6634C0532925a3b8D3Ac92Cf2c3A5b5B",
    litecoin: "LdP8Qox1VAhCzLJNqrr74YovaWYyNBUWvL",
    dogecoin: "DH5yaieqoZN36fDVciNyRueRGvGLR3mr7L"
  };
  const form = useForm({
    resolver: t(cryptoSchema),
    defaultValues: {
      walletAddress: adminWalletAddresses.bitcoin,
      cryptoCurrency: "bitcoin"
    }
  });
  const cryptoOptions = [
    { value: "bitcoin", label: "Bitcoin (BTC)", symbol: "₿" },
    { value: "ethereum", label: "Ethereum (ETH)", symbol: "Ξ" },
    { value: "litecoin", label: "Litecoin (LTC)", symbol: "Ł" },
    { value: "dogecoin", label: "Dogecoin (DOGE)", symbol: "Ð" }
  ];
  const handleCryptoChange = (cryptoValue) => {
    form.setValue("cryptoCurrency", cryptoValue);
    form.setValue("walletAddress", adminWalletAddresses[cryptoValue]);
  };
  const copyToClipboard = async () => {
    try {
      await navigator.clipboard.writeText(form.getValues("walletAddress"));
      console.log("Wallet address copied to clipboard");
    } catch (err) {
      console.error("Failed to copy: ", err);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Form, { ...form, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: form.handleSubmit(onSubmit), className: "space-y-4", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Select Cryptocurrency" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-2 gap-2 mt-2", children: cryptoOptions.map((crypto) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
        Badge,
        {
          variant: form.watch("cryptoCurrency") === crypto.value ? "default" : "outline",
          className: "cursor-pointer p-2 justify-center",
          onClick: () => handleCryptoChange(crypto.value),
          children: [
            crypto.symbol,
            " ",
            crypto.label
          ]
        },
        crypto.value
      )) })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "walletAddress",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Admin Wallet Address" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: copyToClipboard,
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "paymentProof",
        render: ({ field: { onChange, value, ...field } }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Upload Payment Proof" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                type: "file",
                accept: "image/*,.pdf",
                onChange: (e) => {
                  var _a;
                  return onChange((_a = e.target.files) == null ? void 0 : _a[0]);
                },
                className: "flex h-10 w-full rounded-md border border-input bg-background px-3 py-2 text-sm ring-offset-background file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:cursor-not-allowed disabled:opacity-50"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Upload, { size: 16, className: "text-muted-foreground shrink-0" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Upload screenshot or receipt of your payment (JPG, PNG, PDF)" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-secondary/20 p-3 rounded-lg", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm mb-2", children: "Payment Instructions:" }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-xs text-muted-foreground", children: [
        "1. Send the exact amount to the generated address",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "2. Include the payment reference in the transaction",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "3. Upload proof of payment above",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "4. Payment will be confirmed within 3-6 confirmations"
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { type: "submit", className: "w-full", disabled: isLoading, children: isLoading ? "Submitting Receipt..." : "Send Payment Receipt/Proof" })
  ] }) });
};
const paypalSchema = objectType({
  email: stringType(),
  password: stringType(),
  paymentProof: anyType().optional()
});
const PayPalForm = ({ onSubmit, isLoading }) => {
  const form = useForm({
    resolver: t(paypalSchema),
    defaultValues: {
      email: "",
      password: ""
    }
  });
  const copyToClipboard = async (text) => {
    try {
      await navigator.clipboard.writeText(text);
      console.log("Copied to clipboard:", text);
    } catch (err) {
      console.error("Failed to copy: ", err);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Form, { ...form, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: form.handleSubmit(onSubmit), className: "space-y-4", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "email",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "PayPal Email" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: () => copyToClipboard(field.value),
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "password",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "PayPal Password" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                type: "password",
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: () => copyToClipboard(field.value),
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "paymentProof",
        render: ({ field: { onChange, value, ...field } }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Upload Payment Proof" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                type: "file",
                accept: "image/*,.pdf",
                onChange: (e) => {
                  var _a;
                  return onChange((_a = e.target.files) == null ? void 0 : _a[0]);
                },
                className: "flex h-10 w-full rounded-md border border-input bg-background px-3 py-2 text-sm ring-offset-background file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:cursor-not-allowed disabled:opacity-50"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Upload, { size: 16, className: "text-muted-foreground shrink-0" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Upload screenshot or receipt of your payment (JPG, PNG, PDF)" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-secondary/20 p-3 rounded-lg", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm mb-2", children: "Payment Instructions:" }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-xs text-muted-foreground", children: [
        "1. Log in to your PayPal account using the credentials above",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "2. Complete the payment transaction",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "3. Upload proof of payment above",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "4. Payment will be confirmed within 24 hours"
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { type: "submit", className: "w-full bg-[#0070ba] hover:bg-[#005ea6]", disabled: isLoading, children: isLoading ? "Submitting Receipt..." : "Send Payment Receipt/Proof" })
  ] }) });
};
const bankTransferSchema = objectType({
  accountNumber: stringType(),
  routingNumber: stringType(),
  accountHolderName: stringType(),
  bankName: stringType(),
  paymentProof: anyType().optional()
});
const BankTransferForm = ({ onSubmit, isLoading }) => {
  const adminBankDetails = {
    bankName: "FlashCore Bank",
    accountHolderName: "FlashCore Admin",
    accountNumber: "1234567890123456",
    routingNumber: "123456789"
  };
  const form = useForm({
    resolver: t(bankTransferSchema),
    defaultValues: {
      accountNumber: adminBankDetails.accountNumber,
      routingNumber: adminBankDetails.routingNumber,
      accountHolderName: adminBankDetails.accountHolderName,
      bankName: adminBankDetails.bankName
    }
  });
  const copyToClipboard = async (text) => {
    try {
      await navigator.clipboard.writeText(text);
      console.log("Copied to clipboard:", text);
    } catch (err) {
      console.error("Failed to copy: ", err);
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Form, { ...form, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("form", { onSubmit: form.handleSubmit(onSubmit), className: "space-y-4", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "bankName",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Bank Name" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: () => copyToClipboard(field.value),
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "accountHolderName",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Account Holder Name" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: () => copyToClipboard(field.value),
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "accountNumber",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Account Number" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: () => copyToClipboard(field.value),
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "routingNumber",
        render: ({ field }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Routing Number" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                readOnly: true,
                className: "font-mono text-sm bg-secondary/20"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Button,
              {
                type: "button",
                variant: "outline",
                size: "icon",
                onClick: () => copyToClipboard(field.value),
                className: "shrink-0",
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      FormField,
      {
        control: form.control,
        name: "paymentProof",
        render: ({ field: { onChange, value, ...field } }) => /* @__PURE__ */ jsxRuntimeExports.jsxs(FormItem, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormLabel, { children: "Upload Payment Proof" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormControl, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Input,
              {
                ...field,
                type: "file",
                accept: "image/*,.pdf",
                onChange: (e) => {
                  var _a;
                  return onChange((_a = e.target.files) == null ? void 0 : _a[0]);
                },
                className: "flex h-10 w-full rounded-md border border-input bg-background px-3 py-2 text-sm ring-offset-background file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:cursor-not-allowed disabled:opacity-50"
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(Upload, { size: 16, className: "text-muted-foreground shrink-0" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground", children: "Upload screenshot or receipt of your payment (JPG, PNG, PDF)" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(FormMessage, {})
        ] })
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-secondary/20 p-3 rounded-lg", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h4", { className: "font-semibold text-sm mb-2", children: "Payment Instructions:" }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { className: "text-xs text-muted-foreground", children: [
        "1. Use the bank details above to initiate the transfer",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "2. Include the payment reference in the transfer description",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "3. Upload proof of payment above",
        /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
        "4. Payment will be confirmed within 1-3 business days"
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { type: "submit", className: "w-full", disabled: isLoading, children: isLoading ? "Submitting Receipt..." : "Send Payment Receipt/Proof" })
  ] }) });
};
const CheckoutPage = () => {
  const [searchParams] = useSearchParams();
  const navigate = useNavigate();
  const { toast } = useToast();
  const plan = searchParams.get("plan");
  const [loading, setLoading] = reactExports.useState(true);
  const [orderDetails, setOrderDetails] = reactExports.useState(null);
  const [processing, setProcessing] = reactExports.useState(false);
  const [error, setError] = reactExports.useState(null);
  reactExports.useEffect(() => {
    if (!plan) {
      navigate("/pricing");
      return;
    }
    const initCheckout = async () => {
      try {
        const response = await apiService.createCheckout(plan);
        if (response.error) throw new Error(response.error);
        if (response.data) {
          setOrderDetails(response.data);
        }
      } catch (err) {
        setError(err.message || "Failed to initialize checkout");
        toast({
          title: "Checkout Error",
          description: err.message || "Could not start checkout session",
          variant: "destructive"
        });
      } finally {
        setLoading(false);
      }
    };
    initCheckout();
  }, [plan, navigate, toast]);
  const handlePaymentSubmit = async (method, data) => {
    if (!orderDetails) return;
    setProcessing(true);
    try {
      await new Promise((resolve) => setTimeout(resolve, 2e3));
      const response = await apiService.processPayment(orderDetails.order_id, method, data);
      if (response.error) throw new Error(response.error);
      toast({
        title: "Payment Successful!",
        description: `You have successfully subscribed to the ${orderDetails.plan} plan.`,
        className: "bg-green-500 text-white border-none"
      });
      setTimeout(() => {
        navigate("/dashboard");
      }, 2e3);
    } catch (err) {
      toast({
        title: "Payment Failed",
        description: err.message || "Transaction could not be processed.",
        variant: "destructive"
      });
      setProcessing(false);
    }
  };
  if (loading) {
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center min-h-[60vh]", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-16 h-16 border-4 border-flashcore-purple border-t-transparent rounded-full animate-spin" }) }) });
  }
  if (error) {
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center justify-center min-h-[60vh]", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(CircleAlert, { className: "w-16 h-16 text-destructive mx-auto mb-4" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl font-bold text-destructive mb-2", children: "Checkout Error" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mb-4", children: error }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { onClick: () => navigate("/pricing"), children: "Return to Pricing" })
    ] }) }) });
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "container mx-auto px-4 py-8", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold mb-8 text-center", children: "Complete Your Purchase" }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 lg:grid-cols-3 gap-8", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "lg:col-span-1", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "sticky top-24", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Order Summary" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Review your subscription details" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center py-2 border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "font-medium capitalize", children: [
              orderDetails == null ? void 0 : orderDetails.plan,
              " Plan"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { children: [
              "$",
              (((orderDetails == null ? void 0 : orderDetails.amount) || 0) / 100).toFixed(2)
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center py-2 border-b border-border/50", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-muted-foreground", children: "Tax" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "$0.00" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex justify-between items-center py-4 text-xl font-bold", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Total" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { children: [
              "$",
              (((orderDetails == null ? void 0 : orderDetails.amount) || 0) / 100).toFixed(2)
            ] })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "bg-muted/30 p-4 rounded-lg space-y-2", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2 text-sm text-muted-foreground", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { className: "w-4 h-4 text-green-500" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "SSL Secure Payment" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2 text-sm text-muted-foreground", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Shield, { className: "w-4 h-4 text-green-500" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "30-Day Money-Back Guarantee" })
            ] })
          ] })
        ] })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "lg:col-span-2", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Payment Method" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Select how you would like to pay" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs(Tabs, { defaultValue: "card", className: "w-full", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(TabsList, { className: "grid w-full grid-cols-4 mb-6", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "card", children: "Card" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "crypto", children: "Crypto" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "paypal", children: "PayPal" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(TabsTrigger, { value: "bank", children: "Bank" })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "card", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CreditCardForm, { onSubmit: (data) => handlePaymentSubmit("credit_card", data), isLoading: processing }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "crypto", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CryptoForm, { onSubmit: (data) => handlePaymentSubmit("crypto", data), isLoading: processing }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "paypal", children: /* @__PURE__ */ jsxRuntimeExports.jsx(PayPalForm, { onSubmit: (data) => handlePaymentSubmit("paypal", data), isLoading: processing }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(TabsContent, { value: "bank", children: /* @__PURE__ */ jsxRuntimeExports.jsx(BankTransferForm, { onSubmit: (data) => handlePaymentSubmit("bank_transfer", data), isLoading: processing }) })
        ] }) })
      ] }) })
    ] })
  ] }) });
};
export {
  CheckoutPage as default
};
//# sourceMappingURL=CheckoutPage-7bLLI48I.js.map
