import { r as reactExports, j as jsxRuntimeExports, I as Input, B as Button, i as Card, l as CardHeader, m as CardTitle, n as CardDescription, k as CardContent, A as ArrowRight, q as Link, v as Mail, T as TrendingUp } from "./index-dFGJiMHg.js";
import { B as Badge } from "./badge-w0XFTSDO.js";
import { B as BookOpen } from "./book-open-DugKzpVc.js";
import { S as Search } from "./search-B1vmXDJS.js";
import { U as User } from "./user-d7xPbjjb.js";
import { C as Calendar } from "./calendar-D_NP4res.js";
import { C as Clock } from "./clock-jZHyhb-c.js";
import { F as FileText } from "./file-text-DZdhJPDK.js";
import { V as Video } from "./video-fHxt0CwQ.js";
import { M as MessageSquare } from "./message-square-FQqjp8ig.js";
import { A as Award } from "./award-CMmuLhvk.js";
import { Z as Zap } from "./zap-BzUDRoi9.js";
import { C as ChartColumn } from "./chart-column-B-pc1RkE.js";
import { S as ShoppingCart } from "./shopping-cart-DfNqioM_.js";
import { B as Building } from "./building-B3F7FJiI.js";
import { T as Target } from "./target-DOPjxujo.js";
const BlogPage = () => {
  const [searchQuery, setSearchQuery] = reactExports.useState("");
  const [selectedCategory, setSelectedCategory] = reactExports.useState("all");
  const categories = [
    { id: "all", name: "All Posts", icon: BookOpen },
    { id: "email-marketing", name: "Email Marketing", icon: Mail },
    { id: "automation", name: "Automation", icon: Zap },
    { id: "analytics", name: "Analytics", icon: ChartColumn },
    { id: "ecommerce", name: "E-commerce", icon: ShoppingCart },
    { id: "enterprise", name: "Enterprise", icon: Building },
    { id: "tips", name: "Tips & Tricks", icon: Target },
    { id: "case-studies", name: "Case Studies", icon: TrendingUp }
  ];
  const featuredPosts = [
    {
      id: 1,
      title: "10 Email Marketing Strategies That Actually Work in 2024",
      excerpt: "Discover the most effective email marketing strategies that successful businesses are using to increase engagement and drive conversions in 2024.",
      author: "Sarah Johnson",
      authorRole: "Email Marketing Expert",
      date: "March 15, 2024",
      readTime: "8 min read",
      category: "email-marketing",
      image: "/blog/email-strategies-2024.jpg",
      featured: true,
      tags: ["Email Marketing", "Strategy", "2024"]
    },
    {
      id: 2,
      title: "How to Build an Automated Email Funnel That Converts",
      excerpt: "Learn how to create a powerful automated email funnel that nurtures leads and converts prospects into loyal customers.",
      author: "Michael Chen",
      authorRole: "Automation Specialist",
      date: "March 12, 2024",
      readTime: "12 min read",
      category: "automation",
      image: "/blog/automated-funnel.jpg",
      featured: true,
      tags: ["Automation", "Funnel", "Conversion"]
    },
    {
      id: 3,
      title: "The Complete Guide to Email Analytics and ROI Tracking",
      excerpt: "Master email analytics to understand your campaign performance and maximize your return on investment.",
      author: "Emily Rodriguez",
      authorRole: "Data Analyst",
      date: "March 10, 2024",
      readTime: "10 min read",
      category: "analytics",
      image: "/blog/email-analytics.jpg",
      featured: true,
      tags: ["Analytics", "ROI", "Tracking"]
    }
  ];
  const recentPosts = [
    {
      id: 4,
      title: "E-commerce Email Marketing: From Abandoned Carts to Repeat Customers",
      excerpt: "Transform your e-commerce business with strategic email marketing campaigns that recover abandoned carts and build customer loyalty.",
      author: "Lisa Chen",
      authorRole: "E-commerce Specialist",
      date: "March 8, 2024",
      readTime: "6 min read",
      category: "ecommerce",
      image: "/blog/ecommerce-email.jpg",
      tags: ["E-commerce", "Abandoned Cart", "Customer Loyalty"]
    },
    {
      id: 5,
      title: "Enterprise Email Marketing: Scaling Success for Large Organizations",
      excerpt: "Discover how enterprise companies are leveraging email marketing to scale their operations and drive growth.",
      author: "David Thompson",
      authorRole: "Enterprise Consultant",
      date: "March 5, 2024",
      readTime: "9 min read",
      category: "enterprise",
      image: "/blog/enterprise-email.jpg",
      tags: ["Enterprise", "Scaling", "Growth"]
    },
    {
      id: 6,
      title: "15 Email Subject Lines That Get Opened (With Examples)",
      excerpt: "Learn the psychology behind effective email subject lines and see real examples that drive higher open rates.",
      author: "Amanda Kim",
      authorRole: "Copywriting Expert",
      date: "March 3, 2024",
      readTime: "7 min read",
      category: "tips",
      image: "/blog/subject-lines.jpg",
      tags: ["Subject Lines", "Open Rates", "Copywriting"]
    },
    {
      id: 7,
      title: "Case Study: How Company X Increased Email Revenue by 300%",
      excerpt: "An in-depth look at how one company transformed their email marketing strategy and achieved remarkable results.",
      author: "Robert Martinez",
      authorRole: "Case Study Writer",
      date: "February 28, 2024",
      readTime: "11 min read",
      category: "case-studies",
      image: "/blog/case-study-300.jpg",
      tags: ["Case Study", "Revenue", "Strategy"]
    },
    {
      id: 8,
      title: "The Future of Email Marketing: AI, Personalization, and Automation",
      excerpt: "Explore the emerging trends in email marketing and how AI and automation are shaping the future of customer communication.",
      author: "Jennifer Williams",
      authorRole: "Technology Analyst",
      date: "February 25, 2024",
      readTime: "8 min read",
      category: "automation",
      image: "/blog/future-email.jpg",
      tags: ["AI", "Personalization", "Future"]
    },
    {
      id: 9,
      title: "GDPR Compliance: A Complete Guide for Email Marketers",
      excerpt: "Everything you need to know about GDPR compliance in email marketing to protect your business and customers.",
      author: "Mark Johnson",
      authorRole: "Legal Expert",
      date: "February 22, 2024",
      readTime: "10 min read",
      category: "tips",
      image: "/blog/gdpr-compliance.jpg",
      tags: ["GDPR", "Compliance", "Legal"]
    }
  ];
  const allPosts = [...featuredPosts, ...recentPosts];
  const filteredPosts = allPosts.filter((post) => {
    const matchesSearch = post.title.toLowerCase().includes(searchQuery.toLowerCase()) || post.excerpt.toLowerCase().includes(searchQuery.toLowerCase()) || post.tags.some((tag) => tag.toLowerCase().includes(searchQuery.toLowerCase()));
    const matchesCategory = selectedCategory === "all" || post.category === selectedCategory;
    return matchesSearch && matchesCategory;
  });
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-4xl mx-auto text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Badge, { variant: "secondary", className: "mb-4", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(BookOpen, { className: "w-3 h-3 mr-1" }),
        "Blog & Resources"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl md:text-4xl lg:text-5xl font-bold mb-6 bg-gradient-to-r from-flashcore-purple to-flashcore-green bg-clip-text text-transparent", children: "Email Marketing Insights & Resources" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg md:text-xl text-muted-foreground mb-8 max-w-2xl mx-auto", children: "Stay ahead of the curve with the latest email marketing trends, tips, and strategies from industry experts and successful businesses." }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-2xl mx-auto mb-8", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "relative", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Search, { className: "absolute left-3 top-1/2 transform -translate-y-1/2 text-muted-foreground w-5 h-5" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            type: "text",
            placeholder: "Search articles, tips, or topics...",
            value: searchQuery,
            onChange: (e) => setSearchQuery(e.target.value),
            className: "pl-10 pr-4 py-3 text-lg"
          }
        )
      ] }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-8", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-6xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-2 justify-center", children: categories.map((category) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
      Button,
      {
        variant: selectedCategory === category.id ? "default" : "outline",
        size: "sm",
        onClick: () => setSelectedCategory(category.id),
        className: "flex items-center space-x-2",
        children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(category.icon, { className: "w-4 h-4" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: category.name })
        ]
      },
      category.id
    )) }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Featured Articles" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Our most popular and insightful articles on email marketing." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: featuredPosts.map((post) => {
        var _a;
        return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "aspect-video bg-gradient-to-br from-flashcore-purple to-flashcore-green rounded-t-lg mb-4" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2 mb-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: "text-xs", children: (_a = categories.find((cat) => cat.id === post.category)) == null ? void 0 : _a.name }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: "Featured" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg group-hover:text-flashcore-purple transition-colors", children: post.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: post.excerpt })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-xs text-muted-foreground mb-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-4", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "w-3 h-3 mr-1" }),
                  post.author
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-3 h-3 mr-1" }),
                  post.date
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-3 h-3 mr-1" }),
                post.readTime
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-1 mb-4", children: post.tags.map((tag, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: tag }, index)) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", className: "w-full group-hover:bg-flashcore-purple group-hover:text-white transition-colors", children: [
              "Read Article",
              /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
            ] })
          ] })
        ] }, post.id);
      }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Latest Articles" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Fresh insights and tips from our email marketing experts." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8", children: filteredPosts.slice(3).map((post) => {
        var _a;
        return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "hover:shadow-lg transition-shadow group", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "aspect-video bg-gradient-to-br from-gray-200 to-gray-300 rounded-t-lg mb-4" }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex items-center space-x-2 mb-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "secondary", className: "text-xs", children: (_a = categories.find((cat) => cat.id === post.category)) == null ? void 0 : _a.name }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg group-hover:text-flashcore-purple transition-colors", children: post.title }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { className: "text-sm", children: post.excerpt })
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-xs text-muted-foreground mb-4", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-4", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(User, { className: "w-3 h-3 mr-1" }),
                  post.author
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Calendar, { className: "w-3 h-3 mr-1" }),
                  post.date
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-3 h-3 mr-1" }),
                post.readTime
              ] })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex flex-wrap gap-1 mb-4", children: post.tags.map((tag, index) => /* @__PURE__ */ jsxRuntimeExports.jsx(Badge, { variant: "outline", className: "text-xs", children: tag }, index)) }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", size: "sm", className: "w-full group-hover:bg-flashcore-purple group-hover:text-white transition-colors", children: [
              "Read Article",
              /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
            ] })
          ] })
        ] }, post.id);
      }) })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20", children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "max-w-4xl mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "bg-gradient-to-r from-flashcore-purple to-flashcore-green text-white", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-8 md:p-12 text-center", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Stay Updated with Email Marketing Insights" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-lg mb-6 opacity-90", children: "Get the latest email marketing tips, strategies, and industry insights delivered to your inbox." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col sm:flex-row gap-4 max-w-md mx-auto", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            type: "email",
            placeholder: "Enter your email address",
            className: "bg-white text-gray-900 placeholder-gray-500"
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "secondary", className: "bg-white text-flashcore-purple hover:bg-gray-100", children: [
          "Subscribe",
          /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowRight, { className: "w-4 h-4 ml-2" })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm opacity-75 mt-4", children: "No spam, unsubscribe at any time. We respect your privacy." })
    ] }) }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("section", { className: "container mx-auto px-4 py-12 md:py-20 bg-muted/20", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "max-w-6xl mx-auto", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center mb-12", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: "text-2xl md:text-3xl font-bold mb-4", children: "Additional Resources" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Explore more resources to help you master email marketing." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-8", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6 text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(FileText, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Email Templates" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Professional email templates for every occasion." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/templates", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Browse Templates" }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6 text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Video, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Video Tutorials" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Step-by-step video guides and tutorials." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/tutorials", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Watch Videos" }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6 text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(MessageSquare, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Community" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Connect with other email marketers." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/community", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Join Community" }) })
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "hover:shadow-lg transition-shadow", children: /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "p-6 text-center", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-lg flex items-center justify-center mx-auto mb-4", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Award, { className: "w-6 h-6 text-white" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-lg font-semibold mb-2", children: "Certification" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground mb-4", children: "Get certified in email marketing." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { to: "/certification", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "outline", size: "sm", className: "w-full", children: "Get Certified" }) })
        ] }) })
      ] })
    ] }) })
  ] });
};
export {
  BlogPage as default
};
//# sourceMappingURL=BlogPage-DkaQp4OB.js.map
