import { c as createLucideIcon, r as reactExports, b as useToast, j as jsxRuntimeExports, B as Button, R as RefreshCw, ar as DropdownMenu, as as DropdownMenuTrigger, at as DropdownMenuContent, au as DropdownMenuItem, i as Card, k as CardContent, l as CardHeader, m as CardTitle, n as CardDescription, h as CircleAlert, a as apiService } from "./index-GlGoHQS3.js";
import { A as AdminLayout } from "./AdminLayout-EP0RrNgn.js";
import { D as Database } from "./database-DQw_2NHO.js";
import { P as Plus } from "./plus-DOE21YSp.js";
import { C as ChevronDown } from "./chevron-down-CfVNtG1C.js";
import { C as Clock } from "./clock-zJerAcLz.js";
import { D as Download } from "./download-CHBAWzqC.js";
import { T as Trash2 } from "./trash-2-B9sMlXbp.js";
import { C as CircleCheck } from "./circle-check-00p8zBHl.js";
import "./search-qyfysnCX.js";
import "./bell-Cjo9wTHb.js";
import "./key-D11V0gzH.js";
import "./users-y32J9_iP.js";
import "./settings-CxhYnKqf.js";
import "./log-out-Db4Ugg5P.js";
import "./dollar-sign-RQF0vkGN.js";
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const FileArchive = createLucideIcon("FileArchive", [
  ["path", { d: "M10 12v-1", key: "v7bkov" }],
  ["path", { d: "M10 18v-2", key: "1cjy8d" }],
  ["path", { d: "M10 7V6", key: "dljcrl" }],
  ["path", { d: "M14 2v4a2 2 0 0 0 2 2h4", key: "tnqrlb" }],
  [
    "path",
    { d: "M15.5 22H18a2 2 0 0 0 2-2V7l-5-5H6a2 2 0 0 0-2 2v16a2 2 0 0 0 .274 1.01", key: "gkbcor" }
  ],
  ["circle", { cx: "10", cy: "20", r: "2", key: "1xzdoj" }]
]);
/**
 * @license lucide-react v0.462.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const FileJson = createLucideIcon("FileJson", [
  ["path", { d: "M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z", key: "1rqfz7" }],
  ["path", { d: "M14 2v4a2 2 0 0 0 2 2h4", key: "tnqrlb" }],
  [
    "path",
    { d: "M10 12a1 1 0 0 0-1 1v1a1 1 0 0 1-1 1 1 1 0 0 1 1 1v1a1 1 0 0 0 1 1", key: "1oajmo" }
  ],
  [
    "path",
    { d: "M14 18a1 1 0 0 0 1-1v-1a1 1 0 0 1 1-1 1 1 0 0 1-1-1v-1a1 1 0 0 0-1-1", key: "mpwhp6" }
  ]
]);
const AdminBackupPage = () => {
  const [backups, setBackups] = reactExports.useState([]);
  const [loading, setLoading] = reactExports.useState(true);
  const [creating, setCreating] = reactExports.useState(false);
  const [restoring, setRestoring] = reactExports.useState(false);
  const [progress, setProgress] = reactExports.useState(0);
  const [progressMessage, setProgressMessage] = reactExports.useState("");
  const { toast } = useToast();
  const fetchBackups = async () => {
    setLoading(true);
    console.log("Fetching backups...");
    try {
      const response = await apiService.listBackups();
      console.log("Backup response:", response);
      if (response.error) {
        console.error("Backup fetch error:", response.error);
        throw new Error(response.error);
      }
      const data = Array.isArray(response.data) ? response.data : [];
      console.log("Backups data:", data);
      setBackups(data);
    } catch (error) {
      console.error("Fetch backups exception:", error);
      toast({
        title: "Error",
        description: error instanceof Error ? error.message : "Failed to load backups",
        variant: "destructive"
      });
    } finally {
      setLoading(false);
    }
  };
  reactExports.useEffect(() => {
    fetchBackups();
  }, []);
  const handleCreateBackup = async (type) => {
    setCreating(true);
    setProgress(0);
    setProgressMessage("Initializing backup...");
    try {
      const progressInterval = setInterval(() => {
        setProgress((prev) => {
          if (prev >= 90) return prev;
          return prev + 10;
        });
      }, 300);
      setProgressMessage(`Creating ${type === "split" ? "split" : type === "full" ? "full system" : "database"} backup...`);
      const response = await apiService.createBackup(type);
      clearInterval(progressInterval);
      setProgress(100);
      setProgressMessage("Backup completed!");
      if (response.error) throw new Error(response.error);
      toast({
        title: "Success",
        description: `${type === "split" ? "Split" : type === "full" ? "Full system" : "Database"} backup created successfully`
      });
      setTimeout(() => {
        setProgress(0);
        setProgressMessage("");
        fetchBackups();
      }, 1e3);
    } catch (error) {
      setProgress(0);
      setProgressMessage("");
      toast({
        title: "Error",
        description: error instanceof Error ? error.message : "Backup failed",
        variant: "destructive"
      });
    } finally {
      setCreating(false);
    }
  };
  const handleRestoreBackup = async (filename) => {
    var _a, _b;
    if (!confirm(`⚠️ WARNING: This will restore the system from backup "${filename}".

A safety backup will be created automatically.

Are you sure you want to proceed?`)) return;
    setRestoring(true);
    setProgress(0);
    setProgressMessage("Creating safety backup...");
    try {
      const progressInterval = setInterval(() => {
        setProgress((prev) => {
          if (prev >= 90) return prev;
          return prev + 15;
        });
      }, 400);
      setProgressMessage("Restoring from backup...");
      const response = await apiService.restoreBackup(filename);
      clearInterval(progressInterval);
      setProgress(100);
      setProgressMessage("Restore completed!");
      if (response.error) throw new Error(response.error);
      toast({
        title: "Success",
        description: ((_a = response.data) == null ? void 0 : _a.message) || "Backup restored successfully"
      });
      if ((_b = response.data) == null ? void 0 : _b.note) {
        toast({
          title: "Important",
          description: response.data.note,
          variant: "default"
        });
      }
      setTimeout(() => {
        setProgress(0);
        setProgressMessage("");
        fetchBackups();
      }, 2e3);
    } catch (error) {
      setProgress(0);
      setProgressMessage("");
      toast({
        title: "Error",
        description: error instanceof Error ? error.message : "Restore failed",
        variant: "destructive"
      });
    } finally {
      setRestoring(false);
    }
  };
  const handleDeleteBackup = async (filename) => {
    if (!confirm(`Are you sure you want to delete backup ${filename}?`)) return;
    try {
      const response = await apiService.deleteBackup(filename);
      if (response.error) throw new Error(response.error);
      toast({
        title: "Deleted",
        description: "Backup archive removed"
      });
      fetchBackups();
    } catch (error) {
      toast({
        title: "Error",
        description: error instanceof Error ? error.message : "Deletion failed",
        variant: "destructive"
      });
    }
  };
  const formatSize = (bytes) => {
    if (bytes === 0) return "0 Bytes";
    const k = 1024;
    const sizes = ["Bytes", "KB", "MB", "GB"];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + " " + sizes[i];
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsx(AdminLayout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "container mx-auto p-6 space-y-6", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col md:flex-row md:items-center justify-between gap-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("h1", { className: "text-3xl font-bold flex items-center gap-2", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Database, { className: "w-8 h-8 text-flashcore-purple" }),
          "Backup & Recovery"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground mt-1", children: "Manage database snapshots and system backups for disaster recovery." })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Button, { variant: "outline", onClick: fetchBackups, disabled: loading, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { className: `w-4 h-4 mr-2 ${loading ? "animate-spin" : ""}` }),
          "Refresh"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenu, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(DropdownMenuTrigger, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { disabled: creating, children: creating ? /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { className: "w-4 h-4 mr-2 animate-spin" }),
            "Creating..."
          ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Plus, { className: "w-4 h-4 mr-2" }),
            "Create Backup",
            /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronDown, { className: "w-4 h-4 ml-2 opacity-50" })
          ] }) }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenuContent, { align: "end", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenuItem, { onClick: () => handleCreateBackup("db"), children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Database, { className: "w-4 h-4 mr-2" }),
              "Database Snapshot"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenuItem, { onClick: () => handleCreateBackup("full"), children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(FileArchive, { className: "w-4 h-4 mr-2" }),
              "Full System Archive"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs(DropdownMenuItem, { onClick: () => handleCreateBackup("split"), children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(FileArchive, { className: "w-4 h-4 mr-2" }),
              "Split Backup (Fast)"
            ] })
          ] })
        ] })
      ] })
    ] }),
    (creating || restoring || progress > 0) && /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "border-blue-500/50 bg-blue-500/5", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "pt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-3", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between text-sm", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "font-medium", children: progressMessage }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "text-muted-foreground", children: [
          progress,
          "%"
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-full h-2 bg-accent rounded-full overflow-hidden", children: /* @__PURE__ */ jsxRuntimeExports.jsx(
        "div",
        {
          className: "h-full bg-gradient-to-r from-blue-500 to-purple-600 transition-all duration-300 ease-out",
          style: { width: `${progress}%` }
        }
      ) })
    ] }) }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid grid-cols-1 md:grid-cols-3 gap-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "md:col-span-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Backup History" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "A list of all available database snapshots." })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { children: loading ? /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "flex justify-center py-12", children: /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { className: "w-8 h-8 animate-spin text-flashcore-purple" }) }) : backups.length === 0 ? /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "text-center py-12 border-2 border-dashed rounded-xl", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(Database, { className: "w-12 h-12 text-muted-foreground mx-auto mb-4 opacity-20" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "No backups found." }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { variant: "link", onClick: () => handleCreateBackup("db"), className: "mt-2 text-flashcore-purple", children: "Create your first backup now" })
        ] }) : /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "overflow-x-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("table", { className: "w-full", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("thead", { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "border-b text-sm font-medium text-muted-foreground", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "text-left py-3 px-4", children: "Filename" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "text-left py-3 px-4", children: "Date Created" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "text-left py-3 px-4", children: "Size" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("th", { className: "text-right py-3 px-4", children: "Actions" })
          ] }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("tbody", { className: "divide-y", children: backups.map((backup) => /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { className: "hover:bg-muted/50 transition-colors", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "py-4 px-4 font-mono text-xs max-w-[200px] truncate", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-2", children: [
              backup.type === "full" ? /* @__PURE__ */ jsxRuntimeExports.jsx(FileArchive, { className: "w-4 h-4 text-amber-500" }) : /* @__PURE__ */ jsxRuntimeExports.jsx(Database, { className: "w-4 h-4 text-blue-500" }),
              backup.filename
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "py-4 px-4 text-sm", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "flex items-center gap-1", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Clock, { className: "w-3 h-3 opacity-50" }),
              backup.created_at
            ] }) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "py-4 px-4 text-sm font-medium", children: formatSize(backup.size) }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("td", { className: "py-4 px-4 text-right", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-end gap-2", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "a",
                {
                  href: `${"/fcorex"}/backend/api/backups.php?action=download&filename=${backup.filename}`,
                  target: "_blank",
                  rel: "noopener noreferrer",
                  className: "inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 border border-input bg-background hover:bg-accent hover:text-accent-foreground h-9 w-9",
                  title: "Download",
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { className: "h-4 w-4" })
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Button,
                {
                  variant: "outline",
                  size: "icon",
                  className: "text-green-600 hover:bg-green-500/10",
                  onClick: () => handleRestoreBackup(backup.filename),
                  disabled: restoring,
                  title: "Restore",
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { className: "h-4 w-4" })
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Button,
                {
                  variant: "outline",
                  size: "icon",
                  className: "text-destructive hover:bg-destructive/10",
                  onClick: () => handleDeleteBackup(backup.filename),
                  title: "Delete",
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(Trash2, { className: "h-4 w-4" })
                }
              )
            ] }) })
          ] }, backup.filename)) })
        ] }) }) })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Storage Health" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-3 bg-green-500/10 rounded-lg border border-green-500/20", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheck, { className: "w-5 h-5 text-green-500" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm font-medium", children: "Permissions" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xs font-bold text-green-500", children: "Writable" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center justify-between p-3 bg-blue-500/10 rounded-lg border border-blue-500/20", children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center gap-3", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(CircleAlert, { className: "w-5 h-5 text-blue-500" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-sm font-medium", children: "Protection" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "text-xs font-bold text-blue-500", children: "Locked" })
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "pt-2", children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground leading-relaxed", children: "Backups are stored in a secured directory protected by .htaccess. Recommended frequency: **Daily**." }) })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "bg-gradient-to-br from-flashcore-purple/10 via-background to-flashcore-green/10 border-flashcore-purple/20", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(CardHeader, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { className: "text-lg", children: "Quick Tip" }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-sm text-muted-foreground italic leading-relaxed", children: '"Always verify your backups after creation. A backup that cannot be restored is no backup at all."' }),
            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "mt-4 flex justify-end", children: /* @__PURE__ */ jsxRuntimeExports.jsx(FileJson, { className: "w-8 h-8 opacity-20" }) })
          ] })
        ] })
      ] })
    ] })
  ] }) });
};
export {
  AdminBackupPage as default
};
//# sourceMappingURL=AdminBackupPage-nmOCjp9a.js.map
