import { r as reactExports, b as useToast, g as useSubscriptionStatusPhp, y as React, j as jsxRuntimeExports, i as Card, k as CardContent, C as CircleCheckBig, B as Button, l as CardHeader, m as CardTitle, n as CardDescription, t as Label, I as Input, a as apiService, L as Layout } from "./index-dFGJiMHg.js";
import { K as Key } from "./key-1dz9sJTd.js";
const LicenseActivation = () => {
  const [licenseKey, setLicenseKey] = reactExports.useState("");
  const [loading, setLoading] = reactExports.useState(false);
  const [activated, setActivated] = reactExports.useState(false);
  const { toast } = useToast();
  const { isActivated, refreshStatus } = useSubscriptionStatusPhp();
  React.useEffect(() => {
    if (isActivated) {
      setActivated(true);
    }
  }, [isActivated]);
  const activateLicense = async () => {
    var _a, _b;
    if (!licenseKey.trim()) {
      toast({
        title: "Error",
        description: "Please enter a license key",
        variant: "destructive"
      });
      return;
    }
    setLoading(true);
    try {
      const response = await apiService.activateLicense(licenseKey.trim());
      if (response.error) throw new Error(response.error);
      if ((_a = response.data) == null ? void 0 : _a.success) {
        toast({
          title: "Success!",
          description: `License activated successfully! You now have ${response.data.tier} access.`
        });
        setActivated(true);
        refreshStatus();
        setLicenseKey("");
      } else {
        toast({
          title: "Activation Failed",
          description: ((_b = response.data) == null ? void 0 : _b.message) || "Invalid license key",
          variant: "destructive"
        });
      }
    } catch (error) {
      toast({
        title: "Error",
        description: "Failed to activate license key",
        variant: "destructive"
      });
    } finally {
      setLoading(false);
    }
  };
  if (activated) {
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Card, { className: "max-w-md mx-auto", children: /* @__PURE__ */ jsxRuntimeExports.jsx(CardContent, { className: "pt-6", children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center text-center space-y-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { className: "w-16 h-16 text-green-500" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: "text-xl font-semibold", children: "License Activated!" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Your license has been successfully activated. You can now access all premium features." }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(Button, { onClick: () => setActivated(false), variant: "outline", children: "Activate Another License" })
    ] }) }) });
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(Card, { className: "max-w-md mx-auto", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs(CardHeader, { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex items-center space-x-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Key, { className: "w-6 h-6" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(CardTitle, { children: "Activate License Key" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(CardDescription, { children: "Enter your license key to activate your subscription" })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(CardContent, { className: "space-y-4", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Label, { htmlFor: "license", children: "License Key" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Input,
          {
            id: "license",
            placeholder: "XXXX-XXXX-XXXX-XXXX-XXXX",
            value: licenseKey,
            onChange: (e) => setLicenseKey(e.target.value.toUpperCase()),
            className: "font-mono"
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        Button,
        {
          onClick: activateLicense,
          disabled: loading || !licenseKey.trim(),
          className: "w-full",
          children: loading ? "Activating..." : "Activate License"
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-xs text-muted-foreground text-center", children: "License keys are provided after purchase or can be obtained from your administrator." })
    ] })
  ] });
};
const ActivationPage = () => {
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Layout, { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "space-y-6 max-w-2xl mx-auto", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "flex flex-col items-center gap-3 text-center mb-6", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "w-12 h-12 bg-gradient-to-r from-flashcore-purple to-flashcore-green rounded-xl flex items-center justify-center shadow-lg shadow-purple-500/20", children: /* @__PURE__ */ jsxRuntimeExports.jsx(Key, { className: "w-7 h-7 text-white" }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { className: "text-3xl font-bold", children: "License Activation" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: "text-muted-foreground", children: "Finalize your setup to unlock the FlashCore Engine" })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(LicenseActivation, {})
  ] }) });
};
export {
  ActivationPage as default
};
//# sourceMappingURL=ActivationPage-D_zPJv_N.js.map
