<?php
/**
 * Professional FlashCORE Email Template
 */

function getBrandedTemplate($content, $subject = 'Notification') {
    $purple = '#8b5cf6';
    $green = '#10b981';
    $dark = '#18181b';
    $light = '#f4f4f5';
    
    // URL Construction
    // 1. Try APP_URL from environment (Best for production)
    $appUrl = getenv('APP_URL');
    
    // 2. Fallback to dynamic host detection
    if (!$appUrl) {
        $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'] ?? 'flashcore.com';
        $appUrl = "$protocol://$host";
    }

    // Use project asset logo
    $logoUrl = rtrim($appUrl, '/') . "/images/logo.png";
    
    return "
    <!DOCTYPE html>
    <html lang='en'>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <style>
            body { font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; line-height: 1.6; color: $dark; margin: 0; padding: 0; background-color: $light; }
            .wrapper { width: 100%; max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 12px; overflow: hidden; margin-top: 40px; margin-bottom: 40px; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1); }
            .header { background: linear-gradient(135deg, $purple 0%, #7c3aed 100%); padding: 40px 20px; text-align: center; color: white; }
            .logo-container { margin-bottom: 20px; }
            .logo { width: 80px; height: 80px; border-radius: 16px; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.2); background-color: white; padding: 10px; display: inline-block; }
            .header h1 { margin: 0; font-size: 32px; font-weight: 800; letter-spacing: -0.025em; text-transform: uppercase; }
            .content { padding: 40px; }
            .content h2 { color: $purple; margin-top: 0; font-size: 20px; }
            .footer { background-color: #fafafa; padding: 30px 20px; text-align: center; font-size: 12px; color: #71717a; border-top: 1px solid #f1f1f1; }
            .button { display: inline-block; padding: 12px 24px; background-color: $purple; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin-top: 20px; }
            .accent { color: $green; font-weight: bold; }
        </style>
    </head>
    <body>
        <div class='wrapper'>
            <div class='header'>
                <div class='logo-container'>
                    <img src='$logoUrl' alt='FlashCORE Logo' class='logo' />
                </div>
                <h1>Flash<span style='color: $green;'>CORE</span></h1>
            </div>
            <div class='content'>
                $content
            </div>
            <div class='footer'>
                <p>&copy; " . date('Y') . " FlashCORE Engine. All rights reserved.</p>
                <p>Professional Email Marketing & Analytics Platform</p>
                <div style='margin-top: 10px;'>
                    <a href='#' style='color: $purple; text-decoration: none;'>Support</a> | 
                    <a href='#' style='color: $purple; text-decoration: none;'>Privacy Policy</a>
                </div>
            </div>
        </div>
    </body>
    </html>";
}
?>
