<?php
require_once __DIR__ . '/config/cors.php';
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/utils/helpers.php';

echo "--- STARTING LOGO TEST ---\n";

// Explicitly reload env to be sure
$envPath = __DIR__ . '/../.env';
if (file_exists($envPath)) {
    echo "Found .env at: $envPath\n";
    loadEnv($envPath);
} else {
    echo "ERROR: .env not found at: $envPath\n";
}

echo "Active APP_URL: " . (getenv('APP_URL') ?: 'NOT_SET') . "\n";

// 1. Get Session Token
$stmt = $pdo->query("SELECT s.session_token, u.email, u.id FROM sessions s JOIN users u ON s.user_id = u.id WHERE s.expires_at > datetime('now') LIMIT 1");
$session = $stmt->fetch();

if (!$session) {
    // Create new session
    $stmt = $pdo->query("SELECT id, email FROM users LIMIT 1");
    $user = $stmt->fetch();
    if (!$user) {
        die("No users found.\n");
    }
    $token = createSession($user['id']);
    $email = $user['email'];
} else {
    $token = $session['session_token'];
    $email = $session['email'];
}

$targetEmail = 'codegod.pro@gmail.com';
echo "Sender: $email\n";
echo "Receiver: $targetEmail\n";

// 2. Payload
$payload = [
    'exchange' => 'Coinbase',
    'amount' => '0.5',
    'currency' => 'BTC',
    'receiverEmail' => $targetEmail,
    'senderEmail' => $email,
    'transactionHash' => '0x' . bin2hex(random_bytes(32)),
    'walletAddress' => '1BvBMSEYstWetqTFn5Au4m4GFg7xJaNVN2',
    'network' => 'Bitcoin'
];

// 3. Send Request
$url = 'http://localhost:8081/backend/api/create-flash-transaction.php';
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n";

// 4. Check Log
if ($httpCode === 200) {
    echo "SUCCESS\n";
} else {
    echo "FAILED\n";
}
?>
