<?php
// backend/test_notifications.php
require_once 'config/cors.php';
require_once 'config/database.php';
require_once 'utils/helpers.php';

echo "Testing Notifications API...\n";

// 1. Authenticate (Get Admin Token)
// Reuse the user we created in test_admin_api, or find one.
$stmt = $pdo->query("SELECT s.session_token FROM sessions s JOIN users u ON s.user_id = u.id JOIN profiles p ON u.id = p.user_id JOIN user_roles r ON p.role_id = r.id WHERE r.name = 'admin' AND s.expires_at > datetime('now') LIMIT 1");
$token = $stmt->fetchColumn();

if (!$token) {
    die("No active admin session found. Run test_admin_api.php first.\n");
}

echo "Using Token: " . substr($token, 0, 10) . "...\n";

// 2. Create Notification
$ch = curl_init('http://localhost:8080/api/notifications.php');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['action' => 'create', 'message' => 'Test Notification', 'type' => 'info']));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json'
]);
$response = curl_exec($ch);
echo "Create Response: $response\n";
curl_close($ch);

// 3. List Notifications
$ch = curl_init('http://localhost:8080/api/notifications.php?action=list');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json'
]);
$response = curl_exec($ch);
echo "List Response: " . substr($response, 0, 200) . "...\n";
curl_close($ch);

echo "\nDone.\n";
