<?php
/**
 * Test script for Robust Mailer
 */
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/utils/helpers.php';
require_once __DIR__ . '/utils/mailer.php';

echo "Starting Mailer Test...\n";

// Use a real email for testing if possible, or a dummy
$testEmail = 'test@example.com';
$testSubject = 'Mailer Test ' . date('Y-m-d H:i:s');
$testBody = '<h1>Test Successful</h1><p>This is a test of the robust mailer system.</p>';

$result = sendRobustEmail($testEmail, $testSubject, $testBody);

echo "Result:\n";
print_r($result);

echo "\nCheck mail_activity table for log entry.\n";

$stmt = $pdo->prepare("SELECT * FROM mail_activity ORDER BY created_at DESC LIMIT 1");
$stmt->execute();
$log = $stmt->fetch();

echo "Latest Log Entry:\n";
print_r($log);
