<?php
// backend/seed_pricing.php

require_once __DIR__ . '/config/database.php';

try {
    // 1. Create table if not exists (in case schema wasn't run)
    $pdo->exec("
    CREATE TABLE IF NOT EXISTS pricing_plans (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name VARCHAR(50) NOT NULL,
        price VARCHAR(20) NOT NULL,
        description TEXT,
        features_json TEXT, 
        not_included_json TEXT, 
        is_popular BOOLEAN DEFAULT 0,
        color_gradient VARCHAR(100),
        button_text VARCHAR(50),
        order_index INTEGER DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    // 2. Check if plans exist
    $stmt = $pdo->query("SELECT COUNT(*) FROM pricing_plans");
    if ($stmt->fetchColumn() > 0) {
        echo "Pricing plans already seeded.\n";
        exit;
    }

    // 3. Insert default plans
    $plans = [
        [
            'name' => 'Basic',
            'price' => '$9.99',
            'description' => 'Perfect for small businesses',
            'features' => json_encode([
                "1,000 emails per month",
                "Basic email templates",
                "Email analytics",
                "24/7 support",
                "Standard delivery",
                "Basic reporting"
            ]),
            'not_included' => json_encode([
                "Advanced templates",
                "Custom branding",
                "API access",
                "Priority support"
            ]),
            'is_popular' => 0,
            'color_gradient' => 'from-flashcore-purple to-flashcore-green',
            'button_text' => 'Get Basic',
            'order_index' => 1
        ],
        [
            'name' => 'Pro',
            'price' => '$29.99',
            'description' => 'For growing businesses',
            'features' => json_encode([
                "10,000 emails per month",
                "Advanced email templates",
                "Advanced analytics",
                "Priority support",
                "Custom branding",
                "Advanced reporting",
                "A/B testing",
                "Automation workflows"
            ]),
            'not_included' => json_encode([
                "Unlimited emails",
                "Dedicated support",
                "Custom integrations"
            ]),
            'is_popular' => 1,
            'color_gradient' => 'from-flashcore-green to-flashcore-purple',
            'button_text' => 'Upgrade to Pro',
            'order_index' => 2
        ],
        [
            'name' => 'Enterprise',
            'price' => '$99.99',
            'description' => 'For large organizations',
            'features' => json_encode([
                "Unlimited emails",
                "Custom email templates",
                "Advanced reporting",
                "Dedicated support",
                "API access",
                "Custom integrations",
                "White-label options",
                "Advanced security"
            ]),
            'not_included' => json_encode([]),
            'is_popular' => 0,
            'color_gradient' => 'from-flashcore-orange to-flashcore-purple',
            'button_text' => 'Contact Sales',
            'order_index' => 3
        ]
    ];

    $insert = $pdo->prepare("INSERT INTO pricing_plans (name, price, description, features_json, not_included_json, is_popular, color_gradient, button_text, order_index) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

    foreach ($plans as $p) {
        $insert->execute([
            $p['name'], $p['price'], $p['description'], $p['features'], $p['not_included'], 
            $p['is_popular'], $p['color_gradient'], $p['button_text'], $p['order_index']
        ]);
    }

    echo "Pricing plans seeded successfully.\n";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
